/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.server.NetworkServer;
import org.filesys.server.SessionHandlerBase;

public abstract class RpcChannelSessionHandler
extends SessionHandlerBase {
    private ServerSocketChannel m_srvSockChannel;

    public RpcChannelSessionHandler(String name, String protocol, NetworkServer server, InetAddress addr, int port) {
        super(name, protocol, server, addr, port);
    }

    public final ServerSocketChannel getSocketChannel() {
        return this.m_srvSockChannel;
    }

    @Override
    public void initializeSessionHandler(NetworkServer server) throws IOException {
        this.m_srvSockChannel = ServerSocketChannel.open();
        InetSocketAddress sockAddr = null;
        sockAddr = this.hasBindAddress() ? new InetSocketAddress(this.getBindAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.m_srvSockChannel.socket().bind(sockAddr, this.getListenBacklog());
        if (this.getPort() == 0) {
            this.setPort(this.m_srvSockChannel.socket().getLocalPort());
        }
        if (this.hasDebug()) {
            Debug.print("[" + this.getProtocolName() + "] Binding " + this.getHandlerName() + " session handler to address : ");
            if (this.hasBindAddress()) {
                Debug.println(this.getBindAddress().getHostAddress());
            } else {
                Debug.println("ALL");
            }
        }
    }

    @Override
    public void closeSessionHandler(NetworkServer server) {
        this.setShutdown(true);
        try {
            if (this.m_srvSockChannel != null) {
                this.m_srvSockChannel.close();
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract RpcPacketHandler createPacketHandler(SocketChannel var1) throws IOException;
}

