/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.v3;

import java.util.HashMap;
import java.util.Map;

public class NFS3 {
    public static final int ProgramId = 100003;
    public static final int VersionId = 3;
    public static final int LenAttributes3 = 84;
    public static final int LenPostOpAttr3 = 88;
    public static final int FileHandleSize = 32;
    public static final int WriteVerfSize = 8;
    public static final int CreateVerfSize = 8;
    public static final int CookieVerfSize = 8;
    public static final int FileSysLink = 1;
    public static final int FileSysSymLink = 2;
    public static final int FileSysHomogeneuos = 4;
    public static final int FileSysCanSetTime = 8;
    public static final int AccessRead = 1;
    public static final int AccessLookup = 2;
    public static final int AccessModify = 4;
    public static final int AccessExtend = 8;
    public static final int AccessDelete = 16;
    public static final int AccessExecute = 32;
    public static final int AccessAll = 63;

    public static enum SetAttrTimestamp {
        DoNotSet(0),
        TimeServer(1),
        TimeClient(2),
        Invalid(65535);

        private final int setTime;

        private SetAttrTimestamp(int setAttr) {
            this.setTime = setAttr;
        }

        public final int intValue() {
            return this.setTime;
        }

        public static final SetAttrTimestamp fromInt(int setVal) {
            SetAttrTimestamp setAttr = Invalid;
            switch (setVal) {
                case 0: {
                    setAttr = DoNotSet;
                    break;
                }
                case 1: {
                    setAttr = TimeServer;
                    break;
                }
                case 2: {
                    setAttr = TimeClient;
                }
            }
            return setAttr;
        }
    }

    public static enum WriteStable {
        Unstable(0),
        DataSync(1),
        FileSync(2),
        Invalid(65535);

        private final int writeStable;

        private WriteStable(int wrStable) {
            this.writeStable = wrStable;
        }

        public final int intValue() {
            return this.writeStable;
        }

        public static final WriteStable fromInt(int wrVal) {
            WriteStable wrStable = Invalid;
            switch (wrVal) {
                case 0: {
                    wrStable = Unstable;
                    break;
                }
                case 1: {
                    wrStable = DataSync;
                    break;
                }
                case 2: {
                    wrStable = FileSync;
                }
            }
            return wrStable;
        }
    }

    public static enum CreateMode {
        Unchecked(1),
        Guarded(2),
        Exclusive(3),
        Invalid(65535);

        private final int createMode;

        private CreateMode(int mode) {
            this.createMode = mode;
        }

        public final int intValue() {
            return this.createMode;
        }

        public static final CreateMode fromInt(int mode) {
            CreateMode cMode = Invalid;
            switch (mode) {
                case 1: {
                    cMode = Unchecked;
                    break;
                }
                case 2: {
                    cMode = Guarded;
                    break;
                }
                case 3: {
                    cMode = Exclusive;
                }
            }
            return cMode;
        }
    }

    public static enum FileType {
        Regular(1),
        Directory(2),
        Block(3),
        Character(4),
        Link(5),
        Socket(6),
        Fifo(7),
        Invalid(65535);

        private final int fileType;

        private FileType(int typ) {
            this.fileType = typ;
        }

        public final int intValue() {
            return this.fileType;
        }

        public static final FileType fromInt(int typ) {
            FileType fType = Invalid;
            switch (typ) {
                case 1: {
                    fType = Regular;
                    break;
                }
                case 2: {
                    fType = Directory;
                    break;
                }
                case 3: {
                    fType = Block;
                    break;
                }
                case 4: {
                    fType = Character;
                    break;
                }
                case 5: {
                    fType = Link;
                    break;
                }
                case 6: {
                    fType = Socket;
                    break;
                }
                case 7: {
                    fType = Fifo;
                }
            }
            return fType;
        }
    }

    public static enum StatusCode {
        Success(0),
        Perm(1),
        NoEnt(2),
        IO(5),
        NxIO(6),
        Access(13),
        Exist(17),
        XDev(18),
        NoDev(19),
        NotDir(20),
        IsDir(21),
        InVal(22),
        FBig(27),
        NoSpc(28),
        ROFS(30),
        MLink(31),
        NameTooLong(63),
        NotEmpty(66),
        DQuot(69),
        Stale(70),
        Remote(71),
        BadHandle(10001),
        NotSync(10002),
        BadCookie(10003),
        NotSupp(10004),
        TooSmall(10005),
        ServerFault(10006),
        BadType(10007),
        JukeBox(10008),
        Invalid(65535);

        private final int stsCode;
        private static Map<Integer, StatusCode> _stsMap;

        private StatusCode(int id) {
            this.stsCode = id;
        }

        public final int intValue() {
            return this.stsCode;
        }

        public static final StatusCode fromInt(int sts) {
            if (_stsMap.containsKey(sts)) {
                return _stsMap.get(sts);
            }
            return Invalid;
        }

        public final String getStatusString() {
            String str = null;
            switch (this) {
                case Success: {
                    str = "Success status";
                    break;
                }
                case Access: {
                    str = "Access denied";
                    break;
                }
                case BadCookie: {
                    str = "Bad cookie";
                    break;
                }
                case BadHandle: {
                    str = "Bad handle";
                    break;
                }
                case BadType: {
                    str = "Bad type";
                    break;
                }
                case DQuot: {
                    str = "Quota exceeded";
                    break;
                }
                case Perm: {
                    str = "No permission";
                    break;
                }
                case Exist: {
                    str = "Already exists";
                    break;
                }
                case FBig: {
                    str = "File too large";
                    break;
                }
                case InVal: {
                    str = "Invalid argument";
                    break;
                }
                case IO: {
                    str = "I/O error";
                    break;
                }
                case IsDir: {
                    str = "Is directory";
                    break;
                }
                case JukeBox: {
                    str = "Jukebox";
                    break;
                }
                case MLink: {
                    str = "Too many hard links";
                    break;
                }
                case NameTooLong: {
                    str = "Name too long";
                    break;
                }
                case NoDev: {
                    str = "No such device";
                    break;
                }
                case NoEnt: {
                    str = "No entity";
                    break;
                }
                case NoSpc: {
                    str = "No space left on device";
                    break;
                }
                case NotSync: {
                    str = "Update synchronization mismatch";
                    break;
                }
                case NotDir: {
                    str = "Not directory";
                    break;
                }
                case NotEmpty: {
                    str = "Not empty";
                    break;
                }
                case NotSupp: {
                    str = "Not supported";
                    break;
                }
                case NxIO: {
                    str = "Nxio";
                    break;
                }
                case Remote: {
                    str = "Too many levels of remote in path";
                    break;
                }
                case ROFS: {
                    str = "Readonly filesystem";
                    break;
                }
                case ServerFault: {
                    str = "Server fault";
                    break;
                }
                case Stale: {
                    str = "Stale";
                    break;
                }
                case TooSmall: {
                    str = "Too small";
                    break;
                }
                case XDev: {
                    str = "Cross device hard link attempted";
                }
            }
            return str;
        }

        static {
            _stsMap = new HashMap<Integer, StatusCode>();
            for (StatusCode sts : StatusCode.values()) {
                _stsMap.put(sts.intValue(), sts);
            }
        }
    }

    public static enum ProcedureId {
        Null(0),
        GetAttr(1),
        SetAttr(2),
        Lookup(3),
        Access(4),
        ReadLink(5),
        Read(6),
        Write(7),
        Create(8),
        MkDir(9),
        SymLink(10),
        MkNode(11),
        Remove(12),
        RmDir(13),
        Rename(14),
        Link(15),
        ReadDir(16),
        ReadDirPlus(17),
        FsStat(18),
        FsInfo(19),
        PathConf(20),
        Commit(21),
        Invalid(65535);

        private final int procId;
        private static Map<Integer, ProcedureId> _idMap;

        private ProcedureId(int id) {
            this.procId = id;
        }

        public final int intValue() {
            return this.procId;
        }

        public static final ProcedureId fromInt(int typ) {
            if (_idMap.containsKey(typ)) {
                return _idMap.get(typ);
            }
            return Invalid;
        }

        static {
            _idMap = new HashMap<Integer, ProcedureId>();
            for (ProcedureId id : ProcedureId.values()) {
                _idMap.put(id.intValue(), id);
            }
        }
    }
}

