/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.v3;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.nfs.BadCookieException;
import org.filesys.oncrpc.nfs.BadHandleException;
import org.filesys.oncrpc.nfs.FileIdCache;
import org.filesys.oncrpc.nfs.NFSHandle;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.oncrpc.nfs.NetworkFileCache;
import org.filesys.oncrpc.nfs.RpcSessionProcessor;
import org.filesys.oncrpc.nfs.ShareDetails;
import org.filesys.oncrpc.nfs.StaleHandleException;
import org.filesys.oncrpc.nfs.v3.NFS3;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.DiskSizeInterface;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileIdInterface;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.FileType;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyAction;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.SymbolicLinkInterface;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.util.HexDump;

public class NFS3RpcProcessor
implements RpcSessionProcessor {
    public static final int MODE_STFILE = 32768;
    public static final int MODE_STDIR = 16384;
    public static final int MODE_STREAD = 365;
    public static final int MODE_STWRITE = 219;
    public static final int MODE_DIR_DEFAULT = 16895;
    public static final int MODE_FILE_DEFAULT = 33279;
    public static final long COOKIE_RESUMEID_MASK = 0xFFFFFFL;
    public static final long COOKIE_SEARCHID_MASK = 0xFF000000L;
    public static final int COOKIE_SEARCHID_SHIFT = 24;
    public static final long COOKIE_DOT_DIRECTORY = 0xFFFFFFL;
    public static final long COOKIE_DOTDOT_DIRECTORY = 0xFFFFFEL;
    public static final int READDIRPLUS_HEADER_LENGTH = 108;
    public static final int READDIRPLUS_ENTRY_LENGTH = 200;
    public static final int READDIR_HEADER_LENGTH = 108;
    public static final int READDIR_ENTRY_LENGTH = 24;
    public static final long FILE_ID_OFFSET = 2L;
    public static final int MaxRequestSize = 65535;
    public static final int MaxReadSize = 65535;
    public static final int PrefReadSize = 65535;
    public static final int MultReadSize = 4096;
    public static final int MaxWriteSize = 65535;
    public static final int PrefWriteSize = 65535;
    public static final int MultWriteSize = 4096;
    public static final int PrefReadDirSize = 8192;
    public static final long MaxFileSize = 0x1FFFFFFF000L;
    public static final int MaxResponseSize = 65535;
    public static final int RespSizeReadDir = 65535;
    public static final int RespSizeCreate = 512;
    public static final int RespSizeRename = 512;
    public static final int RespSizeMkDir = 512;
    public static final int RespSizeReadLink = 4096;

    @Override
    public int getProgamId() {
        return 100003;
    }

    @Override
    public int getVersionId() {
        return 3;
    }

    @Override
    public RpcPacket processRpc(RpcPacket rpc, NFSSrvSession nfsSess) throws IOException {
        rpc.positionAtParameters();
        RpcPacket response = null;
        NFS3.ProcedureId procId = NFS3.ProcedureId.fromInt(rpc.getProcedureId());
        switch (procId) {
            case Null: {
                response = this.procNull(nfsSess, rpc);
                break;
            }
            case GetAttr: {
                response = this.procGetAttr(nfsSess, rpc);
                break;
            }
            case SetAttr: {
                response = this.procSetAttr(nfsSess, rpc);
                break;
            }
            case Lookup: {
                response = this.procLookup(nfsSess, rpc);
                break;
            }
            case Access: {
                response = this.procAccess(nfsSess, rpc);
                break;
            }
            case ReadLink: {
                response = this.procReadLink(nfsSess, rpc);
                break;
            }
            case Read: {
                response = this.procRead(nfsSess, rpc);
                break;
            }
            case Write: {
                response = this.procWrite(nfsSess, rpc);
                break;
            }
            case Create: {
                response = this.procCreate(nfsSess, rpc);
                break;
            }
            case MkDir: {
                response = this.procMkDir(nfsSess, rpc);
                break;
            }
            case SymLink: {
                response = this.procSymLink(nfsSess, rpc);
                break;
            }
            case MkNode: {
                response = this.procMkNode(nfsSess, rpc);
                break;
            }
            case Remove: {
                response = this.procRemove(nfsSess, rpc);
                break;
            }
            case RmDir: {
                response = this.procRmDir(nfsSess, rpc);
                break;
            }
            case Rename: {
                response = this.procRename(nfsSess, rpc);
                break;
            }
            case Link: {
                response = this.procLink(nfsSess, rpc);
                break;
            }
            case ReadDir: {
                response = this.procReadDir(nfsSess, rpc);
                break;
            }
            case ReadDirPlus: {
                response = this.procReadDirPlus(nfsSess, rpc);
                break;
            }
            case FsStat: {
                response = this.procFsStat(nfsSess, rpc);
                break;
            }
            case FsInfo: {
                response = this.procFsInfo(nfsSess, rpc);
                break;
            }
            case PathConf: {
                response = this.procPathConf(nfsSess, rpc);
                break;
            }
            case Commit: {
                response = this.procCommit(nfsSess, rpc);
            }
        }
        if (nfsSess != null) {
            nfsSess.endTransaction();
        }
        if (nfsSess.hasDebug(NFSSrvSession.Dbg.DUMPDATA)) {
            Debug.println("NFS Resp=" + (rpc != null ? rpc.toString() : "<Null>"));
            HexDump.Dump(rpc.getBuffer(), rpc.getLength(), 0);
        }
        return response;
    }

    private final RpcPacket procNull(NFSSrvSession nfsSess, RpcPacket rpc) {
        rpc.buildResponseHeader();
        return rpc;
    }

    private final RpcPacket procGetAttr(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block15: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                nfsSess.debugPrintln("GetAttr request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle));
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            rpc.buildResponseHeader();
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(nfsSess, handle, conn);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                NetworkFile netFile = this.getOpenNetworkFileForHandle(nfsSess, handle, conn);
                FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
                if (finfo != null) {
                    if (netFile != null) {
                        finfo.setFileSize(netFile.getFileSize());
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                            nfsSess.debugPrintln("GetAttr added details from open file");
                        }
                    }
                    rpc.packInt(NFS3.StatusCode.Success.intValue());
                    this.packAttributes3(rpc, finfo, shareId);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                        nfsSess.debugPrintln("GetAttr path=" + path + ", info=" + finfo);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block15;
                nfsSess.debugPrintln("GetAttr Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("GetAttr error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procSetAttr(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block40: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                nfsSess.debugPrintln("SetAttr request from " + rpc.getClientDetails());
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                int timeInt;
                NFS3.SetAttrTimestamp setTime;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(nfsSess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo oldInfo = disk.getFileInformation(nfsSess, conn, path);
                int setFlags = 0;
                int gid = -1;
                int uid = -1;
                int mode = -1;
                long fsize = -1L;
                long atime = -1L;
                long mtime = -1L;
                if (rpc.unpackInt() == 1) {
                    mode = rpc.unpackInt();
                    setFlags += 512;
                }
                if (rpc.unpackInt() == 1) {
                    uid = rpc.unpackInt();
                    setFlags += 256;
                }
                if (rpc.unpackInt() == 1) {
                    gid = rpc.unpackInt();
                    setFlags += 128;
                }
                if (rpc.unpackInt() == 1) {
                    fsize = rpc.unpackLong();
                    ++setFlags;
                }
                if ((setTime = NFS3.SetAttrTimestamp.fromInt(rpc.unpackInt())) == NFS3.SetAttrTimestamp.TimeClient) {
                    timeInt = rpc.unpackInt();
                    if (timeInt >= 0) {
                        atime = timeInt;
                    } else {
                        atime = timeInt & Integer.MAX_VALUE;
                        atime += 0x80000000L;
                    }
                    atime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 32;
                } else if (setTime == NFS3.SetAttrTimestamp.TimeServer) {
                    atime = System.currentTimeMillis();
                    setFlags += 32;
                }
                setTime = NFS3.SetAttrTimestamp.fromInt(rpc.unpackInt());
                if (setTime == NFS3.SetAttrTimestamp.TimeClient) {
                    timeInt = rpc.unpackInt();
                    if (timeInt >= 0) {
                        mtime = timeInt;
                    } else {
                        mtime = timeInt & Integer.MAX_VALUE;
                        mtime += 0x80000000L;
                    }
                    mtime = rpc.unpackInt();
                    mtime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 8;
                } else if (setTime == NFS3.SetAttrTimestamp.TimeServer) {
                    mtime = System.currentTimeMillis();
                    setFlags += 8;
                }
                if (setFlags != 0) {
                    FileInfo finfo = new FileInfo();
                    finfo.setFileInformationFlags(setFlags);
                    if (atime != -1L) {
                        finfo.setAccessDateTime(atime);
                    }
                    if (mtime != -1L) {
                        finfo.setModifyDateTime(mtime);
                    }
                    if (gid != -1) {
                        finfo.setGid(gid);
                    }
                    if (uid != -1) {
                        finfo.setUid(uid);
                    }
                    if (mode != -1) {
                        finfo.setMode(mode);
                    }
                    disk.setFileInformation(nfsSess, conn, path, finfo);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                        nfsSess.debugPrintln("SetAttr handle=" + NFSHandle.asString(handle) + ", accessTime=" + finfo.getAccessDateTime() + ", modifyTime=" + finfo.getModifyDateTime() + ", mode=" + mode + ", gid/uid=" + gid + "/" + uid);
                    }
                }
                if (fsize != -1L) {
                    NetworkFile netFile;
                    NetworkFile networkFile = netFile = this.getNetworkFileForHandle(nfsSess, handle, conn, false);
                    synchronized (networkFile) {
                        netFile.openFile(false);
                        disk.truncateFile(nfsSess, conn, netFile, fsize);
                    }
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                        nfsSess.debugPrintln("SetAttr handle=" + NFSHandle.asString(handle) + ", newSize=" + fsize);
                    }
                }
                FileInfo newInfo = disk.getFileInformation(nfsSess, conn, path);
                if (fsize != -1L) {
                    newInfo.setFileSize(fsize);
                } else {
                    NetworkFile netFile = this.getOpenNetworkFileForHandle(nfsSess, handle, conn);
                    if (netFile != null) {
                        newInfo.setFileSize(netFile.getFileSize());
                    }
                }
                rpc.buildResponseHeader();
                rpc.packInt(NFS3.StatusCode.Success.intValue());
                this.packWccData(rpc, oldInfo);
                this.packPostOpAttr(nfsSess, newInfo, shareId, rpc);
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (DiskFullException ex) {
                errorSts = NFS3.StatusCode.DQuot;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block40;
                nfsSess.debugPrintln("SetAttr Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(rpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("SetAttr error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procLookup(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        int shareId;
        block19: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                nfsSess.debugPrintln("Lookup request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle) + ", name=" + fileName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                String lookupPath;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(nfsSess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                if (disk.fileExists(nfsSess, conn, lookupPath = this.generatePath(path, fileName)) != FileStatus.NotExist) {
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, lookupPath);
                    if (finfo != null) {
                        byte[] fHandle = this.getHandleForFile(nfsSess, handle, conn, fileName);
                        NetworkFile netFile = this.getOpenNetworkFileForHandle(nfsSess, fHandle, conn);
                        if (netFile != null) {
                            finfo.setFileSize(netFile.getFileSize());
                        }
                        rpc.buildResponseHeader();
                        rpc.packInt(NFS3.StatusCode.Success.intValue());
                        if (finfo.isDirectory()) {
                            NFSHandle.packDirectoryHandle(shareId, finfo.getFileId(), rpc, 32);
                        } else {
                            NFSHandle.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), rpc, 32);
                        }
                        this.packPostOpAttr(nfsSess, finfo, shareId, rpc);
                        ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), lookupPath);
                        if (!this.pathHasDirectories(fileName) || fileName.equals("..")) {
                            FileInfo dirInfo = disk.getFileInformation(nfsSess, conn, path);
                            this.packPostOpAttr(nfsSess, dirInfo, shareId, rpc);
                            if (!details.hasFileIdSupport()) {
                                details.getFileIdCache().addPath(dirInfo.getFileId(), path);
                            }
                        }
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                            nfsSess.debugPrintln("Lookup path=" + lookupPath + ", finfo=" + finfo.toString());
                        }
                    }
                } else {
                    errorSts = NFS3.StatusCode.NoEnt;
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block19;
                nfsSess.debugPrintln("Lookup Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, rpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                Debug.println("Lookup error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procAccess(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        int shareId;
        block18: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            int accessMode = rpc.unpackInt();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                nfsSess.debugPrintln("Access request from " + rpc.getClientDetails() + ", handle=" + NFSHandle.asString(handle) + ", access=0x" + Integer.toHexString(accessMode));
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                if (NFSHandle.isShareHandle(handle)) {
                    rpc.buildResponseHeader();
                    rpc.packInt(NFS3.StatusCode.Success.intValue());
                    this.packPostOpAttr(nfsSess, null, shareId, rpc);
                    rpc.packInt(accessMode & 0x3F);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                        Debug.println("Access share path=" + path);
                    }
                } else {
                    shareId = this.getShareIdFromHandle(handle);
                    TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                    path = this.getPathForHandle(nfsSess, handle, conn);
                    DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
                    if (finfo != null) {
                        int mask = 0;
                        if (conn.hasWriteAccess()) {
                            mask = 63;
                        } else if (conn.hasReadAccess()) {
                            mask = 35;
                        }
                        NetworkFile netFile = this.getOpenNetworkFileForHandle(nfsSess, handle, conn);
                        if (netFile != null) {
                            finfo.setFileSize(netFile.getFileSize());
                        }
                        rpc.buildResponseHeader();
                        rpc.packInt(NFS3.StatusCode.Success.intValue());
                        this.packPostOpAttr(nfsSess, finfo, shareId, rpc);
                        rpc.packInt(accessMode & mask);
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                            Debug.println("Access path=" + path + ", info=" + finfo);
                        }
                    } else {
                        errorSts = NFS3.StatusCode.NoEnt;
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block18;
                nfsSess.debugPrintln("Access3 Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, rpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Access error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procReadLink(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        block12: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            rpc.buildResponseHeader();
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = rpc;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                path = this.getPathForHandle(nfsSess, handle, conn);
                boolean symLinks = false;
                if (conn.getInterface() instanceof SymbolicLinkInterface) {
                    SymbolicLinkInterface symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface());
                    symLinks = symLinkIface.hasSymbolicLinksEnabled(nfsSess, conn);
                }
                if (!symLinks) {
                    rpc.buildErrorResponse(NFS3.StatusCode.NotSupp.intValue());
                    this.packPostOpAttr(nfsSess, null, 0, rpc);
                    this.packWccData(rpc, null);
                    rpc.setLength();
                    return rpc;
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
                if (finfo != null && finfo.isFileType() == FileType.SymbolicLink) {
                    SymbolicLinkInterface symLinkInterface = (SymbolicLinkInterface)((Object)disk);
                    String linkData = symLinkInterface.readSymbolicLink(nfsSess, conn, path);
                    respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(4096, rpc, -1);
                    respRpc.packInt(NFS3.StatusCode.Success.intValue());
                    this.packPostOpAttr(nfsSess, finfo, shareId, respRpc);
                    respRpc.packString(linkData);
                } else {
                    errorSts = NFS3.StatusCode.InVal;
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block12;
                nfsSess.debugPrintln("ReadLink Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("ReadLink error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procRead(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        int shareId;
        block16: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long offset = rpc.unpackLong();
            int count = rpc.unpackInt();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILEIO)) {
                nfsSess.debugPrintln("[NFS] Read request " + rpc.getClientDetails() + ", count=" + count + ", pos=" + offset);
            }
            shareId = -1;
            NetworkFile netFile = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = rpc;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                netFile = this.getNetworkFileForHandle(nfsSess, handle, conn, true);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                int allocLen = rpc.getRequestHeaderLength() + count + 88;
                respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(allocLen, rpc, -1);
                respRpc.buildResponseHeader();
                respRpc.packInt(NFS3.StatusCode.Success.intValue());
                FileInfo finfo = disk.getFileInformation(nfsSess, conn, netFile.getFullName());
                finfo.setFileSize(netFile.getFileSize());
                this.packPostOpAttr(nfsSess, finfo, shareId, respRpc);
                int bufPos = respRpc.getPosition();
                int rdlen = -1;
                NetworkFile networkFile = netFile;
                synchronized (networkFile) {
                    if (netFile.isClosed()) {
                        netFile.openFile(false);
                    }
                    rdlen = disk.readFile(nfsSess, conn, netFile, respRpc.getBuffer(), bufPos + 12, count, offset);
                }
                respRpc.packInt(rdlen);
                if (finfo.getSize() > offset + (long)count) {
                    respRpc.packInt(0);
                } else {
                    respRpc.packInt(1);
                }
                respRpc.packInt(rdlen);
                respRpc.setLength(bufPos + 12 + (rdlen + 3 & 0xFFFFFFFC) - respRpc.getOffset());
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILEIO)) {
                    nfsSess.debugPrintln("Read fid=" + netFile.getFileId() + ", name=" + netFile.getName() + ", rdlen=" + rdlen);
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block16;
                nfsSess.debugPrintln("Read Exception: netFile=" + netFile + ", cache=" + nfsSess.getFileCache().numberOfEntries());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, respRpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Read error=" + errorSts.getStatusString());
            }
        }
        return respRpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procWrite(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block15: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long offset = rpc.unpackLong();
            int count = rpc.unpackInt();
            int stable = rpc.unpackInt();
            rpc.skipBytes(4);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILEIO)) {
                nfsSess.debugPrintln("Write request from " + rpc.getClientDetails() + " , count=" + count + ", offset=" + offset);
            }
            int shareId = -1;
            String path = null;
            NetworkFile netFile = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                netFile = this.getNetworkFileForHandle(nfsSess, handle, conn, false);
                path = this.getPathForHandle(nfsSess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = null;
                NetworkFile networkFile = netFile;
                synchronized (networkFile) {
                    if (netFile.isClosed()) {
                        netFile.openFile(false);
                    }
                    preInfo = disk.getFileInformation(nfsSess, conn, path);
                    disk.writeFile(nfsSess, conn, netFile, rpc.getBuffer(), rpc.getPosition(), count, offset);
                }
                FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
                finfo.setFileSize(netFile.getFileSize());
                rpc.buildResponseHeader();
                rpc.packInt(NFS3.StatusCode.Success.intValue());
                this.packPreOpAttr(nfsSess, preInfo, rpc);
                this.packPostOpAttr(nfsSess, finfo, shareId, rpc);
                rpc.packInt(count);
                rpc.packInt(stable);
                rpc.packLong(nfsSess.getNFSServer().getWriteVerifier());
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILEIO)) {
                    nfsSess.debugPrintln("Write fid=" + netFile.getFileId() + ", name=" + netFile.getName() + ", wrlen=" + count);
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (DiskFullException ex) {
                errorSts = NFS3.StatusCode.NoSpc;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block15;
                nfsSess.debugPrintln("Write Exception: netFile=" + netFile + ", cache=" + nfsSess.getFileCache().numberOfEntries());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Write error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procCreate(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        block24: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            int createMode = rpc.unpackInt();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                nfsSess.debugPrintln("Create request from " + rpc.getClientDetails() + ", name=" + fileName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = rpc;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                path = this.getPathForHandle(nfsSess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(nfsSess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(fileName);
                String filePath = str.toString();
                FileStatus existSts = disk.fileExists(nfsSess, conn, filePath);
                if (existSts == FileStatus.FileExists) {
                    errorSts = NFS3.StatusCode.Exist;
                } else if (existSts == FileStatus.DirectoryExists) {
                    errorSts = NFS3.StatusCode.IsDir;
                } else {
                    FileInfo finfo;
                    int gid = -1;
                    int uid = -1;
                    int mode = -1;
                    if (rpc.unpackInt() == 1) {
                        mode = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        uid = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        gid = rpc.unpackInt();
                    }
                    FileOpenParams params = new FileOpenParams(filePath, 16, 2, 0, gid, uid, mode, 0);
                    NetworkFile netFile = disk.createFile(nfsSess, conn, params);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                        nfsSess.debugPrintln("  Create file params=" + params);
                    }
                    if ((finfo = disk.getFileInformation(nfsSess, conn, filePath)) != null) {
                        DiskDeviceContext diskCtx;
                        respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(512, rpc, -1);
                        respRpc.buildResponseHeader();
                        respRpc.packInt(NFS3.StatusCode.Success.intValue());
                        if (finfo.isDirectory()) {
                            this.packDirectoryHandle(shareId, finfo.getFileId(), respRpc);
                        } else {
                            this.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), respRpc);
                        }
                        this.packPostOpAttr(nfsSess, finfo, shareId, respRpc);
                        ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), filePath);
                        nfsSess.getFileCache().addFile(netFile, conn, nfsSess);
                        this.packPreOpAttr(nfsSess, preInfo, respRpc);
                        FileInfo postInfo = disk.getFileInformation(nfsSess, conn, path);
                        this.packPostOpAttr(nfsSess, postInfo, shareId, respRpc);
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                            nfsSess.debugPrintln("Create path=" + filePath + ", finfo=" + finfo.toString());
                        }
                        if ((diskCtx = (DiskDeviceContext)conn.getContext()).hasChangeHandler()) {
                            diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Added, filePath);
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block24;
                nfsSess.debugPrintln("Create Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(respRpc, null);
            this.packWccData(respRpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Create error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    private final RpcPacket procMkDir(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        block19: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String dirName = rpc.unpackUTF8String();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.DIRECTORY)) {
                nfsSess.debugPrintln("MkDir request from " + rpc.getClientDetails() + ", name=" + dirName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = rpc;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                path = this.getPathForHandle(nfsSess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(nfsSess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(dirName);
                String dirPath = str.toString();
                FileStatus existSts = disk.fileExists(nfsSess, conn, dirPath);
                if (existSts != FileStatus.NotExist) {
                    errorSts = NFS3.StatusCode.Exist;
                } else {
                    int gid = -1;
                    int uid = -1;
                    int mode = -1;
                    if (rpc.unpackInt() == 1) {
                        mode = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        uid = rpc.unpackInt();
                    }
                    if (rpc.unpackInt() == 1) {
                        gid = rpc.unpackInt();
                    }
                    FileOpenParams params = new FileOpenParams(dirPath, 16, 2, 16, gid, uid, mode, 0);
                    disk.createDirectory(nfsSess, conn, params);
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, dirPath);
                    if (finfo != null) {
                        respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(512, rpc, -1);
                        respRpc.buildResponseHeader();
                        respRpc.packInt(NFS3.StatusCode.Success.intValue());
                        this.packDirectoryHandle(shareId, finfo.getFileId(), respRpc);
                        this.packPostOpAttr(nfsSess, finfo, shareId, respRpc);
                        ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), dirPath);
                        this.packWccData(respRpc, preInfo);
                        this.packPostOpAttr(nfsSess, conn, handle, respRpc);
                        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                        if (diskCtx.hasChangeHandler()) {
                            diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Added, dirPath);
                        }
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.DIRECTORY)) {
                            nfsSess.debugPrintln("Mkdir path=" + dirPath + ", finfo=" + finfo.toString());
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block19;
                nfsSess.debugPrintln("Mkdir Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(respRpc, null);
            this.packWccData(respRpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Mkdir error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    private final RpcPacket procSymLink(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block30: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                NFS3.SetAttrTimestamp setTime;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                path = this.getPathForHandle(nfsSess, handle, conn);
                boolean symLinks = false;
                if (conn.getInterface() instanceof SymbolicLinkInterface) {
                    SymbolicLinkInterface symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface());
                    symLinks = symLinkIface.hasSymbolicLinksEnabled(nfsSess, conn);
                }
                if (!symLinks) {
                    rpc.buildErrorResponse(NFS3.StatusCode.NotSupp.intValue());
                    this.packPostOpAttr(nfsSess, null, 0, rpc);
                    this.packWccData(rpc, null);
                    rpc.setLength();
                    return rpc;
                }
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                int setFlags = 0;
                int gid = -1;
                int uid = -1;
                int mode = -1;
                long fsize = -1L;
                long atime = -1L;
                long mtime = -1L;
                if (rpc.unpackInt() == 1) {
                    mode = rpc.unpackInt();
                    setFlags += 512;
                }
                if (rpc.unpackInt() == 1) {
                    uid = rpc.unpackInt();
                    setFlags += 256;
                }
                if (rpc.unpackInt() == 1) {
                    gid = rpc.unpackInt();
                    setFlags += 128;
                }
                if (rpc.unpackInt() == 1) {
                    fsize = rpc.unpackLong();
                    ++setFlags;
                }
                if ((setTime = NFS3.SetAttrTimestamp.fromInt(rpc.unpackInt())) == NFS3.SetAttrTimestamp.TimeClient) {
                    atime = rpc.unpackInt();
                    atime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 32;
                } else if (setTime == NFS3.SetAttrTimestamp.TimeServer) {
                    atime = System.currentTimeMillis();
                    setFlags += 32;
                }
                setTime = NFS3.SetAttrTimestamp.fromInt(rpc.unpackInt());
                if (setTime == NFS3.SetAttrTimestamp.TimeClient) {
                    mtime = rpc.unpackInt();
                    mtime *= 1000L;
                    rpc.skipBytes(4);
                    setFlags += 8;
                } else if (setTime == NFS3.SetAttrTimestamp.TimeServer) {
                    mtime = System.currentTimeMillis();
                    setFlags += 8;
                }
                String linkName = rpc.unpackString();
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                    nfsSess.debugPrintln("Symbolic link request from " + rpc.getClientDetails() + ", name=" + fileName + ", link=" + linkName);
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(nfsSess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(fileName);
                String filePath = str.toString();
                FileStatus existSts = disk.fileExists(nfsSess, conn, filePath);
                if (existSts == FileStatus.FileExists) {
                    errorSts = NFS3.StatusCode.Exist;
                } else if (existSts == FileStatus.DirectoryExists) {
                    errorSts = NFS3.StatusCode.IsDir;
                } else {
                    FileInfo finfo;
                    FileOpenParams params = new FileOpenParams(filePath, 16, 2, 0, gid, uid, mode, 0);
                    params.setSymbolicLink(linkName);
                    NetworkFile netFile = disk.createFile(nfsSess, conn, params);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                        nfsSess.debugPrintln("  Symbolic link params=" + params);
                    }
                    if ((finfo = disk.getFileInformation(nfsSess, conn, filePath)) != null) {
                        rpc.buildResponseHeader();
                        rpc.packInt(NFS3.StatusCode.Success.intValue());
                        this.packFileHandle(shareId, this.getFileIdForHandle(handle), finfo.getFileId(), rpc);
                        this.packPostOpAttr(nfsSess, finfo, shareId, rpc);
                        ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                        details.getFileIdCache().addPath(finfo.getFileId(), filePath);
                        nfsSess.getFileCache().addFile(netFile, conn, nfsSess);
                        this.packPreOpAttr(nfsSess, preInfo, rpc);
                        FileInfo postInfo = disk.getFileInformation(nfsSess, conn, path);
                        this.packPostOpAttr(nfsSess, postInfo, shareId, rpc);
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                            nfsSess.debugPrintln("Symbolic link path=" + filePath + ", finfo=" + finfo.toString());
                        }
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block30;
                nfsSess.debugPrintln("SymbolicLink Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("SymLink error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procMkNode(NFSSrvSession nfsSess, RpcPacket rpc) {
        if (nfsSess.hasDebug(NFSSrvSession.Dbg.DIRECTORY)) {
            nfsSess.debugPrintln("MkNode request from " + rpc.getClientDetails());
        }
        rpc.buildErrorResponse(NFS3.StatusCode.NotSupp.intValue());
        this.packPostOpAttr(nfsSess, null, 0, rpc);
        this.packWccData(rpc, null);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procRemove(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block17: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String fileName = rpc.unpackUTF8String();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                nfsSess.debugPrintln("Remove request from " + rpc.getClientDetails() + ", name=" + fileName);
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                path = this.getPathForHandle(nfsSess, handle, conn);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preInfo = disk.getFileInformation(nfsSess, conn, path);
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(fileName);
                String delPath = str.toString();
                FileStatus existSts = disk.fileExists(nfsSess, conn, delPath);
                if (existSts == FileStatus.NotExist) {
                    errorSts = NFS3.StatusCode.NoEnt;
                } else if (existSts == FileStatus.DirectoryExists) {
                    errorSts = NFS3.StatusCode.IsDir;
                } else {
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, delPath);
                    disk.deleteFile(nfsSess, conn, delPath);
                    if (finfo != null) {
                        details.getFileIdCache().deletePath(finfo.getFileId());
                        nfsSess.getFileCache().removeFile(finfo.getFileId());
                    }
                    FileInfo postInfo = disk.getFileInformation(nfsSess, conn, path);
                    rpc.buildResponseHeader();
                    rpc.packInt(NFS3.StatusCode.Success.intValue());
                    this.packPreOpAttr(nfsSess, preInfo, rpc);
                    this.packPostOpAttr(nfsSess, postInfo, shareId, rpc);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Removed, delPath);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (SecurityException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block17;
                nfsSess.debugPrintln("Remove Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Remove error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procRmDir(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        block19: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            String dirName = rpc.unpackUTF8String();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.DIRECTORY)) {
                nfsSess.debugPrintln("RmDir request from " + rpc.getClientDetails() + ", name=" + dirName);
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            int shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                rpc.buildResponseHeader();
                rpc.packInt(NFS3.StatusCode.Success.intValue());
                this.packPreOpAttr(nfsSess, conn, handle, rpc);
                path = this.getPathForHandle(nfsSess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                StringBuffer str = new StringBuffer();
                str.append(path);
                if (!path.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(dirName);
                String delPath = str.toString();
                FileStatus existSts = disk.fileExists(nfsSess, conn, delPath);
                if (existSts == FileStatus.NotExist) {
                    errorSts = NFS3.StatusCode.NoEnt;
                } else if (existSts == FileStatus.FileExists) {
                    errorSts = NFS3.StatusCode.NoEnt;
                } else {
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, delPath);
                    disk.deleteDirectory(nfsSess, conn, delPath);
                    if (finfo != null) {
                        details.getFileIdCache().deletePath(finfo.getFileId());
                    }
                    this.packPostOpAttr(nfsSess, conn, handle, rpc);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Removed, delPath);
                    }
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (SecurityException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (DirectoryNotEmptyException ex) {
                errorSts = NFS3.StatusCode.NotEmpty;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block19;
                nfsSess.debugPrintln("Rmdir Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Rmdir error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RpcPacket procRename(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        block25: {
            byte[] fromHandle = new byte[32];
            rpc.unpackByteArrayWithLength(fromHandle);
            String fromName = rpc.unpackUTF8String();
            byte[] toHandle = new byte[32];
            rpc.unpackByteArrayWithLength(toHandle);
            String toName = rpc.unpackUTF8String();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                nfsSess.debugPrintln("Rename request from " + rpc.getClientDetails() + ", fromHandle=" + NFSHandle.asString(fromHandle) + ", fromname=" + fromName);
                nfsSess.debugPrintln("               tohandle=" + NFSHandle.asString(toHandle) + ", toname=" + toName);
            }
            int shareId = -1;
            String fromPath = null;
            String toPath = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = null;
            try {
                DiskDeviceContext diskCtx;
                byte[] fHandle;
                NetworkFile netFile;
                FileInfo finfo;
                shareId = this.getShareIdFromHandle(fromHandle);
                ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasWriteAccess()) {
                    throw new AccessDeniedException();
                }
                fromPath = this.getPathForHandle(nfsSess, fromHandle, conn);
                toPath = this.getPathForHandle(nfsSess, toHandle, conn);
                StringBuffer str = new StringBuffer();
                str.append(fromPath);
                if (!fromPath.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(fromName);
                String oldPath = str.toString();
                str.setLength(0);
                str.append(toPath);
                if (!toPath.endsWith("\\")) {
                    str.append("\\");
                }
                str.append(toName);
                String newPath = str.toString();
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileInfo preFromInfo = disk.getFileInformation(nfsSess, conn, fromPath);
                FileInfo preToInfo = null;
                preToInfo = NFSHandle.unpackDirectoryId(fromHandle) == NFSHandle.unpackDirectoryId(toHandle) ? preFromInfo : disk.getFileInformation(nfsSess, conn, toPath);
                FileStatus existSts = disk.fileExists(nfsSess, conn, oldPath);
                if (existSts == FileStatus.NotExist) {
                    errorSts = NFS3.StatusCode.NoEnt;
                    break block25;
                }
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                    nfsSess.debugPrintln("Rename from=" + oldPath + ", to=" + newPath);
                }
                if ((finfo = disk.getFileInformation(nfsSess, conn, oldPath)) != null && !finfo.isDirectory() && (netFile = this.getOpenNetworkFileForHandle(nfsSess, fHandle = this.getHandleForFile(nfsSess, fromHandle, conn, fromName), conn)) != null) {
                    NetworkFileCache fileCache;
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                        nfsSess.debugPrintln("  Closing file " + oldPath + " before rename");
                    }
                    disk.closeFile(nfsSess, conn, netFile);
                    NetworkFileCache networkFileCache = fileCache = nfsSess.getFileCache();
                    synchronized (networkFileCache) {
                        fileCache.removeFile(netFile.getFileId());
                    }
                }
                if (disk.fileExists(nfsSess, conn, newPath) == FileStatus.FileExists) {
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                        nfsSess.debugPrintln("  Delete existing file before rename, newPath=" + newPath);
                    }
                    disk.deleteFile(nfsSess, conn, newPath);
                }
                disk.renameFile(nfsSess, conn, oldPath, newPath);
                if (finfo != null && finfo.getFileId() != -1) {
                    details.getFileIdCache().deletePath(finfo.getFileId());
                    details.getFileIdCache().addPath(finfo.getFileId(), newPath);
                }
                if ((finfo = disk.getFileInformation(nfsSess, conn, newPath)) != null) {
                    details.getFileIdCache().addPath(finfo.getFileId(), newPath);
                }
                if ((diskCtx = (DiskDeviceContext)conn.getContext()).hasChangeHandler()) {
                    diskCtx.getChangeHandler().notifyRename(oldPath, newPath);
                }
                FileInfo postFromInfo = disk.getFileInformation(nfsSess, conn, fromPath);
                FileInfo postToInfo = null;
                postToInfo = NFSHandle.unpackDirectoryId(fromHandle) == NFSHandle.unpackDirectoryId(toHandle) ? postFromInfo : disk.getFileInformation(nfsSess, conn, toPath);
                respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(512, rpc, -1);
                respRpc.buildResponseHeader();
                respRpc.packInt(NFS3.StatusCode.Success.intValue());
                this.packWccData(respRpc, preFromInfo);
                this.packPostOpAttr(nfsSess, postFromInfo, shareId, respRpc);
                this.packWccData(respRpc, preToInfo);
                this.packPostOpAttr(nfsSess, postToInfo, shareId, respRpc);
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (SecurityException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (FileExistsException ex) {
                errorSts = NFS3.StatusCode.Exist;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block25;
                nfsSess.debugPrintln("Rename Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            this.packWccData(rpc, null);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Rename error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    private final RpcPacket procLink(NFSSrvSession nfsSess, RpcPacket rpc) {
        if (nfsSess.hasDebug(NFSSrvSession.Dbg.RXDATA)) {
            nfsSess.debugPrintln("Link request from " + rpc.getClientDetails());
        }
        rpc.buildErrorResponse(NFS3.StatusCode.Access.intValue());
        this.packPostOpAttr(nfsSess, null, 0, rpc);
        this.packWccData(rpc, null);
        this.packWccData(rpc, null);
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procReadDir(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        int shareId;
        block28: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long cookie = rpc.unpackLong();
            long cookieVerf = rpc.unpackLong();
            int maxCount = rpc.unpackInt();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                nfsSess.debugPrintln("ReadDir request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle) + ", count=" + maxCount);
            }
            shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = null;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                path = this.getPathForHandle(nfsSess, handle, conn);
                StringBuffer pathBuf = null;
                int pathLen = 0;
                FileIdCache fileCache = details.getFileIdCache();
                if (!details.hasFileIdSupport()) {
                    pathBuf = new StringBuffer(256);
                    pathBuf.append(path);
                    if (!path.endsWith("\\")) {
                        pathBuf.append("\\");
                    }
                    pathLen = pathBuf.length();
                }
                respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(maxCount, rpc, -1);
                respRpc.buildResponseHeader();
                respRpc.packInt(NFS3.StatusCode.Success.intValue());
                FileInfo dinfo = disk.getFileInformation(nfsSess, conn, path);
                this.packPostOpAttr(nfsSess, dinfo, shareId, respRpc);
                String searchPath = this.generatePath(path, "*.*");
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                    nfsSess.debugPrintln("ReadDir searchPath=" + searchPath + ", cookie=" + cookie);
                }
                SearchContext search = null;
                long searchId = -1L;
                if (cookie == 0L) {
                    search = disk.startSearch(nfsSess, conn, searchPath, 16);
                    searchId = nfsSess.allocateSearchSlot(search);
                    cookieVerf = dinfo.getModifyDateTime();
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                        nfsSess.debugPrintln("ReadDir allocated searchId=" + searchId);
                    }
                } else {
                    if (cookieVerf != 0L && cookieVerf != dinfo.getModifyDateTime() && Long.reverseBytes(cookieVerf) != dinfo.getModifyDateTime()) {
                        throw new BadCookieException();
                    }
                    searchId = (cookie & 0xFF000000L) >> 24;
                    search = nfsSess.getSearchContext((int)searchId);
                    if (search == null) {
                        search = disk.startSearch(nfsSess, conn, searchPath, 16);
                        searchId = nfsSess.allocateSearchSlot(search);
                        cookieVerf = dinfo.getModifyDateTime();
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                            nfsSess.debugPrintln("ReadDir restarted search, searchId=" + searchId);
                        }
                    }
                    int resumeId = (int)(cookie & 0xFFFFFFL);
                    if (search.getResumeId() != resumeId) {
                        search.restartAt(resumeId);
                    }
                }
                respRpc.packLong(cookieVerf);
                if (searchId == -1L) {
                    throw new Exception("Bad search id");
                }
                long searchMask = searchId << 24;
                int entCnt = 0;
                FileInfo finfo = new FileInfo();
                if (cookie == 0L) {
                    respRpc.packInt(1);
                    respRpc.packLong(dinfo.getFileIdLong() + 2L);
                    respRpc.packString(".");
                    respRpc.packLong(0xFFFFFFL);
                    String parentPath = this.generatePath(path, "..");
                    FileInfo parentInfo = disk.getFileInformation(nfsSess, conn, parentPath);
                    respRpc.packInt(1);
                    respRpc.packLong(parentInfo.getFileIdLong() + 2L);
                    respRpc.packString("..");
                    respRpc.packLong(0xFFFFFEL);
                    entCnt = 2;
                }
                boolean replyFull = false;
                while (entCnt++ < maxCount && !replyFull && search.nextFileInfo(finfo)) {
                    int entryLen = 24 + (finfo.getFileName().length() + 3 & 0xFFFFFFFC);
                    if (entryLen > respRpc.getAvailableLength() || respRpc.getPosition() + entryLen > maxCount) {
                        replyFull = true;
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                            nfsSess.debugPrintln("ReadDir response full, restart at=" + finfo.getFileName() + ", resumeId=" + search.getResumeId());
                        }
                        search.restartAt(finfo);
                        break;
                    }
                    respRpc.packInt(1);
                    respRpc.packLong(finfo.getFileIdLong() + 2L);
                    respRpc.packUTF8String(finfo.getFileName());
                    respRpc.packLong((long)search.getResumeId() + searchMask);
                    if (details.hasFileIdSupport() || fileCache.findPath(finfo.getFileId()) != null) continue;
                    pathBuf.setLength(pathLen);
                    pathBuf.append(finfo.getFileName());
                    fileCache.addPath(finfo.getFileId(), pathBuf.toString());
                }
                respRpc.packInt(0);
                if (search.hasMoreFiles()) {
                    respRpc.packInt(0);
                } else {
                    respRpc.packInt(1);
                    search.closeSearch();
                    nfsSess.deallocateSearchSlot((int)searchId);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                        nfsSess.debugPrintln("ReadDir released searchId=" + searchId);
                    }
                }
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                    nfsSess.debugPrintln("ReadDir return entries=" + (entCnt - 1) + ", eof=" + search.hasMoreFiles());
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (BadCookieException ex) {
                errorSts = NFS3.StatusCode.BadCookie;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block28;
                nfsSess.debugPrintln("ReadDir Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, respRpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("ReadDir error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    private final RpcPacket procReadDirPlus(NFSSrvSession nfsSess, RpcPacket rpc) {
        RpcPacket respRpc;
        NFS3.StatusCode errorSts;
        int shareId;
        block30: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            long cookie = rpc.unpackLong();
            long cookieVerf = rpc.unpackLong();
            int maxDir = rpc.unpackInt();
            int maxCount = rpc.unpackInt();
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                nfsSess.debugPrintln("ReadDir request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle) + ", dir=" + maxDir + ", count=" + maxCount);
            }
            shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            respRpc = null;
            try {
                shareId = this.getShareIdFromHandle(handle);
                ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                path = this.getPathForHandle(nfsSess, handle, conn);
                StringBuffer pathBuf = null;
                int pathLen = 0;
                FileIdCache fileCache = details.getFileIdCache();
                if (!details.hasFileIdSupport()) {
                    pathBuf = new StringBuffer(256);
                    pathBuf.append(path);
                    if (!path.endsWith("\\")) {
                        pathBuf.append("\\");
                    }
                    pathLen = pathBuf.length();
                }
                respRpc = nfsSess.getNFSServer().getPacketPool().allocateAssociatedPacket(maxCount, rpc, -1);
                respRpc.buildResponseHeader();
                respRpc.packInt(NFS3.StatusCode.Success.intValue());
                FileInfo dinfo = disk.getFileInformation(nfsSess, conn, path);
                this.packPostOpAttr(nfsSess, dinfo, shareId, respRpc);
                String searchPath = this.generatePath(path, "*.*");
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                    nfsSess.debugPrintln("ReadDirPlus searchPath=" + searchPath + ", cookie=" + cookie);
                }
                SearchContext search = null;
                long searchId = -1L;
                if (cookie == 0L) {
                    search = disk.startSearch(nfsSess, conn, searchPath, 16);
                    searchId = nfsSess.allocateSearchSlot(search);
                    cookieVerf = dinfo.getModifyDateTime();
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                        nfsSess.debugPrintln("ReadDirPlus allocated searchId=" + searchId);
                    }
                } else {
                    if (cookieVerf != 0L && cookieVerf != dinfo.getModifyDateTime() && Long.reverseBytes(cookieVerf) != dinfo.getModifyDateTime()) {
                        nfsSess.debugPrintln("Bad cookie verifier, verf=0x" + Long.toHexString(cookieVerf) + ", modTime=0x" + Long.toHexString(dinfo.getModifyDateTime()));
                        throw new BadCookieException();
                    }
                    searchId = (cookie & 0xFF000000L) >> 24;
                    search = nfsSess.getSearchContext((int)searchId);
                    if (search == null) {
                        search = disk.startSearch(nfsSess, conn, searchPath, 16);
                        searchId = nfsSess.allocateSearchSlot(search);
                        cookieVerf = dinfo.getModifyDateTime();
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                            nfsSess.debugPrintln("ReadDirPlus restarted search, searchId=" + searchId);
                        }
                    }
                    int resumeId = (int)(cookie & 0xFFFFFFL);
                    if (search != null && search.getResumeId() != resumeId) {
                        search.restartAt(resumeId);
                    }
                }
                respRpc.packLong(cookieVerf);
                if (searchId == -1L) {
                    throw new Exception("Bad search id");
                }
                long searchMask = searchId << 24;
                int entCnt = 0;
                FileInfo finfo = new FileInfo();
                if (cookie == 0L) {
                    respRpc.packInt(1);
                    respRpc.packLong(dinfo.getFileIdLong() + 2L);
                    respRpc.packString(".");
                    respRpc.packLong(0xFFFFFFL);
                    respRpc.packInt(1);
                    this.packAttributes3(respRpc, dinfo, shareId);
                    this.packDirectoryHandle(shareId, dinfo.getFileId(), rpc);
                    String parentPath = this.generatePath(path, "..");
                    FileInfo parentInfo = disk.getFileInformation(nfsSess, conn, parentPath);
                    respRpc.packInt(1);
                    respRpc.packLong(parentInfo.getFileIdLong() + 2L);
                    respRpc.packString("..");
                    respRpc.packLong(0xFFFFFEL);
                    respRpc.packInt(1);
                    this.packAttributes3(respRpc, parentInfo, shareId);
                    this.packDirectoryHandle(shareId, parentInfo.getFileId(), respRpc);
                    entCnt = 2;
                }
                boolean replyFull = false;
                while (entCnt++ < maxDir && !replyFull && search.nextFileInfo(finfo)) {
                    int entryLen = 200 + (finfo.getFileName().length() + 3 & 0xFFFFFFFC);
                    if (entryLen > respRpc.getAvailableLength() || respRpc.getPosition() + entryLen > maxCount) {
                        replyFull = true;
                        if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                            nfsSess.debugPrintln("ReadDirPlus response full, restart at=" + finfo.getFileName() + ", resumeId=" + search.getResumeId());
                        }
                        search.restartAt(finfo);
                        break;
                    }
                    respRpc.packInt(1);
                    respRpc.packLong(finfo.getFileIdLong() + 2L);
                    respRpc.packUTF8String(finfo.getFileName());
                    respRpc.packLong((long)search.getResumeId() + searchMask);
                    respRpc.packInt(1);
                    this.packAttributes3(respRpc, finfo, shareId);
                    if (finfo.isDirectory()) {
                        this.packDirectoryHandle(shareId, finfo.getFileId(), respRpc);
                    } else {
                        this.packFileHandle(shareId, dinfo.getFileId(), finfo.getFileId(), respRpc);
                    }
                    if (!details.hasFileIdSupport() && fileCache.findPath(finfo.getFileId()) == null) {
                        pathBuf.setLength(pathLen);
                        pathBuf.append(finfo.getFileName());
                        fileCache.addPath(finfo.getFileId(), pathBuf.toString());
                    }
                    finfo.setFileType(FileType.RegularFile);
                }
                respRpc.packInt(0);
                if (search.hasMoreFiles()) {
                    respRpc.packInt(0);
                } else {
                    respRpc.packInt(1);
                    search.closeSearch();
                    nfsSess.deallocateSearchSlot((int)searchId);
                }
                if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                    nfsSess.debugPrintln("ReadDirPlus return entries=" + (entCnt - 1) + ", eof=" + !search.hasMoreFiles());
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (BadCookieException ex) {
                errorSts = NFS3.StatusCode.BadCookie;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block30;
                nfsSess.debugPrintln("ReadDirPlus Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            respRpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, respRpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("ReadDir error=" + errorSts.getStatusString());
            }
        }
        respRpc.setLength();
        return respRpc;
    }

    private final RpcPacket procFsStat(NFSSrvSession nfsSess, RpcPacket rpc) {
        byte[] handle = new byte[32];
        rpc.unpackByteArrayWithLength(handle);
        if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
            nfsSess.debugPrintln("FsInfo request from " + rpc.getClientDetails());
        }
        int shareId = -1;
        NFS3.StatusCode errorSts = NFS3.StatusCode.Success;
        try {
            DiskInterface disk;
            shareId = this.getShareIdFromHandle(handle);
            TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
            if (!conn.hasReadAccess()) {
                throw new AccessDeniedException();
            }
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            SrvDiskInfo diskInfo = diskCtx.getDiskInformation();
            if (diskInfo == null) {
                diskInfo = new SrvDiskInfo();
            }
            if ((disk = (DiskInterface)conn.getSharedDevice().getInterface()) instanceof DiskSizeInterface) {
                DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
                sizeInterface.getDiskInformation(diskCtx, diskInfo);
            }
            String rootPath = this.getPathForHandle(nfsSess, handle, conn);
            FileInfo rootInfo = disk.getFileInformation(nfsSess, conn, rootPath);
            rpc.buildResponseHeader();
            rpc.packInt(NFS3.StatusCode.Success.intValue());
            this.packPostOpAttr(nfsSess, rootInfo, shareId, rpc);
            long totalSize = diskInfo.getDiskSizeKb() * 1024L;
            long freeSize = diskInfo.getDiskFreeSizeKb() * 1024L;
            rpc.packLong(totalSize);
            rpc.packLong(freeSize);
            rpc.packLong(freeSize);
            long totalSlots = diskInfo.getDiskSizeKb();
            long freeSlots = diskInfo.getDiskFreeSizeKb();
            rpc.packLong(totalSlots);
            rpc.packLong(freeSlots);
            rpc.packLong(freeSlots);
            rpc.packInt(0);
        }
        catch (SecurityException ex) {
            errorSts = NFS3.StatusCode.Access;
        }
        catch (AccessDeniedException ex) {
            errorSts = NFS3.StatusCode.Access;
        }
        catch (Exception ex) {
            errorSts = NFS3.StatusCode.ServerFault;
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, rpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("FsStat error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procFsInfo(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        int shareId;
        block10: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.INFO)) {
                nfsSess.debugPrintln("[NFS] FsInfo request from " + rpc.getClientDetails());
            }
            if (!NFSHandle.isValid(handle)) {
                rpc.buildErrorResponse(NFS3.StatusCode.BadHandle.intValue());
                return rpc;
            }
            rpc.buildResponseHeader();
            shareId = -1;
            errorSts = NFS3.StatusCode.Success;
            try {
                SymbolicLinkInterface symLinkIface;
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                rpc.packInt(NFS3.StatusCode.Success.intValue());
                this.packPostOpAttr(nfsSess, conn, handle, rpc);
                rpc.packInt(65535);
                rpc.packInt(65535);
                rpc.packInt(4096);
                rpc.packInt(65535);
                rpc.packInt(65535);
                rpc.packInt(4096);
                rpc.packInt(8192);
                rpc.packLong(0x1FFFFFFF000L);
                rpc.packInt(1);
                rpc.packInt(0);
                int fileSysProps = 12;
                if (conn.getInterface() instanceof SymbolicLinkInterface && (symLinkIface = (SymbolicLinkInterface)((Object)conn.getInterface())).hasSymbolicLinksEnabled(nfsSess, conn)) {
                    fileSysProps += 2;
                }
                rpc.packInt(fileSysProps);
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block10;
                nfsSess.debugPrintln("FsInfo Exception: " + ex.toString());
                nfsSess.debugPrintln(ex);
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, rpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("FsInfo error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procPathConf(NFSSrvSession nfsSess, RpcPacket rpc) {
        NFS3.StatusCode errorSts;
        int shareId;
        block12: {
            byte[] handle = new byte[32];
            rpc.unpackByteArrayWithLength(handle);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                nfsSess.debugPrintln("PathConf request from " + rpc.getClientDetails() + " handle=" + NFSHandle.asString(handle));
            }
            shareId = -1;
            String path = null;
            errorSts = NFS3.StatusCode.Success;
            try {
                shareId = this.getShareIdFromHandle(handle);
                TreeConnection conn = this.getTreeConnection(nfsSess, shareId);
                if (!conn.hasReadAccess()) {
                    throw new AccessDeniedException();
                }
                path = this.getPathForHandle(nfsSess, handle, conn);
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                if (disk.fileExists(nfsSess, conn, path) != FileStatus.NotExist) {
                    FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
                    rpc.buildResponseHeader();
                    rpc.packInt(NFS3.StatusCode.Success.intValue());
                    this.packPostOpAttr(nfsSess, finfo, shareId, rpc);
                    rpc.packInt(Short.MAX_VALUE);
                    rpc.packInt(255);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    rpc.packInt(1);
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.SEARCH)) {
                        nfsSess.debugPrintln("Pathconf path=" + path + ", finfo=" + (finfo != null ? finfo.toString() : "<null>"));
                    }
                } else {
                    errorSts = NFS3.StatusCode.NoEnt;
                }
            }
            catch (BadHandleException ex) {
                errorSts = NFS3.StatusCode.BadHandle;
            }
            catch (StaleHandleException ex) {
                errorSts = NFS3.StatusCode.Stale;
            }
            catch (AccessDeniedException ex) {
                errorSts = NFS3.StatusCode.Access;
            }
            catch (Exception ex) {
                errorSts = NFS3.StatusCode.ServerFault;
                if (!nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) break block12;
                nfsSess.debugPrintln("Pathconf Exception: " + ex.toString());
            }
        }
        if (errorSts != NFS3.StatusCode.Success) {
            rpc.buildErrorResponse(errorSts.intValue());
            this.packPostOpAttr(nfsSess, null, shareId, rpc);
            if (nfsSess.hasDebug(NFSSrvSession.Dbg.ERROR)) {
                nfsSess.debugPrintln("Pathconf error=" + errorSts.getStatusString());
            }
        }
        rpc.setLength();
        return rpc;
    }

    private final RpcPacket procCommit(NFSSrvSession nfsSess, RpcPacket rpc) {
        if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILEIO)) {
            nfsSess.debugPrintln("Commit request from " + rpc.getClientDetails());
        }
        rpc.buildResponseHeader();
        rpc.packInt(NFS3.StatusCode.Success.intValue());
        this.packWccData(rpc, null);
        this.packPostOpAttr(nfsSess, null, 0, rpc);
        rpc.packLong(nfsSess.getNFSServer().getWriteVerifier());
        rpc.setLength();
        return rpc;
    }

    protected final void packAttributes3(RpcPacket rpc, FileInfo finfo, int fileSysId) {
        if (finfo.isDirectory()) {
            rpc.packInt(NFS3.FileType.Directory.intValue());
            if (finfo.hasMode()) {
                rpc.packInt(finfo.getMode());
            } else {
                rpc.packInt(16895);
            }
        } else {
            if (finfo.isFileType() == FileType.SymbolicLink) {
                rpc.packInt(NFS3.FileType.Link.intValue());
            } else {
                rpc.packInt(NFS3.FileType.Regular.intValue());
            }
            if (finfo.hasMode()) {
                rpc.packInt(finfo.getMode());
            } else {
                rpc.packInt(33279);
            }
        }
        rpc.packInt(1);
        rpc.packInt(finfo.hasUid() ? finfo.getUid() : 0);
        rpc.packInt(finfo.hasGid() ? finfo.getGid() : 0);
        if (finfo.isDirectory()) {
            rpc.packLong(512L);
            rpc.packLong(1024L);
        } else {
            rpc.packLong(finfo.getSize());
            if (finfo.getAllocationSize() != 0L) {
                rpc.packLong(finfo.getAllocationSize());
            } else {
                rpc.packLong(finfo.getSize());
            }
        }
        rpc.packInt(0);
        rpc.packInt(0);
        long fid = (long)finfo.getFileId() & 0xFFFFFFFFL;
        rpc.packLong(fileSysId);
        rpc.packLong(fid += 2L);
        if (finfo.hasAccessDateTime()) {
            rpc.packInt((int)(finfo.getAccessDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
        if (finfo.hasModifyDateTime()) {
            rpc.packInt((int)(finfo.getModifyDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
        if (finfo.hasChangeDateTime()) {
            rpc.packInt((int)(finfo.getChangeDateTime() / 1000L));
            rpc.packInt(0);
        } else {
            rpc.packLong(0L);
        }
    }

    protected final void packShareHandle(String shareName, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packShareHandle(shareName, rpc, 32);
    }

    protected final void packDirectoryHandle(int shareId, int dirId, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packDirectoryHandle(shareId, dirId, rpc, 32);
    }

    protected final void packFileHandle(int shareId, int dirId, int fileId, RpcPacket rpc) {
        rpc.packInt(1);
        NFSHandle.packFileHandle(shareId, dirId, fileId, rpc, 32);
    }

    protected final int getShareIdFromHandle(byte[] handle) throws BadHandleException {
        int shareId = NFSHandle.unpackShareId(handle);
        if (shareId == -1) {
            throw new BadHandleException();
        }
        return shareId;
    }

    protected final String getPathForHandle(NFSSrvSession nfsSess, byte[] handle, TreeConnection tree) throws BadHandleException, StaleHandleException {
        ShareDetails details = nfsSess.getNFSServer().findShareDetails(this.getShareIdFromHandle(handle));
        String path = null;
        int dirId = -1;
        int fileId = -1;
        if (NFSHandle.isShareHandle(handle)) {
            path = "\\";
        } else if (NFSHandle.isDirectoryHandle(handle)) {
            dirId = NFSHandle.unpackDirectoryId(handle);
            path = details.getFileIdCache().findPath(dirId);
        } else if (NFSHandle.isFileHandle(handle)) {
            fileId = NFSHandle.unpackFileId(handle);
            path = details.getFileIdCache().findPath(fileId);
        } else {
            throw new BadHandleException();
        }
        if (path == null) {
            if (details.hasFileIdSupport()) {
                dirId = NFSHandle.unpackDirectoryId(handle);
                fileId = NFSHandle.unpackFileId(handle);
                if (fileId == -1) {
                    fileId = dirId;
                    dirId = -1;
                }
                FileIdInterface fileIdInterface = (FileIdInterface)((Object)tree.getInterface());
                try {
                    path = fileIdInterface.buildPathForFileId(nfsSess, tree, dirId, fileId);
                    details.getFileIdCache().addPath(fileId, path);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (NFSHandle.isDirectoryHandle(handle) && dirId == 0) {
                path = "\\";
                details.getFileIdCache().addPath(dirId, path);
            }
        }
        if (path == null) {
            throw new StaleHandleException();
        }
        return path;
    }

    protected final byte[] getHandleForFile(NFSSrvSession nfsSess, byte[] handle, TreeConnection tree, String fname) throws BadHandleException, StaleHandleException {
        int shareId = this.getShareIdFromHandle(handle);
        ShareDetails details = nfsSess.getNFSServer().findShareDetails(shareId);
        String path = null;
        int dirId = -1;
        int fileId = -1;
        if (NFSHandle.isDirectoryHandle(handle)) {
            dirId = NFSHandle.unpackDirectoryId(handle);
            path = details.getFileIdCache().findPath(dirId);
        } else if (NFSHandle.isShareHandle(handle)) {
            dirId = 0;
            path = "\\";
        } else {
            throw new BadHandleException();
        }
        byte[] fHandle = null;
        try {
            FileInfo finfo;
            DiskInterface disk = (DiskInterface)tree.getSharedDevice().getInterface();
            String filePath = this.generatePath(path, fname);
            FileStatus fsts = disk.fileExists(nfsSess, tree, filePath);
            if ((fsts == FileStatus.FileExists || fsts == FileStatus.DirectoryExists) && (finfo = disk.getFileInformation(nfsSess, tree, filePath)) != null) {
                fileId = finfo.getFileId();
                fHandle = new byte[32];
                if (finfo.isDirectory()) {
                    NFSHandle.packDirectoryHandle(shareId, dirId, fHandle);
                } else {
                    NFSHandle.packFileHandle(shareId, dirId, fileId, fHandle);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fHandle == null) {
            throw new BadHandleException();
        }
        return fHandle;
    }

    protected final int getFileIdForHandle(byte[] handle) throws BadHandleException {
        int fileId = -1;
        if (NFSHandle.isShareHandle(handle)) {
            fileId = 0;
        } else if (NFSHandle.isDirectoryHandle(handle)) {
            fileId = NFSHandle.unpackDirectoryId(handle);
        } else if (NFSHandle.isFileHandle(handle)) {
            fileId = NFSHandle.unpackFileId(handle);
        }
        if (fileId == -1) {
            throw new BadHandleException();
        }
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NetworkFile getNetworkFileForHandle(NFSSrvSession nfsSess, byte[] handle, TreeConnection conn, boolean readOnly) throws BadHandleException, StaleHandleException {
        if (!NFSHandle.isFileHandle(handle)) {
            throw new BadHandleException("Not a file handle");
        }
        int fileId = this.getFileIdForHandle(handle);
        NetworkFileCache fileCache = nfsSess.getFileCache();
        NetworkFile file = null;
        NetworkFileCache networkFileCache = fileCache;
        synchronized (networkFileCache) {
            file = fileCache.findFile(fileId, nfsSess);
            if (file == null || file.getGrantedAccess() == NetworkFile.Access.READ_ONLY && !readOnly) {
                String path = this.getPathForHandle(nfsSess, handle, conn);
                if (path == null) {
                    throw new StaleHandleException();
                }
                try {
                    FileOpenParams params;
                    DiskInterface disk;
                    if (file != null) {
                        file.closeFile();
                    }
                    if ((file = (disk = (DiskInterface)conn.getSharedDevice().getInterface()).openFile(nfsSess, conn, params = new FileOpenParams(path, 1, readOnly ? 0 : 2, 0, 0))) != null) {
                        fileCache.addFile(file, conn, nfsSess);
                    }
                }
                catch (AccessDeniedException ex) {
                    if (nfsSess.hasDebug(NFSSrvSession.Dbg.FILE)) {
                        Debug.println(ex);
                    }
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            } else if (file.getGrantedAccess() != NetworkFile.Access.READ_ONLY || !readOnly) {
                // empty if block
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final NetworkFile getOpenNetworkFileForHandle(NFSSrvSession nfsSess, byte[] handle, TreeConnection conn) throws BadHandleException, StaleHandleException {
        if (!NFSHandle.isFileHandle(handle)) {
            return null;
        }
        int fileId = this.getFileIdForHandle(handle);
        NetworkFileCache fileCache = nfsSess.getFileCache();
        NetworkFile file = null;
        NetworkFileCache networkFileCache = fileCache;
        synchronized (networkFileCache) {
            file = fileCache.findFile(fileId, nfsSess);
        }
        return file;
    }

    protected final TreeConnection getTreeConnection(NFSSrvSession nfsSess, int shareId) throws BadHandleException {
        TreeConnection conn = nfsSess.findConnection(shareId);
        if (conn == null) {
            TreeConnection template = nfsSess.getNFSServer().findConnection(shareId);
            if (template == null && nfsSess.getNFSServer().checkForNewShares() > 0) {
                template = nfsSess.getNFSServer().findConnection(shareId);
            }
            if (template == null) {
                throw new BadHandleException();
            }
            if (nfsSess.getNFSServer().hasAccessControlManager()) {
                AccessControlManager aclMgr = nfsSess.getNFSServer().getAccessControlManager();
                int sharePerm = aclMgr.checkAccessControl(nfsSess, template.getSharedDevice());
                if (sharePerm == 0) {
                    throw new BadHandleException();
                }
                if (sharePerm == -1) {
                    sharePerm = 2;
                }
                conn = new TreeConnection(template.getSharedDevice());
                conn.setPermission(sharePerm);
                nfsSess.addConnection(conn);
            } else {
                conn = new TreeConnection(template.getSharedDevice());
                conn.setPermission(ISMBAuthenticator.ShareStatus.WRITEABLE);
                nfsSess.addConnection(conn);
            }
        }
        return conn;
    }

    protected final void packWccData(RpcPacket rpc, FileInfo finfo) {
        if (finfo != null) {
            rpc.packInt(1);
            if (finfo.isDirectory()) {
                rpc.packLong(512L);
            } else {
                rpc.packLong(finfo.getSize());
            }
            if (finfo.hasModifyDateTime()) {
                rpc.packInt((int)(finfo.getModifyDateTime() / 1000L));
                rpc.packInt(0);
            } else {
                rpc.packLong(0L);
            }
            if (finfo.hasChangeDateTime()) {
                rpc.packInt((int)(finfo.getChangeDateTime() / 1000L));
                rpc.packInt(0);
            } else {
                rpc.packLong(0L);
            }
        } else {
            rpc.packInt(0);
        }
    }

    protected final boolean pathHasDirectories(String fpath) {
        if (fpath == null || fpath.length() == 0) {
            return false;
        }
        if (fpath.startsWith("\\") || fpath.startsWith("/") || fpath.startsWith("..")) {
            return true;
        }
        return fpath.indexOf("\\") != -1 || fpath.indexOf("/") != -1;
    }

    protected final void packPreOpAttr(NFSSrvSession nfsSess, FileInfo finfo, RpcPacket rpc) {
        if (finfo != null) {
            this.packWccData(rpc, finfo);
        } else {
            rpc.packInt(0);
        }
    }

    protected final void packPreOpAttr(NFSSrvSession nfsSess, TreeConnection conn, byte[] fhandle, RpcPacket rpc) throws BadHandleException, StaleHandleException, InvalidDeviceInterfaceException, IOException {
        String path = this.getPathForHandle(nfsSess, fhandle, conn);
        DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
        FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
        this.packWccData(rpc, finfo);
    }

    protected final void packPostOpAttr(NFSSrvSession nfsSess, TreeConnection conn, byte[] fhandle, RpcPacket rpc) throws BadHandleException, StaleHandleException, InvalidDeviceInterfaceException, IOException {
        String path = this.getPathForHandle(nfsSess, fhandle, conn);
        DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
        FileInfo finfo = disk.getFileInformation(nfsSess, conn, path);
        if (finfo != null) {
            rpc.packInt(1);
            this.packAttributes3(rpc, finfo, this.getShareIdFromHandle(fhandle));
        } else {
            rpc.packInt(0);
        }
    }

    protected final void packPostOpAttr(NFSSrvSession nfsSess, FileInfo finfo, int fileSysId, RpcPacket rpc) {
        if (finfo != null) {
            rpc.packInt(1);
            this.packAttributes3(rpc, finfo, fileSysId);
        } else {
            rpc.packInt(0);
        }
    }

    protected final String generatePath(String dirPath, String argPath) {
        StringBuffer pathBuf = new StringBuffer();
        if (argPath.equals("..")) {
            String[] dirs = FileName.splitAllPaths(dirPath);
            pathBuf.append("\\");
            int dirCnt = dirs.length - 1;
            if (dirCnt > 0) {
                for (int i = 0; i < dirCnt; ++i) {
                    pathBuf.append(dirs[i]);
                    pathBuf.append("\\");
                }
            }
            if (pathBuf.length() > 1) {
                pathBuf.setLength(pathBuf.length() - 1);
            }
        } else {
            pathBuf.append(dirPath);
            if (!dirPath.endsWith("\\")) {
                pathBuf.append("\\");
            }
            if (!argPath.equals(".")) {
                pathBuf.append(argPath);
            }
        }
        return pathBuf.toString();
    }
}

