/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.filesys.debug.Debug;
import org.filesys.server.NetworkServer;
import org.filesys.server.SessionHandlerInterface;
import org.filesys.server.core.NoPooledMemoryException;

public abstract class DatagramSessionHandler
implements SessionHandlerInterface,
Runnable {
    private NetworkServer m_server;
    private int m_port;
    private InetAddress m_bindAddr;
    private DatagramSocket m_srvSock;
    private int m_maxDgramSize;
    private int m_sessId;
    private String m_name;
    private String m_protocol;
    private boolean m_shutdown;
    private boolean m_debug;

    protected DatagramSessionHandler(String name, String protocol, NetworkServer server, InetAddress addr, int port) {
        this.m_name = name;
        this.m_protocol = protocol;
        this.m_server = server;
        this.m_bindAddr = addr;
        this.m_port = port;
    }

    public final int getMaximumDatagramSize() {
        return this.m_maxDgramSize;
    }

    @Override
    public final String getHandlerName() {
        return this.m_name;
    }

    public final String getProtocolName() {
        return this.m_protocol;
    }

    public final boolean hasBindAddress() {
        return this.m_bindAddr != null;
    }

    public final InetAddress getBindAddres() {
        return this.m_bindAddr;
    }

    public final int getPort() {
        return this.m_port;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    protected final void clearShutdown() {
        this.m_shutdown = false;
    }

    protected final boolean hasShutdown() {
        return this.m_shutdown;
    }

    protected synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    protected final void setPort(int port) {
        this.m_port = port;
    }

    protected final DatagramSocket getDatagramSocket() {
        return this.m_srvSock;
    }

    @Override
    public void initializeSessionHandler(NetworkServer server) throws IOException {
        this.m_srvSock = this.hasBindAddress() ? new DatagramSocket(this.getPort(), this.getBindAddres()) : new DatagramSocket(this.getPort());
        if (this.m_srvSock.getReceiveBufferSize() < this.getMaximumDatagramSize()) {
            this.m_srvSock.setReceiveBufferSize(this.getMaximumDatagramSize());
        }
        if (this.getPort() == 0) {
            this.setPort(this.m_srvSock.getLocalPort());
        }
        if (this.hasDebug()) {
            Debug.print("[" + this.getProtocolName() + "] Binding " + this.getHandlerName() + " session handler to address : ");
            if (this.hasBindAddress()) {
                Debug.println(this.getBindAddres().getHostAddress());
            } else {
                Debug.println("ALL");
            }
        }
    }

    @Override
    public void closeSessionHandler(NetworkServer server) {
        this.m_shutdown = true;
        if (this.m_srvSock != null) {
            this.m_srvSock.close();
        }
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    protected final void setMaximumDatagramSize(int maxSize) {
        this.m_maxDgramSize = maxSize;
    }

    protected abstract boolean processDatagram(DatagramPacket var1) throws IOException;

    protected byte[] allocateBuffer(int bufSize) throws NoPooledMemoryException {
        return new byte[bufSize];
    }

    protected void sendDatagram(DatagramPacket pkt) throws IOException {
        if (this.m_srvSock == null) {
            throw new IOException("Datagram socket is null");
        }
        this.m_srvSock.send(pkt);
    }

    @Override
    public void run() {
        block13: {
            try {
                Thread.currentThread().setName(this.getProtocolName() + "_" + this.getHandlerName());
                this.clearShutdown();
                if (this.hasDebug()) {
                    Debug.println("[" + this.getProtocolName() + "] Waiting for datagrams ...");
                }
                byte[] buf = null;
                DatagramPacket pkt = null;
                boolean reusePkt = false;
                while (!this.hasShutdown()) {
                    if (!reusePkt) {
                        buf = this.allocateBuffer(this.getMaximumDatagramSize());
                        if (pkt == null) {
                            pkt = new DatagramPacket(buf, buf.length);
                        } else {
                            pkt.setData(buf, 0, buf.length);
                        }
                    } else {
                        pkt.setData(buf, 0, buf.length);
                    }
                    this.m_srvSock.receive(pkt);
                    try {
                        reusePkt = this.processDatagram(pkt);
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) continue;
                        Debug.println("[" + this.getProtocolName() + "] Error processing datagram, " + ex.toString());
                    }
                }
            }
            catch (SocketException ex) {
                if (!this.hasShutdown()) {
                    Debug.println("[" + this.getProtocolName() + "] Socket error : " + ex.toString());
                    Debug.println(ex);
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block13;
                Debug.println("[" + this.getProtocolName() + "] Server error : " + ex.toString());
                Debug.println(ex);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[" + this.getProtocolName() + "] " + this.getHandlerName() + " session handler closed");
        }
    }
}

