/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.filesys.debug.Debug;
import org.filesys.server.NetworkServer;
import org.filesys.server.SessionHandlerBase;

public abstract class SocketSessionHandler
extends SessionHandlerBase
implements Runnable {
    private ServerSocket m_srvSock;
    private int m_clientSockTmo;

    public SocketSessionHandler(String name, String protocol, NetworkServer server, InetAddress addr, int port) {
        super(name, protocol, server, addr, port);
    }

    public final ServerSocket getSocket() {
        return this.m_srvSock;
    }

    public final int getSocketTimeout() {
        return this.m_clientSockTmo;
    }

    public final void setSocketTimeout(int tmo) {
        this.m_clientSockTmo = tmo;
    }

    @Override
    public void initializeSessionHandler(NetworkServer server) throws IOException {
        this.m_srvSock = this.hasBindAddress() ? new ServerSocket(this.getPort(), this.getListenBacklog(), this.getBindAddress()) : new ServerSocket(this.getPort(), this.getListenBacklog());
        if (this.getPort() == 0) {
            this.setPort(this.m_srvSock.getLocalPort());
        }
        if (this.hasDebug()) {
            Debug.print("[" + this.getProtocolName() + "] Binding " + this.getHandlerName() + " session handler to address : ");
            if (this.hasBindAddress()) {
                Debug.println(this.getBindAddress().getHostAddress());
            } else {
                Debug.println("ALL");
            }
        }
    }

    @Override
    public void closeSessionHandler(NetworkServer server) {
        this.setShutdown(true);
        try {
            if (this.m_srvSock != null) {
                this.m_srvSock.close();
            }
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        block10: {
            try {
                this.clearShutdown();
                while (!this.hasShutdown()) {
                    if (this.hasDebug()) {
                        Debug.println("[" + this.getProtocolName() + "] Waiting for session request ...");
                    }
                    Socket sessSock = this.m_srvSock.accept();
                    if (this.hasDebug()) {
                        Debug.println("[" + this.getProtocolName() + "] Session request received from " + sessSock.getInetAddress().getHostAddress());
                    }
                    try {
                        this.acceptConnection(sessSock);
                    }
                    catch (Exception ex) {
                        if (!this.hasDebug()) continue;
                        Debug.println("[" + this.getProtocolName() + "] Failed to create session, " + ex.toString());
                    }
                }
            }
            catch (SocketException ex) {
                if (!this.hasShutdown()) {
                    Debug.println("[" + this.getProtocolName() + "] Socket error : " + ex.toString());
                    Debug.println(ex);
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block10;
                Debug.println("[" + this.getProtocolName() + "] Server error : " + ex.toString());
                Debug.println(ex);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[" + this.getProtocolName() + "] " + this.getHandlerName() + " session handler closed");
        }
    }

    protected abstract void acceptConnection(Socket var1);
}

