/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.filesys.debug.Debug;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.NTLanManAuthContext;
import org.filesys.server.auth.SMBAuthenticator;
import org.filesys.server.auth.SecurityBlob;
import org.filesys.server.auth.TransactionalSMBAuthenticator;
import org.filesys.server.auth.UserAccount;
import org.filesys.server.auth.kerberos.KerberosDetails;
import org.filesys.server.auth.kerberos.SessionSetupPrivilegedAction;
import org.filesys.server.auth.ntlm.NTLM;
import org.filesys.server.auth.ntlm.NTLMMessage;
import org.filesys.server.auth.ntlm.NTLMv2Blob;
import org.filesys.server.auth.ntlm.StringTargetInfo;
import org.filesys.server.auth.ntlm.TargetInfo;
import org.filesys.server.auth.ntlm.TimestampTargetInfo;
import org.filesys.server.auth.ntlm.Type1NTLMMessage;
import org.filesys.server.auth.ntlm.Type2NTLMMessage;
import org.filesys.server.auth.ntlm.Type3NTLMMessage;
import org.filesys.server.auth.spnego.NegTokenInit;
import org.filesys.server.auth.spnego.NegTokenTarg;
import org.filesys.server.auth.spnego.OID;
import org.filesys.server.auth.spnego.SPNEGO;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.SetupObjectType;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;
import org.ietf.jgss.Oid;
import org.springframework.extensions.config.ConfigElement;

public class EnterpriseSMBAuthenticator
extends SMBAuthenticator
implements CallbackHandler {
    private static final String LoginConfigEntry = "FileServerSMB";
    private static final String LineSeperator = System.getProperty("line.separator");
    private static final int NTLM_UNSUPPORTED_FLAGS = 0;
    private static final int NTLM_SERVER_FLAGS = 1653244469;
    private static final int MIC_TOKEN_LENGTH = 16;
    private static final int MIC_TOKEN_VERSION = 0;
    private static final int MIC_TOKEN_DIGEST = 4;
    private static final int MIC_TOKEN_SEQNO = 12;
    private static final int MIC_TOKEN_VER_NTLMSSP = 1;
    private static final boolean EXTRA_DEBUG = true;
    protected boolean m_useRawNTLMSSP;
    protected boolean m_allowNTLM = true;
    protected boolean m_acceptNTLMv1;
    protected String m_accountName;
    protected String m_password;
    protected String m_krbRealm;
    protected String m_loginEntryName = "FileServerSMB";
    protected LoginContext m_loginContext;
    protected byte[] m_negTokenInit;

    public EnterpriseSMBAuthenticator() {
        this.setExtendedSecurity(true);
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        ConfigElement disallowNTLMv1;
        super.initialize(config, params);
        if (params.getChild("disableSessionCleanup") != null) {
            this.setSessionCleanup(false);
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Disabled session cleanup (for virtual circuit zero logons)");
            }
        }
        if (params.getChild("kerberosDebug") != null) {
            System.setProperty("sun.security.jgss.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("com.ibm.security.jgss.debug", "all");
        }
        SMBConfigSection cifsConfig = (SMBConfigSection)config.getConfigSection("SMB");
        ConfigElement krbRealm = params.getChild("Realm");
        if (krbRealm != null && krbRealm.getValue() != null && krbRealm.getValue().length() > 0) {
            ConfigElement loginEntry;
            ConfigElement loginConfPath;
            ConfigElement krb5ConfPath;
            this.m_krbRealm = krbRealm.getValue();
            ConfigElement srvPassword = params.getChild("Password");
            if (srvPassword != null && srvPassword.getValue() != null && srvPassword.getValue().length() > 0) {
                this.m_password = srvPassword.getValue();
            }
            if ((krb5ConfPath = params.getChild("KerberosConfig")) != null) {
                String krb5Path = krb5ConfPath.getValue();
                if (Files.exists(Paths.get(krb5Path, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    System.setProperty("java.security.krb5.conf", krb5Path);
                } else {
                    throw new InvalidConfigurationException("Kerberos configuration file does not exist - " + krb5Path);
                }
            }
            if ((loginConfPath = params.getChild("LoginConfig")) != null) {
                String loginPath = loginConfPath.getValue();
                if (Files.exists(Paths.get(loginPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    System.setProperty("java.security.auth.login.config", loginPath);
                } else {
                    throw new InvalidConfigurationException("Login configuration file does not exist - " + loginPath);
                }
            }
            if ((loginEntry = params.getChild("LoginEntry")) != null) {
                if (loginEntry.getValue() != null && loginEntry.getValue().length() > 0) {
                    this.m_loginEntryName = loginEntry.getValue();
                } else {
                    throw new InvalidConfigurationException("Invalid login entry specified");
                }
            }
            try {
                this.m_loginContext = new LoginContext(this.m_loginEntryName, this);
                this.m_loginContext.login();
            }
            catch (LoginException ex) {
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Kerberos authenticator error - " + ex.getMessage());
                }
                throw new InvalidConfigurationException("Failed to login SMB server service");
            }
            Subject subj = this.m_loginContext.getSubject();
            Principal princ = subj.getPrincipals().iterator().next();
            this.m_accountName = princ.getName();
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Logged on using principal " + this.m_accountName);
            }
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Enabling mechTypes :-");
                this.debugOutput("       Kerberos5");
                this.debugOutput("       MS-Kerberos5");
            }
            ArrayList<Oid> mechTypes = new ArrayList<Oid>();
            mechTypes.add(OID.MSKERBEROS5);
            mechTypes.add(OID.KERBEROS5);
            if (params.getChild("disableNTLM") == null) {
                mechTypes.add(OID.NTLMSSP);
                if (this.hasDebug()) {
                    this.debugOutput("       NTLMSSP");
                }
                this.m_allowNTLM = true;
            } else {
                this.m_allowNTLM = false;
            }
            try {
                String mecListMIC = null;
                StringBuilder mic = new StringBuilder();
                mic.append("cifs/");
                mic.append(cifsConfig.getServerName().toLowerCase());
                mic.append("@");
                mic.append(this.m_krbRealm);
                mecListMIC = mic.toString();
                NegTokenInit negTokenInit = new NegTokenInit(mechTypes, mecListMIC);
                this.m_negTokenInit = negTokenInit.encode();
            }
            catch (IOException ex) {
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Error creating SPNEGO NegTokenInit blob - " + ex.getMessage());
                }
                throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
            }
            this.m_useRawNTLMSSP = false;
        } else {
            ConfigElement useSpnego = params.getChild("useSPNEGO");
            if (useSpnego != null) {
                ArrayList<Oid> mechTypes = new ArrayList<Oid>();
                mechTypes.add(OID.NTLMSSP);
                try {
                    NegTokenInit negTokenInit = new NegTokenInit(mechTypes, null);
                    this.m_negTokenInit = negTokenInit.encode();
                }
                catch (IOException ex) {
                    if (this.hasDebugOutput()) {
                        this.debugOutput("[SMB] Error creating SPNEGO NegTokenInit blob - " + ex.getMessage());
                    }
                    throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
                }
                this.m_useRawNTLMSSP = false;
            } else {
                this.m_useRawNTLMSSP = true;
            }
        }
        if (params.getChild("disableNTLM") != null) {
            this.m_allowNTLM = false;
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] NTLM logons disabled");
            }
        }
        boolean bl = this.m_acceptNTLMv1 = (disallowNTLMv1 = params.getChild("disallowNTLMv1")) == null;
        if (!this.allowNTLMLogon() && this.m_loginContext == null) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] No authentication methods enabled");
            }
            throw new InvalidConfigurationException("No authentication methods enabled, require NTLMSSP or SPNEGO");
        }
    }

    @Override
    public boolean usingSPNEGO() {
        return !this.m_useRawNTLMSSP;
    }

    @Override
    public byte[] getNegTokenInit() {
        return this.m_negTokenInit;
    }

    private final boolean allowNTLMLogon() {
        return this.m_allowNTLM;
    }

    private final boolean acceptNTLMv1Logon() {
        return this.m_acceptNTLMv1;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.m_accountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                if (this.m_password != null) {
                    ((PasswordCallback)cb).setPassword(this.m_password.toCharArray());
                    continue;
                }
                ((PasswordCallback)cb).setPassword("".toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.m_krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    @Override
    public int getEncryptionKeyLength() {
        return 8;
    }

    @Override
    public int getServerCapabilities() {
        return -2147425540;
    }

    @Override
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        SMBV1Parser parser = (SMBV1Parser)reqPkt.getParser();
        if (!parser.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (parser.getParameterCount() == 13) {
            this.doHashedPasswordLogon(sess, reqPkt);
            return;
        }
        int maxBufSize = parser.getParameter(2);
        int maxMpx = parser.getParameter(3);
        int vcNum = parser.getParameter(4);
        int secBlobLen = parser.getParameter(7);
        int capabs = parser.getParameterLong(10);
        int dataPos = parser.getByteOffset();
        byte[] buf = parser.getBuffer();
        boolean isUni = parser.isUnicode();
        int secBlobPos = dataPos;
        parser.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (parser.hasMoreData() && (domain = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (parser.hasMoreData() && (clientOS = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (this.hasDebugOutput()) {
            this.debugOutput("[SMB] NT Session setup " + (this.usingSPNEGO() ? "SPNEGO" : "NTLMSSP") + ", MID=" + parser.getMultiplexId() + ", UID=" + parser.getUserId() + ", PID=" + parser.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.createInfo(null, null);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(ClientInfo.LogonType.Normal);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        client.setProcessId(parser.getProcessId());
        Object setupObj = sess.getSetupObject(client.getProcessId(), SetupObjectType.Type2Message);
        boolean isNTLMSSP = false;
        SecurityBlob secBlob = null;
        ISMBAuthenticator.AuthStatus authSts = ISMBAuthenticator.AuthStatus.DISALLOW;
        try {
            if (secBlobLen >= NTLM.Signature.length) {
                int idx;
                for (idx = 0; idx < NTLM.Signature.length && buf[secBlobPos + idx] == NTLM.Signature[idx]; ++idx) {
                }
                if (idx == NTLM.Signature.length) {
                    isNTLMSSP = true;
                }
            }
            secBlob = new SecurityBlob(isNTLMSSP ? SecurityBlob.SecurityBlobType.NTLMSSP : SecurityBlob.SecurityBlobType.SPNEGO, buf, secBlobPos, secBlobLen, isUni);
            authSts = this.processSecurityBlob(sess, client, secBlob);
        }
        catch (SMBSrvException ex) {
            sess.removeAllSetupObjects(client.getProcessId());
            throw ex;
        }
        if (authSts == ISMBAuthenticator.AuthStatus.DISALLOW) {
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
            if (!secBlob.hasResponseBlob()) {
                this.debugOutput("[SMB] User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            } else {
                this.debugOutput("[SMB] Two stage logon (" + (isNTLMSSP ? "NTLMSSP" : "SPNEGO") + ")");
            }
        }
        int respLen = secBlob.hasResponseBlob() ? secBlob.getResponseLength() : 0;
        SMBSrvPacket respPkt = reqPkt;
        boolean loggedOn = false;
        if (secBlob.hasResponseBlob() || sess.hasSetupObject(client.getProcessId(), SetupObjectType.Type2Message) || setupObj != null) {
            if (sess.hasSetupObject(client.getProcessId(), SetupObjectType.Type2Message)) {
                parser.setLongErrorCode(-1073741802);
            } else {
                this.onSuccessfulLogon(client);
                parser.setLongErrorCode(0);
                loggedOn = true;
            }
            parser.setParameterCount(4);
            int reqLen = respLen + 100;
            if (reqLen > parser.getAvailableLength()) {
                try {
                    respPkt = sess.getPacketPool().allocatePacket(parser.getByteOffset() + reqLen, reqPkt);
                    respPkt.setParser(SMBSrvPacket.Version.V1);
                    parser = (SMBV1Parser)respPkt.getParser();
                }
                catch (NoPooledMemoryException ex) {
                    if (this.hasDebug()) {
                        this.debugOutput("Authenticator failed to allocate packet from pool, reqSiz=" + (parser.getByteOffset() + respLen));
                    }
                    throw new SMBSrvException(-1073741811, 83, 2);
                }
            }
            parser.setParameter(0, 255);
            parser.setParameter(1, 0);
            parser.setParameter(2, 0);
            parser.setParameter(3, respLen);
        } else {
            this.onSuccessfulLogon(client);
            parser.setLongErrorCode(0);
            parser.setParameterCount(12);
            parser.setParameter(0, 255);
            parser.setParameter(1, 0);
            parser.setParameter(2, 65540);
            parser.setParameter(3, 4);
            parser.setParameter(4, vcNum);
            parser.setParameterLong(5, 0);
            parser.setParameter(7, respLen);
            parser.setParameterLong(8, 0);
            parser.setParameterLong(10, this.getServerCapabilities());
            loggedOn = true;
        }
        int uid = 65535;
        if (loggedOn) {
            int discCnt;
            if (vcNum == 0 && this.hasSessionCleanup() && (discCnt = sess.disconnectClientSessions()) > 0 && sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
                this.debugOutput("[SMB] Disconnected " + discCnt + " existing sessions from client, sess=" + sess);
            }
            sess.removeAllSetupObjects(client.getProcessId());
            VirtualCircuit vc = new VirtualCircuit(vcNum, client);
            uid = sess.addVirtualCircuit(vc);
            if (uid == -1) {
                if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
                    this.debugOutput("[SMB] Failed to allocate UID for virtual circuit, " + vc);
                }
                throw new SMBSrvException(-1073741618, 90, 2);
            }
            if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
                this.debugOutput("[SMB] Allocated UID=" + uid + " for VC=" + vc);
            }
        }
        parser.setCommand(parser.getCommand());
        parser.setByteCount(0);
        parser.setTreeId(loggedOn ? 0 : 65535);
        parser.setUserId(uid);
        int flags = parser.getFlags();
        parser.setFlags(flags &= 0xFFFFFFF7);
        parser.setResponse();
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        parser.setFlags2(flags2);
        int pos = parser.getByteOffset();
        buf = parser.getBuffer();
        if (secBlob.hasResponseBlob()) {
            System.arraycopy(secBlob.getResponseBlob(), 0, buf, pos, secBlob.getResponseLength());
            pos += secBlob.getResponseLength();
        }
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Java File Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        if (!secBlob.hasResponseBlob()) {
            pos = DataPacker.putString(sess.getSMBServer().getSMBConfiguration().getDomainName(), buf, pos, true, isUni);
        }
        parser.setByteCount(pos - parser.getByteOffset());
        parser.setParameter(1, pos - 4);
    }

    @Override
    public ISMBAuthenticator.AuthStatus processSecurityBlob(SMBSrvSession sess, ClientInfo client, SecurityBlob secBlob) throws SMBSrvException {
        ISMBAuthenticator.AuthStatus authSts = ISMBAuthenticator.AuthStatus.DISALLOW;
        if (this instanceof TransactionalSMBAuthenticator) {
            TransactionalSMBAuthenticator transAuth = (TransactionalSMBAuthenticator)((Object)this);
            authSts = transAuth.processSecurityBlobInTransaction(sess, client, secBlob);
        } else {
            authSts = this.processSecurityBlobInternal(sess, client, secBlob);
        }
        return authSts;
    }

    public final ISMBAuthenticator.AuthStatus processSecurityBlobInternal(SMBSrvSession sess, ClientInfo client, SecurityBlob secBlob) throws SMBSrvException {
        int respLen;
        Object setupObj = sess.getSetupObject(client.getProcessId(), SetupObjectType.Type2Message);
        if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
            this.debugOutput("[SMB] Process security blob=" + secBlob);
        }
        ISMBAuthenticator.AuthStatus authSts = ISMBAuthenticator.AuthStatus.DISALLOW;
        try {
            authSts = secBlob.isNTLMSSP() ? this.doNtlmsspSessionSetup(sess, client, secBlob, false) : this.doSpnegoSessionSetup(sess, client, secBlob);
        }
        catch (SMBSrvException ex) {
            sess.removeAllSetupObjects(client.getProcessId());
            throw ex;
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
            if (authSts == ISMBAuthenticator.AuthStatus.AUTHENTICATED) {
                this.debugOutput("[SMB] User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : ""));
            } else {
                this.debugOutput("[SMB] Two stage logon (" + secBlob.isType().name() + ")");
            }
        }
        int n = respLen = secBlob.hasResponseBlob() ? secBlob.getResponseLength() : 0;
        if (authSts == ISMBAuthenticator.AuthStatus.AUTHENTICATED) {
            sess.removeAllSetupObjects(client.getProcessId());
            this.onSuccessfulLogon(client);
        }
        return authSts;
    }

    private final ISMBAuthenticator.AuthStatus doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, SecurityBlob secBlob, boolean spnego) throws SMBSrvException {
        if (!this.allowNTLMLogon()) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] NTLM disabled, received NTLM logon from client (NTLMSSP)");
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        ISMBAuthenticator.AuthStatus authSts = ISMBAuthenticator.AuthStatus.DISALLOW;
        NTLMMessage.Type msgType = NTLMMessage.isNTLMType(secBlob.getSecurityBlob(), secBlob.getSecurityOffset());
        byte[] respBlob = null;
        if (msgType == NTLMMessage.Type.Invalid) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Invalid NTLMSSP token received");
                this.debugOutput("[SMB]   Token=" + HexDump.hexString(secBlob.getSecurityBlob(), secBlob.getSecurityOffset(), secBlob.getSecurityLength(), " "));
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (msgType == NTLMMessage.Type.Negotiate) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secBlob.getSecurityBlob(), secBlob.getSecurityOffset(), secBlob.getSecurityLength());
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Received NTLM Type1/Negotiate - " + type1Msg.toString());
            }
            if (spnego || type1Msg.hasFlag(16) || type1Msg.hasFlag(32768)) {
                type1Msg = type1Msg.clone();
                sess.setSetupObject(client.getProcessId(), type1Msg, SetupObjectType.Type1Message);
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Signing required/SPNEGO, saved Type1");
                }
            }
            int ntlmFlags = type1Msg.getFlags() & 0;
            NTLanManAuthContext ntlmCtx = new NTLanManAuthContext();
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new StringTargetInfo(TargetInfo.Type.DOMAIN, domain));
            tList.add(new StringTargetInfo(TargetInfo.Type.SERVER, sess.getServerName()));
            tList.add(new StringTargetInfo(TargetInfo.Type.DNS_DOMAIN, domain.toLowerCase()));
            tList.add(new StringTargetInfo(TargetInfo.Type.FULL_DNS, domain.toLowerCase()));
            tList.add(new TimestampTargetInfo());
            ntlmFlags = 1653244469;
            if (this.acceptNTLMv1Logon()) {
                ntlmFlags -= Integer.MIN_VALUE;
            }
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(client.getProcessId(), type2Msg, SetupObjectType.Type2Message);
            respBlob = type2Msg.getBytes();
            secBlob.setResponseBlob(respBlob);
            authSts = ISMBAuthenticator.AuthStatus.MORE_PROCESSING;
        } else if (msgType == NTLMMessage.Type.Authenticate) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secBlob.getSecurityBlob(), secBlob.getSecurityOffset(), secBlob.getSecurityLength(), secBlob.isUnicode());
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Received NTLM Type3/Authenticate - " + type3Msg.toString());
            }
            if (!sess.hasSetupObject(client.getProcessId(), SetupObjectType.Type2Message)) {
                sess.removeAllSetupObjects(client.getProcessId());
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            if (spnego || type3Msg.hasFlag(16) || type3Msg.hasFlag(32768)) {
                type3Msg = type3Msg.clone();
                sess.setSetupObject(client.getProcessId(), type3Msg, SetupObjectType.Type3Message);
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Signing required/SPNEGO, saved Type3");
                }
            }
            if (type3Msg.hasFlag(0x20000000) || type3Msg.hasFlag(524288)) {
                if (type3Msg.getNTLMHashLength() > 24) {
                    this.doNTLMv2Logon(sess, client, type3Msg);
                    if (this.hasDebugOutput()) {
                        this.debugOutput("[SMB] Logged on using NTLMSSP/NTLMv2");
                    }
                } else {
                    this.doNTLMv2SessionKeyLogon(sess, client, type3Msg);
                    if (this.hasDebugOutput()) {
                        this.debugOutput("[SMB] Logged on using NTLMSSP/NTLMv2SessKey");
                    }
                }
            } else {
                this.doNTLMv1Logon(sess, client, type3Msg);
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Logged on using NTLMSSP/NTLMv1");
                }
            }
            authSts = ISMBAuthenticator.AuthStatus.AUTHENTICATED;
        }
        return authSts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ISMBAuthenticator.AuthStatus doSpnegoSessionSetup(SMBSrvSession sess, ClientInfo client, SecurityBlob secBlob) throws SMBSrvException {
        NegTokenTarg negTarg;
        ISMBAuthenticator.AuthStatus authSts;
        block23: {
            int tokType;
            block25: {
                Object negToken;
                block24: {
                    authSts = ISMBAuthenticator.AuthStatus.DISALLOW;
                    tokType = -1;
                    try {
                        tokType = SPNEGO.checkTokenType(secBlob);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    negTarg = null;
                    if (tokType != 1 || !sess.hasSetupObject(client.getProcessId(), SetupObjectType.Type2Message)) break block24;
                    negToken = new NegTokenTarg();
                    try {
                        ((NegTokenTarg)negToken).decode(secBlob);
                    }
                    catch (IOException ex) {
                        if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                        this.debugOutput(ex);
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                    byte[] ntlmsspBlob = ((NegTokenTarg)negToken).getResponseToken();
                    SecurityBlob ntlmBlob = new SecurityBlob(SecurityBlob.SecurityBlobType.NTLMSSP, ntlmsspBlob, secBlob.isUnicode());
                    authSts = this.doNtlmsspSessionSetup(sess, client, ntlmBlob, true);
                    SPNEGO.Result spnegoSts = SPNEGO.Result.AcceptCompleted;
                    byte[] mechListMIC = null;
                    if (authSts == ISMBAuthenticator.AuthStatus.MORE_PROCESSING) {
                        spnegoSts = SPNEGO.Result.AcceptIncomplete;
                    } else if (((NegTokenTarg)negToken).hasMechListMIC() && sess.hasSessionKey("SessionKey") && sess.hasSetupObject(client.getProcessId(), SetupObjectType.NegTokenInit)) {
                        byte[] mechList;
                        NegTokenInit negInit = (NegTokenInit)sess.getSetupObject(client.getProcessId(), SetupObjectType.NegTokenInit);
                        if (negInit.hasMechListBytes() && !this.verifyMIC(sess, mechList = negInit.getMechListBytes(), 0, mechList.length, ((NegTokenTarg)negToken).getMechListMIC(), client.getProcessId())) {
                            throw new SMBSrvException(-1073741715, 1, 5);
                        }
                        NegTokenInit initToken = (NegTokenInit)sess.getSetupObject(client.getProcessId(), SetupObjectType.NegTokenInit);
                        if (initToken.hasMechListBytes()) {
                            byte[] initTokenByts = initToken.getMechListBytes();
                            mechListMIC = this.generateMIC(sess, initTokenByts, 0, initTokenByts.length, 0);
                        }
                        sess.removeAllSetupObjects(client.getProcessId());
                    }
                    negTarg = new NegTokenTarg(spnegoSts, null, ntlmBlob.getResponseBlob());
                    negTarg.setMechListMIC(mechListMIC);
                    break block23;
                }
                if (tokType != 0) break block25;
                negToken = new NegTokenInit();
                try {
                    ((NegTokenInit)negToken).decode(secBlob);
                }
                catch (IOException ex) {
                    if (!this.hasDebug()) throw new SMBSrvException(-1073741715, 1, 5);
                    this.debugOutput(ex);
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
                sess.setSetupObject(client.getProcessId(), negToken, SetupObjectType.NegTokenInit);
                String oidStr = null;
                if (((NegTokenInit)negToken).numberOfOids() > 0) {
                    oidStr = ((NegTokenInit)negToken).getOidAt(0).toString();
                }
                if (oidStr != null && oidStr.equals("1.3.6.1.4.1.311.2.2.10")) {
                    if (!this.allowNTLMLogon()) {
                        if (!this.hasDebugOutput()) throw new SMBSrvException(-1073741715, 1, 5);
                        this.debugOutput("[SMB] NTLM disabled, received NTLM logon from client (SPNEGO)");
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                    byte[] ntlmsspBlob = ((NegTokenInit)negToken).getMechtoken();
                    SecurityBlob ntlmBlob = new SecurityBlob(SecurityBlob.SecurityBlobType.NTLMSSP, ntlmsspBlob, secBlob.isUnicode());
                    authSts = this.doNtlmsspSessionSetup(sess, client, ntlmBlob, true);
                    SPNEGO.Result spnegoSts = SPNEGO.Result.AcceptCompleted;
                    if (authSts == ISMBAuthenticator.AuthStatus.MORE_PROCESSING) {
                        spnegoSts = SPNEGO.Result.AcceptIncomplete;
                    }
                    negTarg = new NegTokenTarg(spnegoSts, OID.NTLMSSP, ntlmBlob.getResponseBlob());
                    break block23;
                } else if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                    negTarg = this.doKerberosLogon(sess, (NegTokenInit)negToken, client);
                    authSts = ISMBAuthenticator.AuthStatus.AUTHENTICATED;
                    break block23;
                } else {
                    if (this.hasDebugOutput()) {
                        this.debugOutput("[SMB] No matching authentication OID found");
                        this.debugOutput("[SMB]   " + ((NegTokenInit)negToken).toString());
                    }
                    sess.removeAllSetupObjects(client.getProcessId());
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
            }
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Unknown SPNEGO token type=" + tokType);
            }
            sess.removeAllSetupObjects(client.getProcessId());
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        try {
            secBlob.setResponseBlob(negTarg.encode());
            return authSts;
        }
        catch (IOException ex) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Failed to encode NegTokenTarg - " + ex.getMessage());
            }
            sess.removeAllSetupObjects(client.getProcessId());
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final NegTokenTarg doKerberosLogon(SMBSrvSession sess, NegTokenInit negToken, ClientInfo client) throws SMBSrvException {
        NegTokenTarg negTokenTarg;
        block16: {
            KerberosDetails krbDetails = null;
            negTokenTarg = null;
            try {
                PrivilegedAction sessSetupAction = this.getKerberosPrivilegedAction(negToken);
                Object result = Subject.doAs(this.m_loginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    String userName;
                    krbDetails = (KerberosDetails)result;
                    Oid respOid = null;
                    if (negToken.hasOid(OID.MSKERBEROS5)) {
                        respOid = OID.MSKERBEROS5;
                        if (this.hasDebug()) {
                            this.debugOutput("[SMB] Using OID MS Kerberos5 for NegTokenTarg");
                        }
                    } else {
                        respOid = OID.KERBEROS5;
                        if (this.hasDebug()) {
                            this.debugOutput("[SMB] Using OID Kerberos5 for NegTokenTarg");
                        }
                    }
                    negTokenTarg = new NegTokenTarg(SPNEGO.Result.AcceptCompleted, respOid, krbDetails.getResponseToken());
                    if (this.hasDebug()) {
                        this.debugOutput("[SMB] Created NegTokenTarg using standard Krb5 API response");
                    }
                    if ((userName = krbDetails.getUserName()) != null) {
                        if (userName.endsWith("$") && userName.equals(userName.toUpperCase())) {
                            client.setLogonType(ClientInfo.LogonType.Null);
                            if (this.hasDebug()) {
                                this.debugOutput("[SMB] Machine account logon, " + userName + ", as null logon");
                            }
                        } else {
                            client.setUserName(userName);
                            client.setLoggedOnName(krbDetails.getSourceName());
                            client.setGuest(false);
                            sess.setLoggedOn(true);
                        }
                    } else {
                        client.setLogonType(ClientInfo.LogonType.Null);
                    }
                    this.postKerberosLogon(sess, krbDetails, client);
                    sess.setLoggedOn(true);
                    if (this.hasDebug()) {
                        this.debugOutput("[SMB] Logged on using Kerberos, user " + userName);
                    }
                    break block16;
                }
                if (this.hasDebug()) {
                    this.debugOutput("[SMB] No SPNEGO response, Kerberos logon failed");
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    this.debugOutput("[SMB] Kerberos logon error");
                    this.debugOutput(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        }
        return negTokenTarg;
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        ISMBAuthenticator.AuthStatus sts;
        if (!this.acceptNTLMv1Logon()) {
            if (this.hasDebug()) {
                this.debugOutput("[SMB] NTLMv1 not accepted, client " + sess.getRemoteName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.removeSetupObject(client.getProcessId(), SetupObjectType.Type2Message);
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Null logon");
            }
            client.setLogonType(ClientInfo.LogonType.Null);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            sts = this.authenticateUser(client, sess, ISMBAuthenticator.PasswordAlgorithm.NTLM1);
            if (sts.isError()) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                this.debugOutput("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(sts == ISMBAuthenticator.AuthStatus.GUEST_LOGON);
        sess.setLoggedOn(true);
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        ISMBAuthenticator.AuthStatus sts;
        if (!this.acceptNTLMv1Logon()) {
            if (this.hasDebug()) {
                this.debugOutput("[SMB] NTLMv1 not accepted, client " + sess.getRemoteName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        String userName = client.getUserName();
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            sts = this.authenticateUser(client, sess, ISMBAuthenticator.PasswordAlgorithm.NTLM1);
            if (sts.isError()) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebug()) {
                this.debugOutput("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(sts == ISMBAuthenticator.AuthStatus.GUEST_LOGON);
        sess.setLoggedOn(true);
    }

    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject(client.getProcessId(), SetupObjectType.Type2Message);
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Null logon");
            }
            client.setLogonType(ClientInfo.LogonType.Null);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            try {
                byte[] md4Pwd = null;
                if (user.hasMD4Password()) {
                    md4Pwd = user.getMD4Password();
                } else {
                    md4Pwd = this.getEncryptor().generateEncryptedPassword(user.getPassword(), type2Msg.getChallenge(), 3, null, null);
                    user.setMD4Password(md4Pwd);
                }
                byte[] v2hash = this.getEncryptor().doNTLM2Encryption(md4Pwd, type3Msg.getUserName(), type3Msg.getDomain());
                this.debugOutput("[SMB] Generate v2hash user=" + type3Msg.getUserName() + ", domain=" + type3Msg.getDomain() + ", v2hash=" + HexDump.hexString(v2hash));
                NTLMv2Blob v2blob = new NTLMv2Blob(type3Msg.getNTLMHash());
                byte[] srvChallenge = type2Msg.getChallenge();
                this.debugOutput("[SMB] v2blob= len=" + v2blob.getLength() + ",data=" + HexDump.hexString(v2blob.getBuffer(), 16, "") + "..., challenge=" + HexDump.hexString(srvChallenge));
                byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
                byte[] clientHmac = v2blob.getHMAC();
                if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                    int i;
                    for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                    }
                    if (i != clientHmac.length) {
                        this.debugOutput("[SMB] HMac does not match, client=" + HexDump.hexString(clientHmac) + ", server=" + HexDump.hexString(srvHmac));
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                if (NTLM.hasFlag(type3Msg.getFlags(), 0x40000000)) {
                    this.debugOutput("[SMB] Type3 session key=" + HexDump.hexString(type3Msg.getSessionKey()));
                    if (type3Msg.hasSessionKey()) {
                        this.generateSessionKeys(sess, type3Msg, v2hash, srvHmac, clientHmac);
                    } else {
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                client.setUserName(userName);
                client.setGuest(false);
                sess.setLoggedOn(true);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    this.debugOutput(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (client.getUserName().length() == 0) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Null logon");
            }
            client.setLogonType(ClientInfo.LogonType.Null);
            return;
        }
        UserAccount user = this.getUserDetails(client.getUserName());
        if (user != null) {
            try {
                byte[] srvChallenge = null;
                if (sess.hasAuthenticationContext()) {
                    NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                    srvChallenge = ntlmCtx.getChallenge();
                }
                byte[] md4Pwd = null;
                if (user.hasMD4Password()) {
                    md4Pwd = user.getMD4Password();
                } else {
                    md4Pwd = this.getEncryptor().generateEncryptedPassword(user.getPassword(), srvChallenge, 3, null, null);
                    user.setMD4Password(md4Pwd);
                }
                NTLMv2Blob v2blob = new NTLMv2Blob(client.getPassword());
                byte[] v2hash = this.getEncryptor().doNTLM2Encryption(md4Pwd, client.getUserName(), client.getDomain());
                byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
                byte[] clientHmac = v2blob.getHMAC();
                if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length && !Arrays.equals(clientHmac, srvHmac)) {
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
                client.setGuest(false);
                sess.setLoggedOn(true);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    this.debugOutput(ex);
                }
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] User does not exist, " + client.getUserName());
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
    }

    private final void doNTLMv2SessionKeyLogon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.removeSetupObject(client.getProcessId(), SetupObjectType.Type2Message);
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Null logon");
            }
            client.setLogonType(ClientInfo.LogonType.Null);
            return;
        }
        UserAccount user = this.getUserDetails(userName);
        if (user != null) {
            byte[] localHash;
            block16: {
                byte[] nonce = new byte[16];
                System.arraycopy(type2Msg.getChallenge(), 0, nonce, 0, 8);
                System.arraycopy(type3Msg.getLMHash(), 0, nonce, 8, 8);
                MessageDigest md5 = null;
                byte[] v2challenge = new byte[8];
                try {
                    md5 = MessageDigest.getInstance("MD5");
                    md5.update(nonce);
                    byte[] md5nonce = md5.digest();
                    System.arraycopy(md5nonce, 0, v2challenge, 0, 8);
                }
                catch (NoSuchAlgorithmException ex) {
                    if (this.hasDebug()) {
                        this.debugOutput(ex);
                    }
                    throw new SMBSrvException(-1073741715, 1, 5);
                }
                byte[] p21 = new byte[21];
                byte[] md4byts = null;
                if (user.hasMD4Password()) {
                    md4byts = user.getMD4Password();
                } else {
                    try {
                        md4byts = this.getEncryptor().generateEncryptedPassword(user.getPassword(), null, 3, null, null);
                    }
                    catch (Exception ex) {
                        if (this.hasDebug()) {
                            this.debugOutput(ex);
                        }
                        throw new SMBSrvException(-1073741715, 1, 5);
                    }
                }
                System.arraycopy(md4byts, 0, p21, 0, 16);
                localHash = null;
                try {
                    localHash = this.getEncryptor().doNTLM1Encryption(p21, v2challenge);
                }
                catch (NoSuchAlgorithmException ex) {
                    if (!this.hasDebug()) break block16;
                    this.debugOutput(ex);
                }
            }
            byte[] clientHash = type3Msg.getNTLMHash();
            if (clientHash != null && localHash != null && clientHash.length == localHash.length && !Arrays.equals(clientHash, localHash)) {
                throw new SMBSrvException(-1073741715, 1, 5);
            }
        } else {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] User does not exist, " + userName);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        client.setUserName(userName);
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    private final void doHashedPasswordLogon(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        VirtualCircuit vc;
        int uid;
        SMBV1Parser parser = (SMBV1Parser)reqPkt.getParser();
        if (!parser.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        int maxBufSize = parser.getParameter(2);
        int maxMpx = parser.getParameter(3);
        int vcNum = parser.getParameter(4);
        int ascPwdLen = parser.getParameter(7);
        int uniPwdLen = parser.getParameter(8);
        int capabs = parser.getParameterLong(11);
        byte[] buf = parser.getBuffer();
        boolean isUni = parser.isUnicode();
        byte[] ascPwd = parser.unpackBytes(ascPwdLen);
        byte[] uniPwd = parser.unpackBytes(uniPwdLen);
        String user = parser.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String domain = "";
        if (parser.hasMoreData() && (domain = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        String clientOS = "";
        if (parser.hasMoreData() && (clientOS = parser.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 2, 1);
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
            this.debugOutput("[SMB] NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext());
            this.debugOutput("[SMB]   MID=" + parser.getMultiplexId() + ", UID=" + parser.getUserId() + ", PID=" + parser.getProcessId());
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = ClientInfo.getFactory().createInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0) {
            client.setLogonType(ClientInfo.LogonType.Null);
        }
        boolean isGuest = false;
        if (uniPwd != null) {
            if (uniPwd.length == 24) {
                this.doNTLMv1Logon(sess, client);
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Logged on using Hashed/NTLMv1");
                }
            } else if (uniPwd.length > 0) {
                this.doNTLMv2Logon(sess, client);
                if (this.hasDebugOutput()) {
                    this.debugOutput("[SMB] Logged on using Hashed/NTLMv2");
                }
            }
        } else {
            client.setLogonType(ClientInfo.LogonType.Null);
        }
        if (client.isGuest()) {
            isGuest = true;
            if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
                this.debugOutput("[SMB] User " + user + ", logged on as guest");
            }
        }
        if ((uid = sess.addVirtualCircuit(vc = new VirtualCircuit(vcNum, client))) == -1) {
            if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
                this.debugOutput("[SMB] Failed to allocate UID for virtual circuit, " + vc);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (sess.hasDebug(SMBSrvSession.Dbg.NEGOTIATE)) {
            this.debugOutput("[SMB] Allocated UID=" + uid + " for VC=" + vc);
        }
        if (isGuest) {
            client.setLogonType(ClientInfo.LogonType.Guest);
        }
        sess.setLoggedOn(true);
        this.onSuccessfulLogon(client);
        parser.setParameterCount(3);
        parser.setParameter(0, 0);
        parser.setParameter(1, 0);
        parser.setParameter(2, isGuest ? 1 : 0);
        parser.setByteCount(0);
        parser.setTreeId(0);
        parser.setUserId(uid);
        int flags = parser.getFlags();
        parser.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        parser.setFlags2(flags2);
        int pos = parser.getByteOffset();
        buf = parser.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Java File Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getSMBServer().getSMBConfiguration().getDomainName(), buf, pos, true, isUni);
        parser.setByteCount(pos - parser.getByteOffset());
    }

    private void generateSessionKeys(SMBSrvSession sess, Type3NTLMMessage type3, byte[] v2hash, byte[] srvHMAC, byte[] clientHMAC) throws Exception {
        if (this.hasDebugOutput()) {
            this.debugOutput("[SMB] Generate session keys, v2hash=" + HexDump.hexString(v2hash));
        }
        Mac hmacMd5 = Mac.getInstance("HMACMD5");
        SecretKeySpec blobKey = new SecretKeySpec(v2hash, "MD5");
        hmacMd5.init(blobKey);
        byte[] sessionBaseKey = hmacMd5.doFinal(clientHMAC);
        if (this.hasDebugOutput()) {
            this.debugOutput("  Session base key=" + HexDump.hexString(sessionBaseKey));
        }
        byte[] encSessKey = type3.getSessionKey();
        if (this.hasDebugOutput()) {
            this.debugOutput("  Random session key=" + HexDump.hexString(encSessKey));
        }
        Cipher rc4 = Cipher.getInstance("RC4");
        rc4.init(2, new SecretKeySpec(sessionBaseKey, "RC4"));
        byte[] randSessKey = rc4.doFinal(encSessKey);
        sess.addSessionKey("SessionKey", randSessKey);
        if (sess.hasDebug(SMBSrvSession.Dbg.SIGNING)) {
            sess.debugPrintln("Set session key=" + HexDump.hexString(randSessKey));
        }
        if (type3.hasFlag(524288)) {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(randSessKey);
            md5.update(NTLM.SERVER_SIGNING_KEY_CONST);
            byte[] srvSigningKey = md5.digest();
            sess.addSessionKey("NTLMServerSigningKey", srvSigningKey);
            md5.reset();
            md5.update(randSessKey);
            md5.update(NTLM.CLIENT_SIGNING_KEY_CONST);
            byte[] clientSigningKey = md5.digest();
            sess.addSessionKey("NTLMClientSigningKey", clientSigningKey);
            md5.reset();
            md5.update(randSessKey);
            md5.update(NTLM.SERVER_SEALING_KEY_CONST);
            byte[] srvSealingKey = md5.digest();
            sess.addSessionKey("NTLMServerSealingKey", srvSealingKey);
            md5.reset();
            md5.update(randSessKey);
            md5.update(NTLM.CLIENT_SEALING_KEY_CONST);
            byte[] clientSealingKey = md5.digest();
            sess.addSessionKey("NTLMClientSealingKey", clientSealingKey);
            Cipher srvRC4 = Cipher.getInstance("RC4");
            SecretKeySpec srvKey = new SecretKeySpec(srvSealingKey, "RC4");
            srvRC4.init(1, srvKey);
            sess.addSessionKey("NTLMServerRC4Context", srvRC4);
            Cipher clientRC4 = Cipher.getInstance("RC4");
            SecretKeySpec clientKey = new SecretKeySpec(clientSealingKey, "RC4");
            clientRC4.init(2, clientKey);
            sess.addSessionKey("NTLMClientRC4Context", clientRC4);
        }
    }

    protected final boolean verifyMIC(SMBSrvSession sess, byte[] buf, int offset, int len, byte[] rxMIC, int pid) {
        if (rxMIC == null || rxMIC.length != 16) {
            return false;
        }
        DataBuffer rxMICBuf = new DataBuffer(rxMIC, 0, rxMIC.length);
        if (rxMICBuf.getInt() != 1) {
            return false;
        }
        boolean micSts = false;
        try {
            byte[] clientSigningKey = (byte[])sess.getSessionKey("NTLMClientSigningKey");
            Cipher clientRC4 = (Cipher)sess.getSessionKey("NTLMClientRC4Context");
            SecretKeySpec md5Key = new SecretKeySpec(clientSigningKey, "MD5");
            Mac hmacMD5 = Mac.getInstance("HMACMD5");
            byte[] seqNo = new byte[]{0, 0, 0, 0};
            hmacMD5.init(md5Key);
            hmacMD5.update(rxMICBuf.getBuffer(), 12, 4);
            hmacMD5.update(buf, offset, len);
            byte[] md5Chk = hmacMD5.doFinal();
            byte[] chkSum = clientRC4.update(md5Chk, 0, 8);
            DataBuffer micToken = new DataBuffer(16);
            micToken.putInt(1);
            micToken.appendData(chkSum);
            micToken.putInt(0);
            if (Arrays.equals(rxMIC, micToken.getBuffer())) {
                micSts = true;
            }
            if (!micSts && this.hasDebugOutput()) {
                sess.debugPrintln("Verify MIC, generated MIC token=" + HexDump.hexString(micToken.getBuffer()));
                sess.debugPrintln("             Received MIC token=" + HexDump.hexString(rxMIC));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return micSts;
    }

    protected final byte[] generateMIC(SMBSrvSession sess, byte[] buf, int offset, int len, int seqNo) {
        byte[] srvSigningKey = (byte[])sess.getSessionKey("NTLMServerSigningKey");
        DataBuffer micToken = null;
        try {
            if (srvSigningKey != null) {
                SecretKeySpec key = new SecretKeySpec(srvSigningKey, "MD5");
                Mac hmacMd5 = Mac.getInstance("HMACMD5");
                byte[] seqNoBuf = new byte[4];
                DataPacker.putInt(seqNo, seqNoBuf, 0);
                hmacMd5.init(key);
                hmacMd5.update(seqNoBuf);
                hmacMd5.update(buf, offset, len);
                byte[] chkSum = hmacMd5.doFinal();
                Cipher srvRC4 = (Cipher)sess.getSessionKey("NTLMServerRC4Context");
                chkSum = srvRC4.update(chkSum, 0, 8);
                micToken = new DataBuffer(16);
                micToken.putInt(1);
                micToken.appendData(chkSum, 0, 8);
                micToken.putInt(seqNo);
            } else {
                CRC32 crc32 = new CRC32();
                crc32.update(buf, offset, len);
                micToken = new DataBuffer(16);
                micToken.putInt(1);
                micToken.putZeros(4);
                micToken.putInt((int)(crc32.getValue() & 0xFFFFFFFFFFFFFFFFL));
                micToken.putInt(seqNo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (micToken != null) {
            if (this.hasDebugOutput()) {
                this.debugOutput("[SMB] Generate micToken (" + (srvSigningKey != null ? "key" : "crc") + ")=" + HexDump.hexString(micToken.getBuffer()));
            }
            return micToken.getBuffer();
        }
        return null;
    }

    protected NegTokenInit buildNegTokenInit(String srvName, List<Oid> mechTypes) {
        String mecListMIC = null;
        StringBuilder mic = new StringBuilder();
        mic.append("cifs/");
        mic.append(srvName.toLowerCase());
        mic.append("@");
        mic.append(this.m_krbRealm);
        mecListMIC = mic.toString();
        return new NegTokenInit(mechTypes, mecListMIC);
    }

    protected void onSuccessfulLogon(ClientInfo client) {
    }

    protected String normalizeUserId(String externalUserId) throws SMBSrvException {
        return externalUserId;
    }

    protected PrivilegedAction getKerberosPrivilegedAction(NegTokenInit negToken) {
        return new SessionSetupPrivilegedAction(this.m_accountName, negToken.getMechtoken());
    }

    protected void postKerberosLogon(SMBSrvSession sess, KerberosDetails krbDetails, ClientInfo client) throws SMBSrvException {
    }

    protected void postNTLMLogon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
    }

    public boolean hasDebugOutput() {
        return this.hasDebug();
    }

    public void debugOutput(String dbg) {
        Debug.println(dbg);
    }

    public void debugOutput(Exception ex) {
        StringWriter strWrt = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)strWrt, true));
        StringTokenizer strTok = new StringTokenizer(strWrt.toString(), LineSeperator);
        while (strTok.hasMoreTokens()) {
            this.debugOutput(strTok.nextToken());
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getName());
        str.append(" - ");
        if (this.m_useRawNTLMSSP) {
            str.append("NTLMSSP");
        } else {
            str.append("SPNEGO");
        }
        if (!this.allowNTLMLogon()) {
            str.append(",NoNTLM");
        }
        if (!this.acceptNTLMv1Logon()) {
            str.append(",NoNTLMv1");
        }
        if (this.m_loginContext != null && this.m_krbRealm != null) {
            str.append(",Kerberos=");
            str.append(this.m_krbRealm);
        }
        return str.toString();
    }
}

