/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import org.filesys.server.SrvSession;
import org.filesys.server.auth.AuthContext;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.SecurityBlob;
import org.filesys.server.core.SharedDevice;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public interface ISMBAuthenticator {
    public static final int STANDARD_PASSWORD_LEN = 24;
    public static final int STANDARD_CHALLENGE_LEN = 8;

    public ShareStatus authenticateShareConnect(ClientInfo var1, SharedDevice var2, String var3, SrvSession var4);

    public AuthStatus authenticateUser(ClientInfo var1, SrvSession var2, PasswordAlgorithm var3);

    public AuthMode getAccessMode();

    public boolean hasExtendedSecurity();

    public int getSecurityMode();

    public void processSessionSetup(SMBSrvSession var1, SMBSrvPacket var2) throws SMBSrvException;

    public AuthStatus processSecurityBlob(SMBSrvSession var1, ClientInfo var2, SecurityBlob var3) throws SMBSrvException;

    public int getEncryptionKeyLength();

    public int getServerCapabilities();

    public void closeAuthenticator();

    public void setCurrentUser(ClientInfo var1);

    public AuthContext getAuthContext(SMBSrvSession var1);

    public boolean usingSPNEGO();

    public byte[] getNegTokenInit();

    public static enum AuthMode {
        SHARE,
        USER;

    }

    public static enum PasswordAlgorithm {
        LANMAN,
        NTLM1,
        NTLM2;

    }

    public static enum ShareStatus {
        NO_ACCESS,
        READ_ONLY,
        WRITEABLE;

    }

    public static enum AuthStatus {
        AUTHENTICATED(0),
        GUEST_LOGON(1),
        MORE_PROCESSING(2),
        DISALLOW(-1),
        BAD_PASSWORD(-2),
        BAD_USER(-3),
        PASSWORD_EXPIRED(-4),
        ACCOUNT_DISABLED(-5),
        UNSUPPORTED(-6);

        private final int authSts;

        private AuthStatus(int sts) {
            this.authSts = sts;
        }

        public final int intValue() {
            return this.authSts;
        }

        public final boolean isError() {
            return this.authSts < 0;
        }
    }
}

