/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth;

import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.SMBAuthenticator;
import org.filesys.server.auth.UserAccount;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.smb.server.SMBSrvSession;

public class LocalAuthenticator
extends SMBAuthenticator {
    public LocalAuthenticator() {
        this.setAccessMode(ISMBAuthenticator.AuthMode.USER);
        this.setExtendedSecurity(false);
    }

    @Override
    public ISMBAuthenticator.ShareStatus authenticateShareConnect(ClientInfo client, SharedDevice share, String pwd, SrvSession sess) {
        if (this.getAccessMode() == ISMBAuthenticator.AuthMode.SHARE) {
            return ISMBAuthenticator.ShareStatus.WRITEABLE;
        }
        if (share.getType() == ShareType.ADMINPIPE) {
            return ISMBAuthenticator.ShareStatus.WRITEABLE;
        }
        UserAccount user = null;
        if (client != null) {
            user = this.getUserDetails(client.getUserName());
        }
        if (user == null) {
            return this.allowGuest() ? ISMBAuthenticator.ShareStatus.WRITEABLE : ISMBAuthenticator.ShareStatus.NO_ACCESS;
        }
        if (!user.hasShare(share.getName())) {
            return ISMBAuthenticator.ShareStatus.NO_ACCESS;
        }
        return ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    @Override
    public ISMBAuthenticator.AuthStatus authenticateUser(ClientInfo client, SrvSession sess, ISMBAuthenticator.PasswordAlgorithm alg) {
        UserAccount userAcc = this.getUserDetails(client.getUserName());
        if (userAcc != null) {
            boolean authSts = false;
            if (client.getPassword() != null) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), alg);
            } else if (client.hasANSIPassword()) {
                authSts = this.validatePassword(userAcc, client, sess.getAuthenticationContext(), ISMBAuthenticator.PasswordAlgorithm.LANMAN);
            }
            return authSts ? ISMBAuthenticator.AuthStatus.AUTHENTICATED : ISMBAuthenticator.AuthStatus.BAD_PASSWORD;
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return ISMBAuthenticator.AuthStatus.AUTHENTICATED;
        }
        return this.allowGuest() ? ISMBAuthenticator.AuthStatus.GUEST_LOGON : ISMBAuthenticator.AuthStatus.DISALLOW;
    }
}

