/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.auth.acl.ACLParseException;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlParser;
import org.filesys.server.auth.acl.DomainAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class DomainAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "domain";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("name");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("Domain name not specified");
        }
        String domainName = val.trim();
        if (domainName.length() == 0) {
            throw new ACLParseException("Domain name not valid");
        }
        return new DomainAccessControl(domainName, this.getType(), access);
    }
}

