/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.core.SharedDevice;

public class GidAccessControl
extends AccessControl {
    private int m_gid;

    public GidAccessControl(String gidStr, int gid, String type, int access) {
        super(gidStr, type, access);
        this.m_gid = gid;
    }

    @Override
    public int allowsAccess(SrvSession sess, SharedDevice share, AccessControlManager mgr) {
        if (!sess.hasClientInformation()) {
            return -1;
        }
        ClientInfo cInfo = sess.getClientInformation();
        if (cInfo.getGid() != -1 && cInfo.getGid() == this.m_gid) {
            return this.getAccess();
        }
        if (cInfo.hasGroupsList()) {
            int[] groups = cInfo.getGroupsList();
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] != this.m_gid) continue;
                return this.getAccess();
            }
        }
        return -1;
    }
}

