/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import org.filesys.server.auth.acl.ACLParseException;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlParser;
import org.filesys.server.auth.acl.GidAccessControl;
import org.springframework.extensions.config.ConfigElement;

public class GidAccessControlParser
extends AccessControlParser {
    @Override
    public String getType() {
        return "gid";
    }

    @Override
    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String val = params.getAttribute("id");
        if (val == null || val.length() == 0) {
            throw new ACLParseException("Group id not specified");
        }
        String groupId = val.trim();
        int gid = -1;
        try {
            gid = Integer.parseInt(groupId);
            if (gid < 0 || gid > 32768) {
                throw new ACLParseException("Invalid group id, out of valid range");
            }
        }
        catch (NumberFormatException ex) {
            throw new ACLParseException("Group id not valid");
        }
        return new GidAccessControl(groupId, gid, this.getType(), access);
    }
}

