/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.acl;

import java.net.InetAddress;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.acl.AccessControl;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.core.SharedDevice;
import org.filesys.util.IPAddress;

public class IpAddressAccessControl
extends AccessControl {
    private String m_subnet;
    private String m_netMask;

    public IpAddressAccessControl(String address, String mask, String type, int access) {
        super(address, type, access);
        this.m_subnet = address;
        this.m_netMask = mask;
        if (this.m_netMask != null) {
            this.setName(this.m_subnet + "/" + this.m_netMask);
        }
    }

    @Override
    public int allowsAccess(SrvSession sess, SharedDevice share, AccessControlManager mgr) {
        InetAddress remoteAddr = sess.getRemoteAddress();
        if (remoteAddr == null) {
            return -1;
        }
        String ipAddr = remoteAddr.getHostAddress();
        int sts = -1;
        if (this.m_netMask == null) {
            if (IPAddress.parseNumericAddress(ipAddr) == IPAddress.parseNumericAddress(this.getName())) {
                sts = this.getAccess();
            }
        } else if (IPAddress.isInSubnet(ipAddr, this.m_subnet, this.m_netMask)) {
            sts = this.getAccess();
        }
        return sts;
    }
}

