/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.asn;

import java.io.IOException;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DERObject;

public class DERApplicationSpecific
extends DERObject {
    private byte[] m_bytes;

    public DERApplicationSpecific() {
    }

    public DERApplicationSpecific(byte[] byts) {
        this.m_bytes = byts;
    }

    public DERApplicationSpecific(int tagId, byte[] byts) {
        this.setTagNo(tagId);
        this.m_bytes = byts;
    }

    public byte[] getValue() {
        return this.m_bytes;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        if ((buf.unpackType() & 0x40) != 0) {
            int len = buf.unpackLength();
            this.m_bytes = (byte[])(len > 0 ? buf.unpackBytes(len) : null);
        } else {
            throw new IOException("Wrong DER type, expected ApplicationSpecific");
        }
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        int tagNo = 0;
        if (this.isTagged()) {
            tagNo = this.getTagNo();
        }
        buf.packByte(96 + (tagNo & 0xFF));
        if (this.m_bytes != null) {
            buf.packLength(this.m_bytes.length);
            buf.packBytes(this.m_bytes, 0, this.m_bytes.length);
        } else {
            buf.packLength(0);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[ApplicationSpecific:");
        str.append(this.m_bytes != null ? this.m_bytes.length : 0);
        str.append("]");
        return str.toString();
    }
}

