/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.asn;

import java.io.IOException;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DERObject;

public class DEREnumerated
extends DERObject {
    private int m_enum;

    public DEREnumerated() {
    }

    public DEREnumerated(int val) {
        this.m_enum = val;
    }

    public final int getValue() {
        return this.m_enum;
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() != 10) {
            throw new IOException("Wrong DER type, expected Enumerated");
        }
        int len = buf.unpackByte();
        this.m_enum = buf.unpackInt(len);
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        buf.packByte(10);
        if (this.m_enum < 256) {
            buf.packLength(1);
            buf.packByte(this.m_enum);
        } else {
            buf.packLength(4);
            buf.packInt(this.m_enum);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Enum:");
        str.append(this.getValue());
        str.append("]");
        return str.toString();
    }
}

