/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.kerberos;

import org.filesys.server.auth.asn.DERGeneralString;
import org.filesys.server.auth.asn.DERInteger;
import org.filesys.server.auth.asn.DERObject;
import org.filesys.server.auth.asn.DERSequence;
import org.filesys.util.StringList;

public class PrincipalName {
    private int m_type;
    private StringList m_names;

    public PrincipalName() {
        this.m_names = new StringList();
    }

    public PrincipalName(int typ, StringList names) {
        this.m_type = typ;
        this.m_names = names;
    }

    public final int getType() {
        return this.m_type;
    }

    public final StringList getNames() {
        return this.m_names;
    }

    public final void parsePrincipalName(DERSequence derSeq) {
        this.m_names = new StringList();
        block4: for (int idx = 0; idx < derSeq.numberOfObjects(); ++idx) {
            DERObject derObj = derSeq.getObjectAt(idx);
            if (derObj == null || !derObj.isTagged()) continue;
            switch (derObj.getTagNo()) {
                case 0: {
                    if (!(derObj instanceof DERInteger)) continue block4;
                    DERInteger derInt = (DERInteger)derObj;
                    this.m_type = (int)derInt.getValue();
                    continue block4;
                }
                case 1: {
                    if (!(derObj instanceof DERSequence)) continue block4;
                    DERSequence derNames = (DERSequence)derObj;
                    for (int namIdx = 0; namIdx < derNames.numberOfObjects(); ++namIdx) {
                        DERGeneralString derStr = (DERGeneralString)derNames.getObjectAt(namIdx);
                        this.m_names.addString(derStr.getValue());
                    }
                    continue block4;
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Typ=");
        str.append(this.getType());
        str.append(",Names=");
        if (this.m_names != null) {
            str.append(this.m_names);
        } else {
            str.append("null");
        }
        str.append("]");
        return str.toString();
    }
}

