/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.passthru;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.filesys.debug.Debug;
import org.filesys.netbios.NetBIOSName;
import org.filesys.netbios.NetBIOSNameList;
import org.filesys.netbios.NetBIOSSession;
import org.filesys.netbios.NetworkSession;
import org.filesys.server.auth.PasswordEncryptor;
import org.filesys.server.auth.passthru.AuthenticateSession;
import org.filesys.server.auth.passthru.SMBPacket;
import org.filesys.server.auth.passthru.TcpipSMBNetworkSession;
import org.filesys.smb.Dialect;
import org.filesys.smb.DialectSelector;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBException;
import org.filesys.util.IPAddress;
import org.filesys.util.StringList;

public final class AuthSessionFactory {
    private static final int BROADCAST_LOOKUP_TIMEOUT = 4000;
    private static DialectSelector m_defDialects;
    private static int m_sessIdx;
    private static String m_localDomain;
    private static String m_localBrowseMaster;
    private static int m_defPktSize;
    private static InetAddress[] m_localAddrList;
    private static PasswordEncryptor m_encryptor;
    private static int m_evalCount;
    private static String m_defUserName;
    private static String m_defPassword;
    private static String m_defDomain;
    private static int m_primaryProto;
    private static int m_secondaryProto;
    private static boolean m_debug;
    private static int m_netbiosPort;
    private static String m_netBIOSScopeId;

    private static final StringList BuildNegotiatePacket(SMBPacket pkt, DialectSelector dlct, int pid) {
        pkt.setCommand(114);
        pkt.setProcessId(pid);
        if (dlct.hasDialect(7)) {
            pkt.setFlags2(32768);
        }
        StringBuffer dia = new StringBuffer();
        StringList dStrs = new StringList();
        for (int d = 0; d < 13; ++d) {
            if (!dlct.hasDialect(d)) continue;
            for (int i = 0; i < Dialect.NumberOfDialects(); ++i) {
                if (Dialect.DialectType(i) != d) continue;
                String curDialect = Dialect.DialectString(i);
                dStrs.addString(curDialect);
                dia.append('\u0002');
                dia.append(curDialect);
                dia.append('\u0000');
            }
        }
        pkt.setBytes(dia.toString().getBytes());
        return dStrs;
    }

    protected static final int DefaultPacketSize() {
        return m_defPktSize;
    }

    public static final void disableDebug() {
        m_debug = false;
    }

    public static final void enableDebug() {
        m_debug = true;
    }

    public static final DialectSelector getDefaultDialects() {
        return m_defDialects;
    }

    public static String getDefaultDomain() {
        return m_defDomain;
    }

    public static String getDefaultPassword() {
        return m_defPassword;
    }

    public static String getDefaultUserName() {
        return m_defUserName;
    }

    public static String getNetBIOSNameScope() {
        return m_netBIOSScopeId;
    }

    public static int getNetBIOSPort() {
        return m_netbiosPort;
    }

    public static final int getPrimaryProtocol() {
        return m_primaryProto;
    }

    public static final int getSecondaryProtocol() {
        return m_secondaryProto;
    }

    private static synchronized int getSessionId() {
        int sessId = m_sessIdx++ + NetBIOSSession.getJVMIndex() * 100;
        return sessId;
    }

    private static synchronized InetAddress[] getLocalTcpipAddresses() {
        if (m_localAddrList == null) {
            try {
                m_localAddrList = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return m_localAddrList;
    }

    public static final boolean hasDebug() {
        return m_debug;
    }

    public static final boolean hasNetBIOSNameScope() {
        return m_netBIOSScopeId != null;
    }

    public static final boolean hasSessionDebug() {
        return AuthenticateSession.hasDebug();
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr, int tmo) throws IOException, UnknownHostException, SMBException {
        return AuthSessionFactory.OpenAuthenticateSession(shr, tmo, null);
    }

    public static AuthenticateSession OpenAuthenticateSession(PCShare shr, int tmo, DialectSelector dia) throws IOException, UnknownHostException, SMBException {
        int pid = AuthSessionFactory.getSessionId();
        StringBuffer nameBuf = new StringBuffer(InetAddress.getLocalHost().getHostName() + "_" + pid);
        String localName = nameBuf.toString();
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** New auth session from " + localName + " to " + shr.toString());
            Debug.println("** os.arch = " + System.getProperty("os.arch") + ", java.version: " + System.getProperty("java.version"));
        }
        NetworkSession netSession = null;
        switch (AuthSessionFactory.getPrimaryProtocol()) {
            case 1: {
                netSession = AuthSessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, tmo);
                break;
            }
            case 2: {
                netSession = AuthSessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, tmo);
            }
        }
        if (netSession == null) {
            switch (AuthSessionFactory.getSecondaryProtocol()) {
                case 1: {
                    netSession = AuthSessionFactory.connectNetBIOSSession(shr.getNodeName(), localName, tmo);
                    break;
                }
                case 2: {
                    netSession = AuthSessionFactory.connectNativeSMBSession(shr.getNodeName(), localName, tmo);
                }
            }
        }
        if (netSession == null) {
            throw new IOException("Failed to connect to host, " + shr.getNodeName());
        }
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** Connected session, protocol : " + netSession.getProtocolName());
        }
        SMBPacket pkt = new SMBPacket();
        DialectSelector selDialect = dia;
        if (selDialect == null) {
            selDialect = new DialectSelector();
            selDialect.copyFrom(m_defDialects);
        }
        StringList diaList = AuthSessionFactory.BuildNegotiatePacket(pkt, selDialect, pid);
        pkt.ExchangeLowLevelSMB(netSession, pkt, true);
        String diaStr = diaList.getStringAt(pkt.getParameter(0));
        int dialectId = Dialect.DialectType(diaStr);
        if (AuthenticateSession.hasDebug()) {
            Debug.println("** SessionFactory: Negotiated SMB dialect " + diaStr);
        }
        if (dialectId == -1) {
            throw new IOException("Unknown SMB dialect");
        }
        AuthenticateSession authSess = new AuthenticateSession(shr, netSession, dialectId, pkt);
        return authSess;
    }

    public static void setDefaultDomain(String domain) {
        m_defDomain = domain;
    }

    public static void setDefaultPassword(String pwd) {
        m_defPassword = pwd;
    }

    public static void setDefaultUserName(String user) {
        m_defUserName = user;
    }

    public static void setNetBIOSPort(int port) {
        m_netbiosPort = port;
    }

    public static void setNetBIOSNameScope(String scope) {
        m_netBIOSScopeId = scope != null && scope.startsWith(".") ? scope.substring(1) : scope;
    }

    public static final boolean setProtocolOrder(int pri, int sec) {
        if (pri != 1 && pri != 2) {
            return false;
        }
        if (pri == sec) {
            return false;
        }
        m_primaryProto = pri;
        m_secondaryProto = sec;
        return true;
    }

    public static final void setSessionDebug(boolean dbg) {
        if (dbg) {
            AuthenticateSession.setDebug(1);
        } else {
            AuthenticateSession.setDebug(0);
        }
    }

    public static final void setSubnetMask(String subnet) {
        NetBIOSSession.setDefaultSubnetMask(subnet);
    }

    private static void SetupDefaultDialects() {
        if (m_defDialects == null) {
            m_defDialects = new DialectSelector();
        } else {
            m_defDialects.ClearAll();
        }
        m_defDialects.AddDialect(0);
        m_defDialects.AddDialect(1);
        m_defDialects.AddDialect(2);
        m_defDialects.AddDialect(4);
        m_defDialects.AddDialect(3);
        m_defDialects.AddDialect(5);
        m_defDialects.AddDialect(6);
        m_defDialects.AddDialect(7);
    }

    private static final NetworkSession connectNetBIOSSession(String toName, String fromName, int tmo) throws IOException {
        String ipAddr2;
        InetAddress[] addrList;
        int addrIdx;
        NetBIOSSession nbSession = new NetBIOSSession(tmo, AuthSessionFactory.getNetBIOSPort(), 137);
        String toAddr = null;
        NetBIOSName nbName = null;
        if (IPAddress.isNumericAddress(toName)) {
            try {
                toAddr = toName;
                NetBIOSNameList nameList = NetBIOSSession.FindNamesForAddress(toAddr);
                nbName = nameList.findName(' ', false);
                if (nbName == null) {
                    throw new IOException("Server service not running");
                }
                toName = nbName.getName();
            }
            catch (UnknownHostException ex) {
                return null;
            }
        } else {
            nbName = NetBIOSSession.FindName(toName, ' ', 500);
        }
        if (AuthSessionFactory.hasNetBIOSNameScope()) {
            toName = toName + "." + AuthSessionFactory.getNetBIOSNameScope();
            fromName = fromName + "." + AuthSessionFactory.getNetBIOSNameScope();
        }
        if (nbName.numberOfAddresses() > 1 && (addrIdx = nbName.findBestMatchAddress(addrList = AuthSessionFactory.getLocalTcpipAddresses())) != -1) {
            try {
                ipAddr2 = nbName.getIPAddressString(addrIdx);
                if (AuthSessionFactory.hasSessionDebug()) {
                    Debug.println("** Server is multi-homed, trying to connect to " + ipAddr2);
                }
                nbSession.Open(toName, fromName, ipAddr2);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception exception) {}
                } else if (AuthSessionFactory.hasSessionDebug() && nbSession.isConnected()) {
                    Debug.println("** Connected to address " + ipAddr2);
                }
            }
            catch (IOException ipAddr2) {
                // empty catch block
            }
        }
        if (AuthSessionFactory.hasSessionDebug() && !nbSession.isConnected() && nbName.numberOfAddresses() > 1) {
            Debug.println("** Server is multi-homed, trying all addresses");
        }
        IOException lastException = null;
        addrIdx = 0;
        while (!nbSession.isConnected() && addrIdx < nbName.numberOfAddresses()) {
            try {
                ipAddr2 = nbName.getIPAddressString(addrIdx++);
                if (AuthSessionFactory.hasSessionDebug()) {
                    Debug.println("** Trying address " + ipAddr2);
                }
                nbSession.Open(toName, fromName, ipAddr2);
                if (!nbSession.isConnected()) {
                    try {
                        nbSession.Close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!AuthSessionFactory.hasSessionDebug() || !nbSession.isConnected()) continue;
                Debug.println("** Connected to address " + ipAddr2);
            }
            catch (IOException ex) {
                lastException = ex;
            }
        }
        if (!nbSession.isConnected()) {
            if (lastException != null) {
                throw lastException;
            }
            return null;
        }
        return nbSession;
    }

    private static final NetworkSession connectNativeSMBSession(String toName, String fromName, int tmo) throws IOException {
        TcpipSMBNetworkSession tcpSession;
        block6: {
            tcpSession = new TcpipSMBNetworkSession(tmo);
            try {
                tcpSession.Open(toName, fromName, null);
                if (tcpSession.isConnected()) break block6;
                try {
                    tcpSession.Close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception ex) {
                try {
                    tcpSession.Close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tcpSession = null;
            }
        }
        return tcpSession;
    }

    static {
        m_sessIdx = 1;
        m_localDomain = null;
        m_localBrowseMaster = null;
        m_defPktSize = 4100;
        m_encryptor = new PasswordEncryptor();
        m_evalCount = -1;
        m_defDialects = new DialectSelector();
        m_defDialects.AddDialect(0);
        m_defDialects.AddDialect(1);
        m_defDialects.AddDialect(2);
        m_defDialects.AddDialect(4);
        m_defDialects.AddDialect(3);
        m_defDialects.AddDialect(5);
        m_defDialects.AddDialect(6);
        m_defDialects.AddDialect(7);
        m_defUserName = "";
        m_defPassword = "";
        m_defDomain = "?";
        m_primaryProto = 1;
        m_secondaryProto = 2;
        m_debug = false;
        m_netbiosPort = 139;
        m_netBIOSScopeId = null;
    }
}

