/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.auth.spnego;

import java.io.IOException;
import org.filesys.server.auth.SecurityBlob;
import org.filesys.server.auth.asn.DERBuffer;
import org.filesys.server.auth.asn.DEREnumerated;
import org.filesys.server.auth.asn.DERObject;
import org.filesys.server.auth.asn.DEROctetString;
import org.filesys.server.auth.asn.DEROid;
import org.filesys.server.auth.asn.DERSequence;
import org.filesys.server.auth.spnego.SPNEGO;
import org.filesys.util.HexDump;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class NegTokenTarg {
    private SPNEGO.Result m_result = SPNEGO.Result.Invalid;
    private Oid m_supportedMech;
    private byte[] m_responseToken;
    private byte[] m_mechListMIC;

    public NegTokenTarg() {
    }

    public NegTokenTarg(SPNEGO.Result result, Oid mech, byte[] response) {
        this.m_result = result;
        this.m_supportedMech = mech;
        this.m_responseToken = response;
    }

    public final SPNEGO.Result getResult() {
        return this.m_result;
    }

    public final Oid getSupportedMech() {
        return this.m_supportedMech;
    }

    public final boolean hasResponseToken() {
        return this.m_responseToken != null;
    }

    public final byte[] getResponseToken() {
        return this.m_responseToken;
    }

    public final boolean hasMechListMIC() {
        return this.m_mechListMIC != null;
    }

    public final byte[] getMechListMIC() {
        return this.m_mechListMIC;
    }

    public final void setMechListMIC(byte[] mic) {
        this.m_mechListMIC = mic;
    }

    public void decode(SecurityBlob secBlob) throws IOException {
        this.decode(secBlob.getSecurityBlob(), secBlob.getSecurityOffset(), secBlob.getSecurityLength());
    }

    public void decode(byte[] buf, int off, int len) throws IOException {
        DERBuffer derBuf = new DERBuffer(buf, off, len);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            if ((derObj = derSeq.getTaggedObject(0)) != null) {
                if (!(derObj instanceof DEREnumerated)) {
                    throw new IOException("Invalid status object");
                }
                DEREnumerated derEnum = (DEREnumerated)derObj;
                this.m_result = SPNEGO.Result.fromInt(derEnum.getValue());
            }
            if ((derObj = derSeq.getTaggedObject(1)) != null) {
                if (!(derObj instanceof DEROid)) {
                    throw new IOException("Invalid supportedMech object");
                }
                DEROid derMech = (DEROid)derObj;
                try {
                    this.m_supportedMech = new Oid(derMech.getOid());
                }
                catch (GSSException ex) {
                    throw new IOException("Bad supportedMech OID");
                }
            } else {
                this.m_supportedMech = null;
            }
            if ((derObj = derSeq.getTaggedObject(2)) != null) {
                if (!(derObj instanceof DEROctetString)) {
                    throw new IOException("Invalid responseToken object");
                }
                DEROctetString derResp = (DEROctetString)derObj;
                this.m_responseToken = derResp.getValue();
            } else {
                this.m_responseToken = null;
            }
            derObj = derSeq.getTaggedObject(3);
            if (derObj != null) {
                if (!(derObj instanceof DEROctetString)) {
                    throw new IOException("Invalid mecListMIC object");
                }
                DEROctetString derMec = (DEROctetString)derObj;
                this.m_mechListMIC = derMec.getValue();
            }
        } else {
            throw new IOException("Bad format in security blob");
        }
    }

    public byte[] encode() throws IOException {
        DERSequence derSeq = new DERSequence();
        derSeq.setTagNo(1);
        DEREnumerated derEnum = new DEREnumerated(this.m_result.intValue());
        derEnum.setTagNo(0);
        derSeq.addObject(derEnum);
        if (this.m_supportedMech != null) {
            DEROid derOid = new DEROid(this.m_supportedMech.toString());
            derOid.setTagNo(1);
            derSeq.addObject(derOid);
        }
        if (this.m_responseToken != null) {
            DEROctetString derResp = new DEROctetString(this.m_responseToken);
            derResp.setTagNo(2);
            derSeq.addObject(derResp);
        }
        if (this.m_mechListMIC != null) {
            DEROctetString derMIC = new DEROctetString(this.m_mechListMIC);
            derMIC.setTagNo(3);
            derSeq.addObject(derMIC);
        }
        DERBuffer derBuf = new DERBuffer();
        derBuf.packObject(derSeq);
        return derBuf.getBytes();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[NegtokenTarg result=");
        str.append(this.getResult().name());
        str.append(" oid=");
        str.append(this.getSupportedMech());
        str.append(" response=");
        if (this.hasResponseToken()) {
            str.append(this.getResponseToken().length);
            str.append(" bytes");
        } else {
            str.append("null");
        }
        str.append(", mechListMIC=");
        if (this.hasMechListMIC()) {
            str.append(HexDump.hexString(this.getMechListMIC()));
        } else {
            str.append("null");
        }
        str.append("]");
        return str.toString();
    }
}

