/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.config;

import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;

public class ConfigSection {
    private String m_name;
    private ServerConfiguration m_config;
    private boolean m_updated;

    protected ConfigSection(String name, ServerConfiguration config) {
        this.m_name = name;
        this.m_config = config;
        if (this.m_config != null) {
            this.m_config.addConfigSection(this);
        }
    }

    public String getSectionName() {
        return this.m_name;
    }

    public final boolean isUpdated() {
        return this.m_updated;
    }

    protected final ServerConfiguration getServerConfiguration() {
        return this.m_config;
    }

    protected final int fireConfigurationChange(int id, Object newVal) throws InvalidConfigurationException {
        int sts = -1;
        if (this.m_config != null) {
            sts = this.m_config.fireConfigurationChange(id, newVal);
        }
        if (sts >= 1) {
            this.setUpdated(true);
        }
        return sts;
    }

    protected final void setUpdated(boolean upd) {
        this.m_updated = upd;
    }

    public void closeConfig() {
    }
}

