/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.config;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.filesys.server.auth.DefaultUsersInterface;
import org.filesys.server.auth.UserAccountList;
import org.filesys.server.auth.UsersInterface;
import org.filesys.server.auth.acl.AccessControlList;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.auth.passthru.DomainMapping;
import org.filesys.server.config.ConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.ShareMapper;
import org.filesys.server.filesys.DefaultShareMapper;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;

public class SecurityConfigSection
extends ConfigSection {
    public static final String SectionName = "Security";
    private ShareMapper m_shareMapper;
    private ConfigElement m_mapperParams;
    private AccessControlManager m_aclManager;
    private ConfigElement m_aclParams;
    private AccessControlList m_globalACLs;
    private UserAccountList m_userList;
    private UsersInterface m_usersInterface = new DefaultUsersInterface();
    private String m_jceProviderClass;
    private List<DomainMapping> m_domainMappings;

    public SecurityConfigSection(ServerConfiguration config) {
        super(SectionName, config);
        try {
            this.m_usersInterface.initializeUsers(config, null);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
        this.m_shareMapper = new DefaultShareMapper();
        try {
            this.m_shareMapper.initializeMapper(config, (ConfigElement)new GenericConfigElement("shareMapper"));
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    public final boolean hasAccessControlManager() {
        return this.m_aclManager != null;
    }

    public final AccessControlManager getAccessControlManager() {
        return this.m_aclManager;
    }

    public final boolean hasGlobalAccessControls() {
        return this.m_globalACLs != null;
    }

    public final AccessControlList getGlobalAccessControls() {
        return this.m_globalACLs;
    }

    public final ConfigElement getAccessControlManagerParameters() {
        return this.m_aclParams;
    }

    public final ShareMapper getShareMapper() {
        return this.m_shareMapper;
    }

    public final ConfigElement getShareMapperParameters() {
        return this.m_mapperParams;
    }

    public final UserAccountList getUserAccounts() {
        return this.m_userList;
    }

    public final UsersInterface getUsersInterface() {
        return this.m_usersInterface;
    }

    public final String getJCEProvider() {
        return this.m_jceProviderClass;
    }

    public final boolean hasUserAccounts() {
        return this.m_userList != null && this.m_userList.numberOfUsers() > 0;
    }

    public final boolean hasDomainMappings() {
        return this.m_domainMappings != null;
    }

    public final List<DomainMapping> getDomainMappings() {
        return this.m_domainMappings;
    }

    public final int setAccessControlManager(String aclMgrClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        AccessControlManager aclMgr = null;
        try {
            Object aclObj = Class.forName(aclMgrClass).newInstance();
            if (!(aclObj instanceof AccessControlManager)) {
                throw new InvalidConfigurationException("Access control manager does not implement required interface");
            }
            aclMgr = (AccessControlManager)aclObj;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Access control manager class " + aclMgrClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Access control manager class error");
        }
        aclMgr.initialize(this.getServerConfiguration(), params);
        sts = this.setAccessControlManager(aclMgr);
        this.m_aclParams = params;
        return sts;
    }

    public final int setAccessControlManager(AccessControlManager aclMgr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(458754, aclMgr);
        this.m_aclManager = aclMgr;
        return sts;
    }

    public final int setJCEProvider(String providerClass) throws InvalidConfigurationException {
        int sts = 0;
        try {
            Object jceObj = Class.forName(providerClass).newInstance();
            if (!(jceObj instanceof Provider)) {
                throw new InvalidConfigurationException("JCE provider class is not a valid Provider class");
            }
            Provider jceProvider = (Provider)jceObj;
            sts = this.fireConfigurationChange(458756, jceProvider);
            this.m_jceProviderClass = providerClass;
            Security.addProvider(jceProvider);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("JCE provider class " + providerClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("JCE provider class error");
        }
        return sts;
    }

    public final int setShareMapper(String mapperClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        try {
            Object mapperObj = Class.forName(mapperClass).newInstance();
            if (!(mapperObj instanceof ShareMapper)) {
                throw new InvalidConfigurationException("Share mapper class is not implementation of ShareMapper interface");
            }
            ShareMapper shareMapper = (ShareMapper)mapperObj;
            shareMapper.initializeMapper(this.getServerConfiguration(), params);
            sts = this.setShareMapper(shareMapper);
            this.m_mapperParams = params;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Share mapper class " + mapperClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Share mapper class error");
        }
        return sts;
    }

    public final int setShareMapper(ShareMapper shareMapper) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(393218, shareMapper);
        this.m_shareMapper = shareMapper;
        return sts;
    }

    public final int setUserAccounts(UserAccountList users) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(524289, users);
        this.m_userList = users;
        return sts;
    }

    public final int setUsersInterface(String usersClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        UsersInterface usersIface = null;
        try {
            Object usersObj = Class.forName(usersClass).newInstance();
            if (!(usersObj instanceof UsersInterface)) {
                throw new InvalidConfigurationException("Users interface class does not implement required interface");
            }
            usersIface = (UsersInterface)usersObj;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Users interface class " + usersClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Users interface class error");
        }
        usersIface.initializeUsers(this.getServerConfiguration(), params);
        sts = this.fireConfigurationChange(458757, usersIface);
        this.m_usersInterface = usersIface;
        return sts;
    }

    public final int setUsersInterface(UsersInterface usersIface) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(458757, usersIface);
        this.m_usersInterface = usersIface;
        return sts;
    }

    public final int setGlobalAccessControls(AccessControlList acls) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(458755, acls);
        this.m_globalACLs = acls;
        return sts;
    }

    public final void addDomainMapping(DomainMapping mapping) {
        if (this.m_domainMappings == null) {
            this.m_domainMappings = new ArrayList<DomainMapping>();
        }
        this.m_domainMappings.add(mapping);
    }
}

