/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.core;

public enum ShareType {
    DISK(0),
    PRINTER(1),
    NAMEDPIPE(2),
    ADMINPIPE(3),
    UNKNOWN(-1);

    private final int shareType;

    private ShareType(int typ) {
        this.shareType = typ;
    }

    public final int intValue() {
        return this.shareType;
    }

    public static final int asShareInfoType(ShareType typ) {
        int shrTyp = 0;
        switch (typ) {
            case DISK: {
                shrTyp = 0;
                break;
            }
            case PRINTER: {
                shrTyp = 1;
                break;
            }
            case NAMEDPIPE: 
            case ADMINPIPE: {
                shrTyp = 3;
            }
        }
        return shrTyp;
    }

    public static final ShareType ServiceAsType(String srvName) {
        if (srvName.compareTo("A:") == 0) {
            return DISK;
        }
        if (srvName.compareTo("LPT1:") == 0) {
            return PRINTER;
        }
        if (srvName.compareTo("IPC") == 0) {
            return NAMEDPIPE;
        }
        return UNKNOWN;
    }

    public static final String TypeAsService(ShareType typ) {
        if (typ == DISK) {
            return "A:";
        }
        if (typ == PRINTER) {
            return "LPT1:";
        }
        if (typ == NAMEDPIPE || typ == ADMINPIPE) {
            return "IPC";
        }
        return "";
    }

    public static final String TypeAsString(ShareType typ) {
        if (typ == DISK) {
            return "DISK";
        }
        if (typ == PRINTER) {
            return "PRINT";
        }
        if (typ == NAMEDPIPE) {
            return "PIPE";
        }
        if (typ == ADMINPIPE) {
            return "IPC$";
        }
        return "<Unknown>";
    }
}

