/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.Iterator;
import org.filesys.server.SrvSession;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NetworkFileServer;
import org.filesys.server.filesys.OpenFileMap;
import org.filesys.server.filesys.TooManyFilesException;

public class ArrayOpenFileMap
extends OpenFileMap {
    private NetworkFile[] m_files;
    private int m_fileCount;

    @Override
    public int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        NetworkFileServer fileSrv;
        int idx;
        if (this.m_files == null) {
            this.m_files = new NetworkFile[32];
        }
        for (idx = 0; idx < this.m_files.length && this.m_files[idx] != null; ++idx) {
        }
        if (idx == this.m_files.length) {
            if (this.m_files.length >= 8192) {
                throw new TooManyFilesException();
            }
            NetworkFile[] newFiles = new NetworkFile[this.m_files.length * 2];
            System.arraycopy(this.m_files, 0, newFiles, 0, this.m_files.length);
            this.m_files = newFiles;
        }
        if ((fileSrv = (NetworkFileServer)sess.getServer()) != null) {
            fileSrv.fireOpenFileEvent(sess, file);
        }
        this.m_files[idx] = file;
        ++this.m_fileCount;
        file.setProtocolId(idx);
        return idx;
    }

    @Override
    public NetworkFile findFile(int fid) {
        if (this.m_files == null || fid >= this.m_files.length || fid < 0) {
            return null;
        }
        return this.m_files[fid];
    }

    @Override
    public Iterator<Integer> iterateFileHandles() {
        return new ArrayOpenFileMapIterator();
    }

    @Override
    public int openFileCount() {
        return this.m_fileCount;
    }

    @Override
    public void removeAllFiles() {
        if (this.m_files == null) {
            return;
        }
        int idx = 0;
        while (idx < this.m_files.length) {
            this.m_files[idx++] = null;
        }
        this.m_fileCount = 0;
    }

    @Override
    public NetworkFile removeFile(int idx, SrvSession sess) {
        if (this.m_files == null || idx >= this.m_files.length) {
            return null;
        }
        NetworkFile netFile = this.m_files[idx];
        if (netFile != null) {
            netFile.setProtocolId(-1);
        }
        this.m_files[idx] = null;
        --this.m_fileCount;
        return netFile;
    }

    public class ArrayOpenFileMapIterator
    implements Iterator<Integer> {
        private int m_nextId;

        ArrayOpenFileMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (ArrayOpenFileMap.this.m_files[this.m_nextId] == null && this.m_nextId < ArrayOpenFileMap.this.m_files.length) {
                ++this.m_nextId;
            }
            return this.m_nextId < ArrayOpenFileMap.this.m_files.length;
        }

        @Override
        public Integer next() {
            while (ArrayOpenFileMap.this.m_files[this.m_nextId] == null && this.m_nextId < ArrayOpenFileMap.this.m_files.length) {
                ++this.m_nextId;
            }
            if (this.m_nextId < ArrayOpenFileMap.this.m_files.length) {
                return new Integer(this.m_nextId++);
            }
            return null;
        }
    }
}

