/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.HashMap;
import java.util.Iterator;
import org.filesys.server.SrvSession;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.OpenFileMap;
import org.filesys.server.filesys.TooManyFilesException;

public class HashedOpenFileMap
extends OpenFileMap {
    public static final int MAX_FILE_ID_HANDLE = 0x1FFFFFFF;
    private HashMap<Integer, NetworkFile> m_files = new HashMap(32);
    private int m_nextFileId = 1;

    @Override
    public int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        while (this.m_files.get(this.m_nextFileId) != null) {
            ++this.m_nextFileId;
            if (this.m_nextFileId < 0x1FFFFFFF) continue;
            this.m_nextFileId = 1;
        }
        this.m_files.put(this.m_nextFileId, file);
        return this.m_nextFileId++;
    }

    @Override
    public NetworkFile findFile(int fid) {
        return this.m_files.get(fid);
    }

    @Override
    public Iterator<Integer> iterateFileHandles() {
        return this.m_files.keySet().iterator();
    }

    @Override
    public int openFileCount() {
        return this.m_files.size();
    }

    @Override
    public void removeAllFiles() {
        this.m_files.clear();
    }

    @Override
    public NetworkFile removeFile(int fid, SrvSession sess) {
        return this.m_files.remove(fid);
    }
}

