/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.ArrayList;
import java.util.List;
import org.filesys.server.NetworkServer;
import org.filesys.server.SrvSession;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.filesys.FileListener;
import org.filesys.server.filesys.FilesystemsConfigSection;
import org.filesys.server.filesys.NetworkFile;

public abstract class NetworkFileServer
extends NetworkServer {
    private List<FileListener> m_fileListeners;
    private FilesystemsConfigSection m_filesysConfig;
    private long m_startupTime;

    public NetworkFileServer(String proto, ServerConfiguration config) {
        super(proto, config);
        this.m_filesysConfig = (FilesystemsConfigSection)config.getConfigSection("Filesystems");
        this.m_startupTime = System.currentTimeMillis();
    }

    public final long getStartupTime() {
        return this.m_startupTime;
    }

    protected final void setStartupTime(long startTime) {
        this.m_startupTime = startTime;
    }

    public final FilesystemsConfigSection getFilesystemConfiguration() {
        return this.m_filesysConfig;
    }

    public final void addFileListener(FileListener l) {
        if (this.m_fileListeners == null) {
            this.m_fileListeners = new ArrayList<FileListener>();
        }
        this.m_fileListeners.add(l);
    }

    public final void removeFileListener(FileListener l) {
        if (this.m_fileListeners == null) {
            return;
        }
        this.m_fileListeners.remove(l);
    }

    public final void fireCloseFileEvent(SrvSession sess, NetworkFile file) {
        if (this.m_fileListeners == null || this.m_fileListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_fileListeners.size(); ++i) {
            FileListener fileListener = this.m_fileListeners.get(i);
            try {
                fileListener.fileClosed(sess, file);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void fireOpenFileEvent(SrvSession sess, NetworkFile file) {
        if (this.m_fileListeners == null || this.m_fileListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_fileListeners.size(); ++i) {
            FileListener fileListener = this.m_fileListeners.get(i);
            try {
                fileListener.fileOpened(sess, file);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

