/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.EnumSet;
import java.util.Set;

public enum NotifyChange {
    FileName(1),
    DirectoryName(2),
    Attributes(4),
    Size(8),
    LastWrite(16),
    LastAccess(32),
    Creation(64),
    ExtendedAttr(128),
    Security(256),
    StreamName(512),
    StreamSize(1024),
    StreamWrite(2048);

    private final int changeTyp;

    private NotifyChange(int typ) {
        this.changeTyp = typ;
    }

    public static final Set<NotifyChange> setFromInt(int ival) {
        EnumSet<NotifyChange> changeSet = EnumSet.noneOf(NotifyChange.class);
        block14: for (int mask = 1; mask <= 2048; mask <<= 1) {
            if ((ival & mask) == 0) continue;
            switch (mask) {
                case 1: {
                    changeSet.add(FileName);
                    continue block14;
                }
                case 2: {
                    changeSet.add(DirectoryName);
                    continue block14;
                }
                case 4: {
                    changeSet.add(Attributes);
                    continue block14;
                }
                case 8: {
                    changeSet.add(Size);
                    continue block14;
                }
                case 16: {
                    changeSet.add(LastWrite);
                    continue block14;
                }
                case 32: {
                    changeSet.add(LastAccess);
                    continue block14;
                }
                case 64: {
                    changeSet.add(Creation);
                    continue block14;
                }
                case 128: {
                    changeSet.add(ExtendedAttr);
                    continue block14;
                }
                case 256: {
                    changeSet.add(Security);
                    continue block14;
                }
                case 512: {
                    changeSet.add(StreamName);
                    continue block14;
                }
                case 1024: {
                    changeSet.add(StreamSize);
                    continue block14;
                }
                case 2048: {
                    changeSet.add(StreamWrite);
                }
            }
        }
        return changeSet;
    }
}

