/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SearchMap;
import org.filesys.server.filesys.TooManySearchesException;

public class SequentialSearchMap
extends SearchMap {
    private SearchContext[] m_search;
    private int m_searchCount;

    public SequentialSearchMap() {
    }

    public SequentialSearchMap(int maxSearches) {
        this.setMaximumNumberOfSearches(maxSearches >= 8 ? maxSearches : 8);
    }

    @Override
    public int allocateSearchSlot() throws TooManySearchesException {
        int idx;
        if (this.m_search == null) {
            this.m_search = new SearchContext[8];
        }
        for (idx = 0; idx < this.m_search.length && this.m_search[idx] != null; ++idx) {
        }
        if (idx == this.m_search.length) {
            if (this.m_search.length >= 256) {
                throw new TooManySearchesException();
            }
            SearchContext[] newSearch = new SearchContext[this.m_search.length * 2];
            System.arraycopy(this.m_search, 0, newSearch, 0, this.m_search.length);
            this.m_search = newSearch;
        }
        ++this.m_searchCount;
        this.m_search[idx] = SearchSlotMarker;
        return idx;
    }

    @Override
    public boolean allocateSearchSlotWithId(int searchId) throws TooManySearchesException {
        return false;
    }

    @Override
    public SearchContext deallocateSearchSlot(int ctxId) {
        if (this.m_search == null || ctxId >= this.m_search.length) {
            return null;
        }
        if (this.m_search[ctxId] != null) {
            this.m_search[ctxId].closeSearch();
        }
        --this.m_searchCount;
        SearchContext ctx = this.m_search[ctxId];
        this.m_search[ctxId] = null;
        return ctx;
    }

    @Override
    public SearchContext findSearchContext(int srchId) {
        if (this.m_search == null || srchId >= this.m_search.length) {
            return null;
        }
        return this.m_search[srchId];
    }

    @Override
    public void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search == null || slot > this.m_search.length) {
            return;
        }
        this.m_search[slot] = srch;
    }

    @Override
    public int numberOfSearches() {
        return this.m_searchCount;
    }

    @Override
    public void closeAllSearches() {
        for (int idx = 0; idx < this.m_search.length; ++idx) {
            if (this.m_search[idx] == null) continue;
            this.deallocateSearchSlot(idx);
        }
        this.m_search = null;
        this.m_searchCount = 0;
    }
}

