/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys;

import java.util.Iterator;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.core.DeviceInterface;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.HashedOpenFileMap;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NetworkFileServer;
import org.filesys.server.filesys.OpenFileMap;
import org.filesys.server.filesys.TooManyFilesException;

public class TreeConnection {
    public static final int MAXFILES = 8192;
    public static final int INITIALFILES = 32;
    private SharedDevice m_shareDev;
    private OpenFileMap m_files;
    private ISMBAuthenticator.ShareStatus m_permission;
    private int m_treeId;

    public TreeConnection(SharedDevice shrDev) {
        this.m_shareDev = shrDev;
        this.m_shareDev.incrementConnectionCount();
        this.m_files = new HashedOpenFileMap();
    }

    public TreeConnection(SharedDevice shrDev, int treeId) {
        this.m_shareDev = shrDev;
        this.m_shareDev.incrementConnectionCount();
        this.m_treeId = treeId;
        this.m_files = new HashedOpenFileMap();
    }

    public final int getId() {
        return this.m_treeId;
    }

    public synchronized int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        int handle_id = this.m_files.addFile(file, sess);
        NetworkFileServer fileSrv = (NetworkFileServer)sess.getServer();
        if (fileSrv != null) {
            fileSrv.fireOpenFileEvent(sess, file);
        }
        return handle_id;
    }

    public synchronized void closeConnection(SrvSession sess) {
        if (this.openFileCount() > 0) {
            Iterator<Integer> fileIter = this.m_files.iterateFileHandles();
            while (fileIter.hasNext()) {
                Integer fileHandle = fileIter.next();
                NetworkFile openFile = this.m_files.findFile(fileHandle);
                if (openFile == null) continue;
                try {
                    DiskInterface disk = (DiskInterface)this.m_shareDev.getInterface();
                    openFile.setForce(true);
                    disk.closeFile(sess, this, openFile);
                    openFile.setClosed(true);
                }
                catch (Exception exception) {}
            }
            this.m_files.removeAllFiles();
        }
        this.m_shareDev.decrementConnectionCount();
    }

    public synchronized NetworkFile findFile(int fid) {
        return this.m_files.findFile(fid);
    }

    public final boolean hasContext() {
        if (this.m_shareDev != null) {
            return this.m_shareDev.getContext() != null;
        }
        return false;
    }

    public final DeviceContext getContext() {
        if (this.m_shareDev == null) {
            return null;
        }
        return this.m_shareDev.getContext();
    }

    public final ISMBAuthenticator.ShareStatus getPermission() {
        return this.m_permission;
    }

    public final boolean hasReadAccess() {
        return this.m_permission == ISMBAuthenticator.ShareStatus.READ_ONLY || this.m_permission == ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    public final boolean hasWriteAccess() {
        return this.m_permission == ISMBAuthenticator.ShareStatus.WRITEABLE;
    }

    public final SharedDevice getSharedDevice() {
        return this.m_shareDev;
    }

    public final DeviceInterface getInterface() {
        if (this.m_shareDev == null) {
            return null;
        }
        try {
            return this.m_shareDev.getInterface();
        }
        catch (InvalidDeviceInterfaceException invalidDeviceInterfaceException) {
            return null;
        }
    }

    public synchronized int openFileCount() {
        return this.m_files.openFileCount();
    }

    public final Iterator<Integer> iterateOpenFileHandles() {
        return this.m_files.iterateFileHandles();
    }

    public final synchronized void removeAllFiles() {
        this.m_files.removeAllFiles();
    }

    public synchronized void removeFile(int fid, SrvSession sess) {
        NetworkFileServer fileSrv;
        NetworkFile netFile = this.m_files.removeFile(fid, sess);
        if (netFile != null && (fileSrv = (NetworkFileServer)sess.getServer()) != null) {
            fileSrv.fireCloseFileEvent(sess, netFile);
        }
    }

    public final void setPermission(ISMBAuthenticator.ShareStatus perm) {
        this.m_permission = perm;
    }

    public final void setPermission(int aclPerm) {
        switch (aclPerm) {
            case 0: {
                this.m_permission = ISMBAuthenticator.ShareStatus.NO_ACCESS;
                break;
            }
            case 1: {
                this.m_permission = ISMBAuthenticator.ShareStatus.READ_ONLY;
                break;
            }
            case 2: {
                this.m_permission = ISMBAuthenticator.ShareStatus.WRITEABLE;
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_shareDev.toString());
        str.append(", id=");
        str.append(this.getId());
        str.append(", fileCnt=");
        str.append(this.openFileCount());
        str.append(", perm=");
        str.append(this.m_permission.name());
        str.append("]");
        return str.toString();
    }
}

