/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache;

import java.io.Serializable;
import java.util.HashMap;
import org.filesys.debug.Debug;
import org.filesys.locking.FileLock;
import org.filesys.locking.FileLockList;
import org.filesys.locking.LockConflictException;
import org.filesys.locking.NotLockedException;
import org.filesys.server.filesys.ExistingOpLockException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.pseudo.PseudoFile;
import org.filesys.server.filesys.pseudo.PseudoFileList;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.smb.SharingMode;

public abstract class FileState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long NoTimeout = -1L;
    public static final long DefTimeout = 120000L;
    public static final long RenameTimeout = 60000L;
    public static final long DeleteTimeout = 15000L;
    public static final int UnknownFileId = -1;
    public static final String FileInformation = "FileInfo";
    public static final String StreamsList = "StreamsList";
    private String m_path;
    private long m_tmo;
    private FileStatus m_fileStatus;
    private int m_openCount;
    private SharingMode m_sharedAccess = SharingMode.ALL;
    private int m_pid = -1;
    private FileLockList m_lockList;
    private OpLockDetails m_oplock;
    private long m_retainUntil = -1L;
    private long m_accessDate;
    private long m_modifyDate;
    private long m_changeDate;
    private long m_fileSize = -1L;
    private long m_allocSize;

    public FileState() {
    }

    public FileState(String fname, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = FileStatus.Unknown;
    }

    public FileState(String fname, FileStatus status, boolean caseSensitive) {
        this.setPath(fname, caseSensitive);
        this.setExpiryTime(System.currentTimeMillis() + 120000L);
        this.m_fileStatus = status;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final boolean fileExists() {
        return this.m_fileStatus == FileStatus.FileExists || this.m_fileStatus == FileStatus.DirectoryExists;
    }

    public final FileStatus getFileStatus() {
        return this.m_fileStatus;
    }

    public final boolean isDirectory() {
        return this.m_fileStatus == FileStatus.DirectoryExists;
    }

    public int getOpenCount() {
        return this.m_openCount;
    }

    public abstract int getFileId();

    public final SharingMode getSharedAccess() {
        return this.m_sharedAccess;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public abstract DataStatus getDataStatus();

    public final boolean hasActiveLocks() {
        return this.m_lockList != null && this.m_lockList.numberOfLocks() > 0;
    }

    public final FileLockList getLockList() {
        return this.m_lockList;
    }

    public final boolean isPermanentState() {
        return this.m_tmo == -1L;
    }

    public final boolean hasActiveRetentionPeriod() {
        if (this.m_retainUntil == -1L) {
            return false;
        }
        return System.currentTimeMillis() < this.m_retainUntil;
    }

    public final long getRetentionExpiryDateTime() {
        return this.m_retainUntil;
    }

    public final boolean exists() {
        return this.m_fileStatus == FileStatus.FileExists || this.m_fileStatus == FileStatus.DirectoryExists;
    }

    public final boolean allowsOpen(FileOpenParams params) {
        if (this.getOpenCount() == 0) {
            return true;
        }
        if (this.getSharedAccess() == SharingMode.READ_WRITE && params.getAccessMode() == SharingMode.READ_WRITE.intValue()) {
            return true;
        }
        if (this.getSharedAccess().hasRead() && params.isReadOnlyAccess()) {
            return true;
        }
        return this.getSharedAccess().hasWrite() && params.isWriteOnlyAccess();
    }

    public synchronized int incrementOpenCount() {
        return ++this.m_openCount;
    }

    public synchronized int decrementOpenCount() {
        if (this.m_openCount > 0) {
            --this.m_openCount;
        }
        return this.m_openCount;
    }

    public final boolean hasExpired(long curTime) {
        if (this.m_tmo == -1L) {
            return false;
        }
        return curTime > this.m_tmo;
    }

    public final long getSecondsToExpire(long curTime) {
        if (this.m_tmo == -1L) {
            return -1L;
        }
        return (this.m_tmo - curTime) / 1000L;
    }

    public void setFileStatus(FileStatus status) {
        this.setFileStatus(status, ChangeReason.None);
    }

    public void setFileStatus(FileStatus status, ChangeReason reason) {
        this.m_fileStatus = status;
    }

    public abstract void setFileId(int var1);

    public void setExpiryTime(long expire) {
        this.m_tmo = expire;
    }

    public void setRetentionExpiryDateTime(long expires) {
        this.m_retainUntil = expires;
    }

    public void setSharedAccess(SharingMode mode) {
        if (this.getOpenCount() == 0) {
            this.m_sharedAccess = mode;
        }
    }

    public abstract void setDataStatus(DataStatus var1);

    public final void addAttribute(String name, Object attr) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        if (stateAttrs != null) {
            stateAttrs.put(name, attr);
        }
    }

    public final Object findAttribute(String name) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        Object attrObj = null;
        if (stateAttrs != null) {
            attrObj = stateAttrs.get(name);
        }
        return attrObj;
    }

    public final int numberOfAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            return stateAttrs.size();
        }
        return 0;
    }

    public final Object removeAttribute(String name) {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(true);
        Object attrObj = null;
        if (stateAttrs != null) {
            attrObj = stateAttrs.remove(name);
        }
        return attrObj;
    }

    public final void removeAllAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            stateAttrs.clear();
        }
    }

    protected abstract HashMap<String, Object> getAttributeMap(boolean var1);

    public final void setPath(String path, boolean caseSensitive) {
        this.m_path = FileState.normalizePath(path, caseSensitive);
    }

    public final void setPathInternal(String path) {
        this.m_path = path;
    }

    public void setProcessId(int pid) {
        if (this.getOpenCount() == 0) {
            this.m_pid = pid;
        }
    }

    public final int numberOfLocks() {
        if (this.m_lockList != null) {
            return this.m_lockList.numberOfLocks();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(FileLock lock) throws LockConflictException {
        Serializable serializable;
        if (this.m_lockList == null) {
            serializable = this;
            synchronized (serializable) {
                if (this.m_lockList == null) {
                    this.m_lockList = new FileLockList();
                }
            }
        }
        serializable = this.m_lockList;
        synchronized (serializable) {
            if (!this.m_lockList.allowsLock(lock)) {
                throw new LockConflictException();
            }
            this.m_lockList.addLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(FileLock lock) throws NotLockedException {
        if (this.m_lockList == null) {
            throw new NotLockedException();
        }
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            if (this.m_lockList.removeLock(lock) == null) {
                throw new NotLockedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canReadFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean readOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            readOK = this.m_lockList.canReadFile(offset, len, pid);
        }
        return readOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWriteFile(long offset, long len, int pid) {
        if (this.m_lockList == null) {
            return true;
        }
        boolean writeOK = false;
        FileLockList fileLockList = this.m_lockList;
        synchronized (fileLockList) {
            writeOK = this.m_lockList.canWriteFile(offset, len, pid);
        }
        return writeOK;
    }

    public boolean hasOpLock() {
        return this.m_oplock != null;
    }

    public OpLockDetails getOpLock() {
        return this.m_oplock;
    }

    public synchronized void setOpLock(OpLockDetails oplock) throws ExistingOpLockException {
        if (this.m_oplock != null) {
            throw new ExistingOpLockException();
        }
        this.m_oplock = oplock;
    }

    public synchronized void clearOpLock() {
        this.m_oplock = null;
    }

    public boolean hasPseudoFiles() {
        PseudoFileList pseudoList = this.getPseudoFileList(false);
        if (pseudoList != null) {
            return pseudoList.numberOfFiles() > 0;
        }
        return false;
    }

    public PseudoFileList getPseudoFileList() {
        return this.getPseudoFileList(false);
    }

    protected abstract PseudoFileList getPseudoFileList(boolean var1);

    public final void addPseudoFile(PseudoFile pfile) {
        PseudoFileList pseudoList = this.getPseudoFileList(true);
        if (pseudoList != null) {
            pseudoList.addFile(pfile);
        }
    }

    public final boolean hasAccessDateTime() {
        return this.m_accessDate != 0L;
    }

    public final long getAccessDateTime() {
        return this.m_accessDate;
    }

    public void updateAccessDateTime() {
        this.m_accessDate = System.currentTimeMillis();
    }

    public final boolean hasChangeDateTime() {
        return this.m_changeDate != 0L;
    }

    public final long getChangeDateTime() {
        return this.m_changeDate;
    }

    public void updateChangeDateTime() {
        this.updateChangeDateTime(System.currentTimeMillis());
    }

    public void updateChangeDateTime(long changeTime) {
        this.m_changeDate = changeTime;
    }

    public final boolean hasModifyDateTime() {
        return this.m_modifyDate != 0L;
    }

    public final long getModifyDateTime() {
        return this.m_modifyDate;
    }

    public void updateModifyDateTime() {
        long timeNow = System.currentTimeMillis();
        this.updateModifyDateTime(timeNow);
        this.m_accessDate = timeNow;
    }

    public void updateModifyDateTime(long modTime) {
        this.m_modifyDate = modTime;
    }

    public final boolean hasFilesystemObject() {
        return this.getFilesystemObject() != null;
    }

    public abstract Object getFilesystemObject();

    public abstract void setFilesystemObject(Object var1);

    public abstract boolean isCopyState();

    public final boolean hasFileSize() {
        return this.m_fileSize != -1L;
    }

    public final long getFileSize() {
        return this.m_fileSize;
    }

    public void setFileSize(long fileSize) {
        this.m_fileSize = fileSize;
    }

    public final boolean hasAllocationSize() {
        return this.m_allocSize > 0L;
    }

    public final long getAllocationSize() {
        return this.m_allocSize;
    }

    public void setAllocationSize(long allocSize) {
        this.m_allocSize = allocSize;
    }

    public void setOpenCount(int count) {
        this.m_openCount = count;
    }

    public boolean hasDataUpdateInProgress() {
        return false;
    }

    public static final String normalizePath(String path) {
        return FileState.normalizePath(path, true);
    }

    public static final String normalizePath(String path, boolean caseSensitive) {
        String normPath = path;
        if (caseSensitive) {
            int pos;
            if (path.length() > 3 && (pos = path.lastIndexOf(92)) != -1) {
                String pathPart = FileState.upperCaseAToZ(path.substring(0, pos));
                String namePart = path.substring(pos);
                normPath = pathPart + namePart;
            }
        } else {
            normPath = FileState.upperCaseAToZ(path);
        }
        return normPath;
    }

    protected static final String upperCaseAToZ(String path) {
        StringBuilder pathStr = new StringBuilder(path);
        for (int i = 0; i < pathStr.length(); ++i) {
            char curChar = pathStr.charAt(i);
            if (!Character.isLowerCase(curChar)) continue;
            pathStr.setCharAt(i, Character.toUpperCase(curChar));
        }
        return pathStr.toString();
    }

    public final void DumpAttributes() {
        HashMap<String, Object> stateAttrs = this.getAttributeMap(false);
        if (stateAttrs != null) {
            for (String name : stateAttrs.keySet()) {
                Object attrib = stateAttrs.get(name);
                Debug.println("++    " + name + " : " + attrib);
            }
        } else {
            Debug.println("++    No Attributes");
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getPath());
        str.append(",");
        str.append(this.getFileStatus().name());
        str.append(":Opn=");
        str.append(this.getOpenCount());
        if (this.getOpenCount() > 0) {
            str.append("(shr=");
            str.append(this.getSharedAccess().name());
            str.append(",pid=");
            str.append(this.getProcessId());
            str.append(")");
        }
        str.append(",Fid=");
        str.append(this.getFileId());
        str.append(",Expire=");
        str.append(this.getSecondsToExpire(System.currentTimeMillis()));
        str.append(",Sts=");
        str.append(this.getDataStatus().name());
        str.append(",Locks=");
        str.append(this.numberOfLocks());
        if (this.hasOpLock()) {
            str.append(",OpLock=");
            str.append(this.getOpLock());
        }
        str.append("]");
        return str.toString();
    }

    public static enum ChangeReason {
        None,
        FileCreated,
        FolderCreated,
        FileDeleted,
        FolderDeleted;

    }

    public static enum DataStatus {
        Unknown,
        LoadWait,
        Loading,
        Available,
        Updated,
        SaveWait,
        Saving,
        Saved,
        Deleted,
        Renamed,
        DeleteOnClose;

    }
}

