/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache;

import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileAccessToken;

public class LocalFileAccessToken
implements FileAccessToken {
    private int m_pid;
    private boolean m_attribOnly;
    private transient boolean m_released = false;

    public LocalFileAccessToken(int pid) {
        this.m_pid = pid;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final boolean isReleased() {
        return this.m_released;
    }

    public final void setReleased(boolean released) {
        this.m_released = released;
    }

    public final boolean isAttributesOnly() {
        return this.m_attribOnly;
    }

    public final void setAttributesOnly(boolean attrOnly) {
        this.m_attribOnly = attrOnly;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Token pid=");
        str.append(this.getProcessId());
        if (this.isAttributesOnly()) {
            str.append(",AttribOnly");
        }
        if (this.isReleased()) {
            str.append(",Released");
        }
        str.append("]");
        return str.toString();
    }

    public void finalize() {
        if (!this.isReleased()) {
            Debug.println("** Access token finalized, not released, " + this.toString() + " **");
        }
    }
}

