/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.filesys.debug.Debug;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateCache;
import org.filesys.server.filesys.cache.LocalFileState;
import org.filesys.server.locking.OpLockDetails;
import org.springframework.extensions.config.ConfigElement;

public class StandaloneFileStateCache
extends FileStateCache {
    private static final int InitialCacheSize = 500;
    private static final int MinimumCacheSize = 100;
    private Map<String, FileState> m_stateCache;

    @Override
    public void initializeCache(ConfigElement config, ServerConfiguration srvConfig) throws InvalidConfigurationException {
        super.initializeCache(config, srvConfig);
        int initSize = 500;
        ConfigElement elem = config.getChild("initialSize");
        if (elem != null && elem.getValue() != null) {
            try {
                initSize = Integer.parseInt(elem.getValue());
                if (initSize < 100) {
                    throw new InvalidConfigurationException("Initial cache size value too low, " + initSize);
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid initial cache size value, " + elem.getValue());
            }
        }
        this.m_stateCache = new HashMap<String, FileState>(initSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int numberOfStates() {
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            return this.m_stateCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FileState findFileState(String path) {
        FileState fState = null;
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            fState = this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
        }
        return fState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FileState findFileState(String path, boolean create) {
        FileState state = null;
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            state = this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
            if (state == null && create) {
                state = new LocalFileState(path, this.isCaseSensitive());
                state.setExpiryTime(System.currentTimeMillis() + this.getFileStateExpireInterval());
                this.m_stateCache.put(state.getPath(), state);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FileState findFileState(String path, boolean create, FileStatus status) {
        FileState state = null;
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            state = this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
            if (state == null && create) {
                state = new LocalFileState(path, this.isCaseSensitive());
                state.setExpiryTime(System.currentTimeMillis() + this.getFileStateExpireInterval());
                state.setFileStatus(status);
                this.m_stateCache.put(state.getPath(), state);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final FileState removeFileState(String path) {
        FileState state = null;
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            state = this.m_stateCache.remove(FileState.normalizePath(path, this.isCaseSensitive()));
        }
        if (this.hasStateListener() && state != null) {
            this.getStateListener().fileStateClosed(state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void renameFileState(String newPath, FileState state, boolean isDir) {
        String oldPath = state.getPath();
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            this.m_stateCache.remove(state.getPath());
            state.setPath(newPath, this.isCaseSensitive());
            state.setFileStatus(isDir ? FileStatus.DirectoryExists : FileStatus.FileExists);
            this.m_stateCache.put(state.getPath(), state);
            if (isDir) {
                if (!oldPath.endsWith("\\")) {
                    oldPath = oldPath + "\\";
                }
                oldPath = oldPath.toUpperCase();
                for (String statePath : this.m_stateCache.keySet()) {
                    if (statePath.length() <= oldPath.length() || !statePath.startsWith(oldPath)) continue;
                    FileState renState = this.m_stateCache.get(statePath);
                    renState.setFileStatus(FileStatus.NotExist);
                    renState.setFileId(-1);
                    if (!this.hasDebug()) continue;
                    Debug.println("++ Rename update " + statePath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAllFileStates() {
        if (this.m_stateCache == null) {
            return;
        }
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            if (this.m_stateCache.isEmpty()) {
                return;
            }
            for (FileState state : this.m_stateCache.values()) {
                if (this.hasStateListener()) {
                    this.getStateListener().fileStateClosed(state);
                }
                if (!this.hasDebug()) continue;
                Debug.println("++ Closed: " + state.getPath());
            }
            this.m_stateCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int removeExpiredFileStates() {
        if (this.m_stateCache == null) {
            return 0;
        }
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            if (this.m_stateCache.isEmpty()) {
                return 0;
            }
            Iterator<Map.Entry<String, FileState>> enm = this.m_stateCache.entrySet().iterator();
            long curTime = System.currentTimeMillis();
            int expiredCnt = 0;
            int openCnt = 0;
            while (enm.hasNext()) {
                Map.Entry<String, FileState> entry = enm.next();
                FileState state = entry.getValue();
                if (state == null || state.isPermanentState()) continue;
                if (state.hasExpired(curTime) && state.getOpenCount() == 0) {
                    if (this.hasStateListener() && !this.getStateListener().fileStateExpired(state)) continue;
                    enm.remove();
                    if (this.hasDebugExpiredStates()) {
                        Debug.println("++ Expired file state: " + state);
                    }
                    ++expiredCnt;
                    continue;
                }
                if (state.getOpenCount() <= 0) continue;
                ++openCnt;
            }
            if (this.hasDebugExpiredStates() && openCnt > 0) {
                Debug.println("++ Open files " + openCnt);
                this.dumpCache(false);
            }
            return expiredCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dumpCache(boolean dumpAttribs) {
        Map<String, FileState> map = this.m_stateCache;
        synchronized (map) {
            if (this.m_stateCache.size() > 0) {
                Debug.println("++ FileStateCache Entries:");
            }
            long curTime = System.currentTimeMillis();
            for (Map.Entry<String, FileState> entry : this.m_stateCache.entrySet()) {
                FileState state = entry.getValue();
                Debug.println("++  " + entry.getKey() + "(" + state.getSecondsToExpire(curTime) + ") : " + state.toString());
                if (!dumpAttribs) continue;
                state.DumpAttributes();
            }
        }
    }

    public void requestOplockBreak(String path, OpLockDetails oplock) throws IOException {
    }
}

