/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.RemoteStateTask;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.smb.OpLockType;

public class ChangeOpLockTypeTask
extends RemoteStateTask<Integer> {
    private static final long serialVersionUID = 1L;
    private OpLockType m_oplockType;

    public ChangeOpLockTypeTask() {
    }

    public ChangeOpLockTypeTask(String mapName, String key, OpLockType newLockType, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_oplockType = newLockType;
    }

    @Override
    protected Integer runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("ChangeOpLockTypeTask: New type=" + this.m_oplockType.name() + " for state " + fState);
        }
        OpLockDetails oplock = fState.getOpLock();
        OpLockType newType = OpLockType.INVALID;
        if (oplock != null) {
            OpLockType oldOpLockType = oplock.getLockType();
            oplock.setLockType(this.m_oplockType);
            newType = this.m_oplockType;
            if (this.hasDebug()) {
                Debug.println("ChangeOpLockTypeTask: Changed type from=" + oldOpLockType.name() + " to=" + this.m_oplockType.name());
            }
        }
        return new Integer(newType.intValue());
    }
}

