/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.CreateDisposition;
import org.filesys.server.filesys.ExistingOpLockException;
import org.filesys.server.filesys.FileAccessToken;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileSharingException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.GrantAccessParams;
import org.filesys.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.filesys.server.filesys.cache.hazelcast.RemoteOpLockDetails;
import org.filesys.server.filesys.cache.hazelcast.RemoteStateTask;
import org.filesys.smb.ImpersonationLevel;
import org.filesys.smb.OpLockType;
import org.filesys.smb.SharingMode;

public class GrantFileAccessTask
extends RemoteStateTask<FileAccessToken> {
    private static final long serialVersionUID = 1L;
    private GrantAccessParams m_params;

    public GrantFileAccessTask() {
    }

    public GrantFileAccessTask(String mapName, String key, GrantAccessParams params, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_params = params;
    }

    @Override
    protected FileAccessToken runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("GrantFileAccessTask: Open params=" + this.m_params + " path " + fState);
        }
        boolean nosharing = false;
        OpLockType grantedOplock = OpLockType.LEVEL_NONE;
        boolean oplockNotAvailable = false;
        String noshrReason = null;
        boolean attribsOnly = false;
        if (this.m_params.isAttributesOnlyAccess()) {
            attribsOnly = true;
            if (this.hasDebug()) {
                Debug.println("Attributes only access for " + fState);
            }
        } else if (fState.getOpenCount() > 0) {
            String curPrimaryOwner = (String)fState.getPrimaryOwner();
            if (this.hasDebug()) {
                Debug.println("File already open by " + curPrimaryOwner + ", pid=" + fState.getProcessId() + ", sharingMode=" + fState.getSharedAccess().name());
            }
            if (this.m_params.getOpenAction() == CreateDisposition.CREATE) {
                throw new FileExistsException();
            }
            if (this.m_params.getSecurityLevel() == ImpersonationLevel.IMPERSONATION && this.m_params.getProcessId() == fState.getProcessId() && curPrimaryOwner.equalsIgnoreCase(this.m_params.getOwnerName())) {
                nosharing = false;
            } else if (this.m_params.isReadOnlyAccess() && fState.getSharedAccess().hasRead()) {
                nosharing = false;
            } else if ((this.m_params.isReadWriteAccess() || this.m_params.isWriteOnlyAccess()) && fState.getSharedAccess().hasWrite()) {
                nosharing = true;
                noshrReason = "Sharing mode disallows write";
                if (this.hasDebug()) {
                    Debug.println("Sharing mode disallows write access path=" + fState.getPath());
                }
            } else if (fState.getSharedAccess() == SharingMode.NOSHARING) {
                nosharing = true;
                noshrReason = "Sharing mode exclusive";
            } else if ((fState.getSharedAccess().intValue() & this.m_params.getSharedAccess().intValue()) != this.m_params.getSharedAccess().intValue()) {
                nosharing = true;
                noshrReason = "Sharing mode mismatch";
                if (this.hasDebug()) {
                    Debug.println("Local share mode=" + fState.getSharedAccess().name() + ", params share mode=" + this.m_params.getSharedAccess().name());
                }
            } else if (this.m_params.getSharedAccess() == SharingMode.NOSHARING) {
                nosharing = true;
                noshrReason = "Requestor wants exclusive mode";
            }
            oplockNotAvailable = true;
        } else if (this.m_params.hasOpLockRequest() && !this.m_params.isDirectory()) {
            grantedOplock = this.m_params.getOpLockType();
            if (this.hasDebug()) {
                Debug.println("Granted oplock type=" + grantedOplock.name());
            }
        }
        if (nosharing) {
            throw new FileSharingException("File sharing violation, reason " + noshrReason);
        }
        if (!attribsOnly) {
            fState.setSharedAccess(this.m_params.getSharedAccess());
            fState.setProcessId(this.m_params.getProcessId());
            fState.setPrimaryOwner(this.m_params.getOwnerName());
            if (grantedOplock != OpLockType.LEVEL_NONE) {
                try {
                    RemoteOpLockDetails remoteOplock = new RemoteOpLockDetails(this.m_params.getOwnerName(), grantedOplock, fState.getPath(), null);
                    fState.setOpLock(remoteOplock);
                }
                catch (ExistingOpLockException ex) {
                    if (this.hasDebug()) {
                        Debug.println("Failed to set oplock on " + fState + ", existing oplock=" + fState.getOpLock());
                    }
                    grantedOplock = OpLockType.LEVEL_NONE;
                    oplockNotAvailable = true;
                }
            }
            fState.incrementOpenCount();
            if (this.m_params.getFileStatus() != FileStatus.Unknown) {
                fState.setFileStatusInternal(this.m_params.getFileStatus(), FileState.ChangeReason.None);
            }
        }
        HazelCastAccessToken hcToken = new HazelCastAccessToken(this.m_params.getOwnerName(), this.m_params.getProcessId(), grantedOplock, oplockNotAvailable);
        hcToken.setReleased(true);
        hcToken.setAttributesOnly(attribsOnly);
        return hcToken;
    }
}

