/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import java.io.Serializable;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileAccessToken;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.smb.OpLockType;

public class HazelCastAccessToken
implements Serializable,
FileAccessToken {
    private static final long serialVersionUID = 5L;
    private String m_ownerName;
    private int m_pid;
    private OpLockType m_oplock;
    private boolean m_oplockNotAvailable;
    private String m_path;
    private boolean m_attribOnly;
    private transient boolean m_released = false;

    public HazelCastAccessToken() {
        this.setReleased(true);
    }

    protected HazelCastAccessToken(String clName, int pid) {
        this.m_ownerName = clName;
        this.m_pid = pid;
    }

    protected HazelCastAccessToken(ClusterNode clNode, int pid) {
        this.m_ownerName = clNode.getName();
        this.m_pid = pid;
    }

    protected HazelCastAccessToken(String clName, int pid, OpLockType oplock, boolean oplockNotAvail) {
        this.m_ownerName = clName;
        this.m_pid = pid;
        this.m_oplock = oplock;
        this.m_oplockNotAvailable = oplockNotAvail;
    }

    public final String getOwnerName() {
        return this.m_ownerName;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final boolean isOplockAvailable() {
        return !this.m_oplockNotAvailable;
    }

    public final OpLockType getOpLockType() {
        return this.m_oplock;
    }

    public final void setOpLockType(OpLockType oplock) {
        this.m_oplock = oplock;
    }

    public final boolean isReleased() {
        return this.m_released;
    }

    public final void setReleased(boolean released) {
        this.m_released = released;
    }

    public final String getNetworkFilePath() {
        return this.m_path;
    }

    public final void setNetworkFilePath(String path) {
        this.m_path = path;
    }

    public final boolean isAttributesOnly() {
        return this.m_attribOnly;
    }

    public final void setAttributesOnly(boolean attrOnly) {
        this.m_attribOnly = attrOnly;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Token owner=");
        str.append(this.getOwnerName());
        str.append(",pid=");
        str.append(this.getProcessId());
        if (this.getOpLockType() != OpLockType.LEVEL_NONE) {
            str.append(",oplock=");
            str.append(this.getOpLockType().name());
        } else {
            str.append(",opavail=");
            str.append(this.isOplockAvailable());
        }
        if (this.isAttributesOnly()) {
            str.append(",AttribOnly");
        }
        if (this.isReleased()) {
            str.append(",Released");
        } else {
            str.append(",File=");
            str.append(this.getNetworkFilePath());
        }
        str.append("]");
        return str.toString();
    }

    public void finalize() {
        if (!this.isReleased()) {
            Debug.println("** Access token finalized, not released, " + this.toString() + " **");
        }
    }
}

