/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.FileAccessToken;
import org.filesys.server.filesys.cache.cluster.ClusterFileState;
import org.filesys.server.filesys.cache.hazelcast.HazelCastAccessToken;
import org.filesys.server.filesys.cache.hazelcast.OpLockMessage;
import org.filesys.server.filesys.cache.hazelcast.RemoteStateTask;
import org.filesys.smb.OpLockType;
import org.filesys.smb.SharingMode;

public class ReleaseFileAccessTask
extends RemoteStateTask<Integer> {
    private static final long serialVersionUID = 1L;
    private FileAccessToken m_token;
    private String m_clusterTopic;

    public ReleaseFileAccessTask() {
    }

    public ReleaseFileAccessTask(String mapName, String key, FileAccessToken token, String clusterTopic, boolean debug, boolean timingDebug) {
        super(mapName, key, true, false, debug, timingDebug);
        this.m_token = token;
    }

    @Override
    protected Integer runRemoteTaskAgainstState(IMap<String, ClusterFileState> stateCache, ClusterFileState fState) throws Exception {
        if (this.hasDebug()) {
            Debug.println("ReleaseFileAccessTask: Release token=" + this.m_token + " path " + fState);
        }
        int openCount = fState.getOpenCount();
        if (this.m_token instanceof HazelCastAccessToken) {
            HazelCastAccessToken hcToken = (HazelCastAccessToken)this.m_token;
            if (!hcToken.isAttributesOnly() && (openCount = fState.decrementOpenCount()) == 0) {
                fState.setSharedAccess(SharingMode.ALL);
                fState.setPrimaryOwner(null);
            }
            if (fState.hasOpLock() && hcToken.getOpLockType() != OpLockType.LEVEL_NONE) {
                fState.clearOpLock();
                ITopic clusterTopic = this.getHazelcastInstance().getTopic(this.m_clusterTopic);
                OpLockMessage oplockMsg = new OpLockMessage("*", 2, fState.getPath());
                clusterTopic.publish((Object)oplockMsg);
                if (this.hasDebug()) {
                    Debug.println("Cleared remote oplock during token release");
                }
            }
            hcToken.setReleased(true);
        }
        return new Integer(openCount);
    }
}

