/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.cache.hazelcast;

import java.io.IOException;
import java.io.Serializable;
import org.filesys.server.filesys.DeferFailedException;
import org.filesys.server.filesys.cache.cluster.ClusterFileStateCache;
import org.filesys.server.filesys.cache.cluster.ClusterNode;
import org.filesys.server.filesys.cache.cluster.PerNodeState;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.server.locking.OpLockDetailsAdapter;
import org.filesys.smb.OpLockType;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class RemoteOpLockDetails
extends OpLockDetailsAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OpLockType m_lockType;
    private String m_ownerName;
    private String m_path;
    private transient ClusterFileStateCache m_stateCache;

    public RemoteOpLockDetails() {
    }

    protected RemoteOpLockDetails(ClusterNode clNode, OpLockType lockTyp, String path, ClusterFileStateCache stateCache) {
        this.m_ownerName = clNode.getName();
        this.m_lockType = lockTyp;
        this.m_path = path;
        this.m_stateCache = stateCache;
    }

    protected RemoteOpLockDetails(ClusterNode clNode, OpLockDetails localOpLock, ClusterFileStateCache stateCache) {
        this.m_ownerName = clNode.getName();
        this.m_lockType = localOpLock.getLockType();
        this.m_path = localOpLock.getPath();
        this.m_stateCache = stateCache;
    }

    protected RemoteOpLockDetails(String ownerName, OpLockType lockTyp, String path, ClusterFileStateCache stateCache) {
        this.m_ownerName = ownerName;
        this.m_lockType = lockTyp;
        this.m_path = path;
        this.m_stateCache = stateCache;
    }

    @Override
    public OpLockType getLockType() {
        return this.m_lockType;
    }

    public final String getOwnerName() {
        return this.m_ownerName;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public boolean isRemoteLock() {
        return true;
    }

    @Override
    public void requestOpLockBreak() throws IOException {
        throw new IOException("Attempt to break remote oplock, owner=" + this.getOwnerName() + ", type=" + this.getLockType().name());
    }

    @Override
    public boolean hasDeferredSessions() {
        PerNodeState perNode;
        boolean hasDefer = false;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            hasDefer = perNode.hasDeferredSessions();
        }
        return hasDefer;
    }

    @Override
    public int numberOfDeferredSessions() {
        PerNodeState perNode;
        int deferCnt = 0;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            deferCnt = perNode.numberOfDeferredSessions();
        }
        return deferCnt;
    }

    @Override
    public void addDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) throws DeferFailedException {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            perNode.addDeferredSession(deferredSess, deferredPkt);
        }
    }

    @Override
    public void updateDeferredPacketLease() {
        PerNodeState perNode;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            perNode.updateDeferredPacketLease();
        }
    }

    @Override
    public int requeueDeferredRequests() {
        PerNodeState perNode;
        int requeueCnt = 0;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            requeueCnt = perNode.requeueDeferredRequests();
        }
        return requeueCnt;
    }

    @Override
    public int failDeferredRequests() {
        PerNodeState perNode;
        int failCnt = 0;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), false)) != null) {
            failCnt = perNode.failDeferredRequests();
        }
        return failCnt;
    }

    @Override
    public long getOplockBreakTime() {
        PerNodeState perNode;
        long breakTime = 0L;
        if (this.getStateCache() != null && (perNode = this.getStateCache().getPerNodeState(this.getPath(), true)) != null) {
            breakTime = perNode.getOplockBreakTime();
        }
        return breakTime;
    }

    @Override
    public boolean hasOplockBreakFailed() {
        return false;
    }

    @Override
    public void setOplockBreakFailed() {
    }

    public final ClusterFileStateCache getStateCache() {
        return this.m_stateCache;
    }

    public final void setStateCache(ClusterFileStateCache stateCache) {
        this.m_stateCache = stateCache;
    }

    @Override
    public void setLockType(OpLockType lockTyp) {
        this.m_lockType = lockTyp;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Remote Owner=");
        str.append(this.getOwnerName());
        str.append(",type=");
        str.append(this.getLockType().name());
        if (this.getStateCache() == null) {
            str.append(",stateCache=null");
        }
        str.append("]");
        return str.toString();
    }
}

