/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.File;
import java.util.EnumSet;
import org.filesys.debug.Debug;
import org.filesys.server.config.CoreServerConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.DeviceContextException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskSharedDevice;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.cache.FileStateCacheListener;
import org.filesys.server.filesys.cache.FileStateLockManager;
import org.filesys.server.filesys.db.DBException;
import org.filesys.server.filesys.db.DBFileInfo;
import org.filesys.server.filesys.db.DBInterface;
import org.filesys.server.filesys.db.DBQuotaManager;
import org.filesys.server.filesys.loader.DeleteFileRequest;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileRequestQueue;
import org.filesys.server.filesys.quota.QuotaManagerException;
import org.filesys.server.locking.LockManager;
import org.filesys.server.locking.OpLockManager;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class DBDeviceContext
extends DiskDeviceContext
implements FileStateCacheListener {
    private static final long MillisecondsPerDay = 86400000L;
    private static final long MinimumMaxfileSize = 524288L;
    private boolean m_ntfsStreams = true;
    private String m_dbifClass;
    private DBInterface m_dbInterface;
    private ConfigElement m_dbifConfig;
    private String m_loaderClass;
    private FileLoader m_loader;
    private ConfigElement m_loaderConfig;
    private boolean m_trashCan;
    private long m_retentionPeriod = -1L;
    private DBFileInfo m_rootInfo;
    private long m_maxFileSize;
    private boolean m_offlineFiles;
    private long m_offlineFileSize;
    private FileRequestQueue m_offlineDeleteList;
    private FileStateLockManager m_lockManager;
    private boolean m_oplocksEnabled = true;

    public DBDeviceContext(ConfigElement args) throws DeviceContextException {
        this.initialize(args);
    }

    public DBDeviceContext(String name, ConfigElement args) throws DeviceContextException {
        this.setShareName(name);
        this.initialize(args);
    }

    protected final void initialize(ConfigElement args) throws DeviceContextException {
        ConfigElement nameVal;
        this.setFilesystemAttributes(3);
        ConfigElement dbParams = args.getChild("DatabaseInterface");
        if (dbParams != null) {
            ConfigElement dbClass = dbParams.getChild("class");
            if (dbClass == null) {
                throw new DeviceContextException("Database interface class not specified");
            }
            try {
                Object dbObj = Class.forName(dbClass.getValue()).newInstance();
                if (!(dbObj instanceof DBInterface)) {
                    throw new DeviceContextException("Database interface class is not an instance of DBInterface");
                }
                this.m_dbifClass = dbClass.getValue();
                this.m_dbInterface = (DBInterface)dbObj;
                this.m_dbifConfig = dbParams;
            }
            catch (Exception ex) {
                throw new DeviceContextException("Database interface error, " + ex.toString());
            }
        } else {
            throw new DeviceContextException("Invalid Database Interface configuration");
        }
        ConfigElement ldrParams = args.getChild("FileLoader");
        if (ldrParams != null) {
            this.m_loaderConfig = ldrParams;
            ConfigElement ldrClass = this.m_loaderConfig.getChild("class");
            if (ldrClass == null || ldrClass.getValue().length() == 0) {
                throw new DeviceContextException("Invalid File Loader configuration");
            }
            this.m_loaderClass = ldrClass.getValue();
        } else if (this.m_dbInterface instanceof FileLoader) {
            this.m_loader = (FileLoader)((Object)this.m_dbInterface);
        }
        if (args.getChild("Debug") != null) {
            this.setDebug(true);
        }
        if (args.getChild("disableNTFSStreams") != null) {
            this.m_ntfsStreams = false;
        }
        if (args.getChild("enableTrashCan") != null) {
            this.m_trashCan = true;
        }
        if (args.getChild("offlineFiles") != null) {
            this.m_offlineFiles = true;
        }
        if (args.getChild("disableOplocks") != null) {
            this.m_oplocksEnabled = false;
        }
        if ((nameVal = args.getChild("offlineFileSize")) != null) {
            try {
                this.m_offlineFileSize = MemorySize.getByteValue(nameVal.getValue());
                if (this.m_offlineFileSize < 0L) {
                    throw new DeviceContextException("Invalid offline files size, " + nameVal.getValue());
                }
                this.m_offlineFiles = true;
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("Invalid offline files size, " + nameVal.getValue());
            }
        }
        if ((nameVal = args.getChild("MaxFileSize")) != null) {
            try {
                this.m_maxFileSize = MemorySize.getByteValue(nameVal.getValue());
                if (this.m_maxFileSize < 524288L) {
                    throw new DeviceContextException("Maximum file size is below minimum allowed setting (512K)");
                }
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("Invalid maximum file size value, " + nameVal.getValue());
            }
        }
        if (args.getChild("QuotaManagement") != null) {
            boolean quotaDebug = args.getChild("QuotaDebug") != null;
            this.setQuotaManager(new DBQuotaManager(this, quotaDebug));
        }
        if ((nameVal = args.getChild("RetentionPeriod")) != null) {
            try {
                long retainDays = Long.parseLong(nameVal.getValue());
                if (retainDays < 0L || retainDays > 3650L) {
                    throw new DeviceContextException("RetentionPeriod out of valid range (0 - 3650)");
                }
                this.m_retentionPeriod = retainDays * 86400000L;
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("RetentionPeriod is invalid, " + nameVal.getValue());
            }
        }
        if (this.hasRetentionPeriod() && !this.getDBInterface().supportsFeature(DBInterface.Feature.Retention)) {
            throw new DeviceContextException("Database interface does not support retention");
        }
        EnumSet<DBInterface.Feature> dbFeatures = EnumSet.noneOf(DBInterface.Feature.class);
        if (this.m_loaderClass != null) {
            try {
                this.m_loader = (FileLoader)Class.forName(this.m_loaderClass).newInstance();
                dbFeatures = this.m_loader.getRequiredDBFeatures();
                this.m_loader.setContext(this);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new DeviceContextException(ex.getMessage());
            }
        } else if (this.m_loader == null) {
            throw new DeviceContextException("File loader not specified");
        }
        this.m_rootInfo = new DBFileInfo("\\", "\\", 0, 0);
        this.m_rootInfo.setFileAttributes(16);
        this.m_rootInfo.setMode(493);
        this.m_rootInfo.setGid(0);
        this.m_rootInfo.setUid(0);
        long timeNow = System.currentTimeMillis();
        this.m_rootInfo.setCreationDateTime(timeNow);
        this.m_rootInfo.setAccessDateTime(timeNow);
        this.m_rootInfo.setModifyDateTime(timeNow);
        this.m_rootInfo.setChangeDateTime(timeNow);
        if (this.hasNTFSStreamsEnabled() && this.m_loader.supportsStreams()) {
            dbFeatures.add(DBInterface.Feature.NTFS);
        } else {
            this.m_ntfsStreams = false;
        }
        if (this.hasRetentionPeriod()) {
            dbFeatures.add(DBInterface.Feature.Retention);
        }
        if (this.getDBInterface().supportsFeature(DBInterface.Feature.SymLinks)) {
            dbFeatures.add(DBInterface.Feature.SymLinks);
        }
        try {
            this.getDBInterface().requestFeatures(dbFeatures);
        }
        catch (DBException ex) {
            throw new DeviceContextException("Failed to enable database features, " + ex.getMessage());
        }
        try {
            this.getDBInterface().initializeDatabase(this, this.m_dbifConfig);
        }
        catch (InvalidConfigurationException ex) {
            throw new DeviceContextException("Database interface initialization failure, " + ex.toString());
        }
        if (this.m_loaderClass != null) {
            try {
                this.m_loader.initializeLoader(this.m_loaderConfig, this);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new DeviceContextException(ex.getMessage());
            }
        }
        if (this.hasNTFSStreamsEnabled()) {
            this.setFilesystemAttributes(this.getFilesystemAttributes() + 262144);
        }
        this.setRequiresStateCache(true);
        this.setAvailable(false);
    }

    public final String getDBInterfaceClass() {
        return this.m_dbifClass;
    }

    public final DBInterface getDBInterface() {
        return this.m_dbInterface;
    }

    public final ConfigElement getDBInterfaceConfiguration() {
        return this.m_dbifConfig;
    }

    public final String getFileLoaderClass() {
        return this.m_loaderClass;
    }

    public final FileLoader getFileLoader() {
        return this.m_loader;
    }

    public final ConfigElement getLoaderConfiguration() {
        return this.m_loaderConfig;
    }

    public final boolean hasOfflineFiles() {
        return this.m_offlineFiles;
    }

    public final boolean hasOfflineFileSize() {
        return this.m_offlineFileSize > 0L;
    }

    public final long getOfflineFileSize() {
        return this.m_offlineFileSize;
    }

    public FileStateLockManager getFileStateLockManager() {
        return this.m_lockManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.m_lockManager;
    }

    @Override
    public OpLockManager getOpLockManager() {
        return this.m_lockManager;
    }

    public final boolean isOpLocksEnabled() {
        return this.m_oplocksEnabled;
    }

    public final boolean hasRetentionPeriod() {
        return this.m_retentionPeriod != -1L;
    }

    public final long getRetentionPeriod() {
        return this.m_retentionPeriod;
    }

    public final DBFileInfo getRootDirectoryInfo() {
        return this.m_rootInfo;
    }

    public final boolean hasNTFSStreamsEnabled() {
        return this.m_ntfsStreams;
    }

    public final boolean isTrashCanEnabled() {
        return this.m_trashCan;
    }

    public final boolean hasMaximumFileSize() {
        return this.m_maxFileSize != 0L;
    }

    public final long getMaximumFileSize() {
        return this.m_maxFileSize;
    }

    public final boolean hasOfflineFileDeletes() {
        return this.m_offlineDeleteList != null;
    }

    public final synchronized FileRequestQueue getOfflineFileDeletes(boolean clearList) {
        FileRequestQueue deleteList = this.m_offlineDeleteList;
        if (clearList) {
            this.m_offlineDeleteList = null;
        }
        return deleteList;
    }

    public final synchronized void addOfflineFileDelete(DeleteFileRequest deleteReq) {
        if (this.m_offlineDeleteList == null) {
            this.m_offlineDeleteList = new FileRequestQueue();
        }
        this.m_offlineDeleteList.addRequest(deleteReq);
    }

    protected final void setFileStateLockManager(FileStateLockManager lockManager) {
        this.m_lockManager = lockManager;
    }

    public boolean fileStateExpired(FileState state) {
        String tempName = (String)state.findAttribute("DBCacheFile");
        if (tempName != null) {
            if (state.getOpenCount() > 0) {
                return false;
            }
            File tempFile = new File(tempName);
            tempFile.delete();
            if (this.hasDebug()) {
                Debug.println("$$ Deleted temporary file " + tempName + " (Expired) $$");
            }
        }
        return true;
    }

    public void fileStateClosed(FileState state) {
        String tempName = (String)state.findAttribute("DBCacheFile");
        if (tempName != null) {
            File tempFile = new File(tempName);
            tempFile.delete();
            if (this.hasDebug()) {
                Debug.println("$$ Deleted temporary file " + tempName + " (Closed) $$");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getDBInterface().getDBInterfaceName());
        str.append(",");
        str.append(this.getFileLoaderClass());
        str.append("]");
        return str.toString();
    }

    @Override
    public void CloseContext() {
        if (this.getFileLoader() != null) {
            this.getFileLoader().shutdownLoader(false);
        }
        if (this.getDBInterface() != null) {
            this.getDBInterface().shutdownDatabase(this);
        }
        if (this.hasStateCache()) {
            this.getStateCache().removeAllFileStates();
        }
        super.CloseContext();
    }

    @Override
    public void startFilesystem(DiskSharedDevice disk) throws DeviceContextException {
        this.getFileLoader().startLoader(this);
        if (this.hasQuotaManager()) {
            try {
                this.getQuotaManager().startManager(disk.getDiskInterface(), this);
            }
            catch (QuotaManagerException ex) {
                throw new DeviceContextException(ex.toString());
            }
        }
        this.setFileStateLockManager(new FileStateLockManager(this.getStateCache()));
        if (this.getLockManager() != null) {
            CoreServerConfigSection coreConfig;
            ThreadRequestPool threadPool = null;
            ServerConfiguration config = disk.getConfiguration();
            if (config != null && (coreConfig = (CoreServerConfigSection)config.getConfigSection("CoreServer")) != null) {
                threadPool = coreConfig.getThreadPool();
            }
            this.getFileStateLockManager().startLockManager("OplockExpire_" + disk.getName(), threadPool);
        }
    }

    @Override
    public void stateCacheInitializing() {
        this.setAvailable(false);
    }

    @Override
    public void stateCacheRunning() {
        this.setAvailable(true);
    }

    @Override
    public void stateCacheShuttingDown() {
        this.setAvailable(false);
    }
}

