/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.filesys.DirectoryNotEmptyException;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.db.DBDeviceContext;
import org.filesys.server.filesys.db.DBException;
import org.filesys.server.filesys.db.DBFileInfo;
import org.filesys.server.filesys.db.DBSearchContext;
import org.filesys.server.filesys.db.RetentionDetails;
import org.filesys.smb.server.ntfs.StreamInfo;
import org.filesys.smb.server.ntfs.StreamInfoList;
import org.springframework.extensions.config.ConfigElement;

public interface DBInterface {
    public String getDBInterfaceName();

    public boolean supportsFeature(Feature var1);

    public void requestFeatures(EnumSet<Feature> var1) throws DBException;

    public void initializeDatabase(DBDeviceContext var1, ConfigElement var2) throws InvalidConfigurationException;

    public void shutdownDatabase(DBDeviceContext var1);

    public boolean isOnline();

    public FileStatus fileExists(int var1, String var2) throws DBException;

    public int createFileRecord(String var1, int var2, FileOpenParams var3, boolean var4) throws DBException, FileExistsException;

    public int createStreamRecord(String var1, int var2) throws DBException;

    public void deleteFileRecord(int var1, int var2, boolean var3) throws DBException, IOException, DirectoryNotEmptyException;

    public void deleteStreamRecord(int var1, int var2, boolean var3) throws DBException;

    public void setFileInformation(int var1, int var2, FileInfo var3) throws DBException;

    public void setStreamInformation(int var1, int var2, int var3, StreamInfo var4) throws DBException;

    public int getFileId(int var1, String var2, boolean var3, boolean var4) throws DBException;

    public DBFileInfo getFileInformation(int var1, int var2, FileInfoLevel var3) throws DBException;

    public StreamInfo getStreamInformation(int var1, int var2, StreamInfoLevel var3) throws DBException;

    public StreamInfoList getStreamsList(int var1, StreamInfoLevel var2) throws DBException;

    public void renameFileRecord(int var1, int var2, String var3, int var4) throws DBException, FileNotFoundException;

    public void renameStreamRecord(int var1, int var2, int var3, String var4) throws DBException;

    public RetentionDetails getFileRetentionDetails(int var1, int var2) throws DBException;

    public DBSearchContext startSearch(int var1, String var2, int var3, FileInfoLevel var4, int var5) throws DBException;

    public String readSymbolicLink(int var1, int var2) throws DBException;

    public void deleteSymbolicLinkRecord(int var1, int var2) throws DBException;

    public long getUsedFileSpace();

    public static enum StreamInfoLevel {
        NameOnly,
        Ids,
        All;

    }

    public static enum FileInfoLevel {
        NameOnly,
        Ids,
        All;

    }

    public static enum Feature {
        NTFS,
        Retention,
        Queue,
        Data,
        JarData,
        ObjectId,
        SymLinks,
        SecDescriptor;

    }
}

