/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.DiskSizeInterface;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.db.DBDeviceContext;
import org.filesys.server.filesys.quota.QuotaManager;
import org.filesys.server.filesys.quota.QuotaManagerException;
import org.filesys.util.MemorySize;

public class DBQuotaManager
implements QuotaManager {
    private SrvDiskInfo m_diskInfo;
    private long m_totalSpace;
    private long m_freeSpace;
    private boolean m_debug;

    public DBQuotaManager(DBDeviceContext ctx, boolean dbg) {
        this.setDebug(dbg);
    }

    @Override
    public synchronized long allocateSpace(SrvSession sess, TreeConnection tree, NetworkFile file, long alloc) throws IOException {
        if (this.m_freeSpace > alloc && alloc > 0L) {
            this.m_freeSpace -= alloc;
            if (this.hasDebug()) {
                Debug.println("JDBCQuotaManager: Allocate=" + alloc + ", free=" + MemorySize.asScaledString(this.m_freeSpace));
            }
        } else {
            throw new DiskFullException();
        }
        return alloc;
    }

    @Override
    public synchronized void releaseSpace(SrvSession sess, TreeConnection tree, int fid, String path, long alloc) throws IOException {
        if (alloc > 0L) {
            this.m_freeSpace += alloc;
            if (this.m_freeSpace > this.m_totalSpace) {
                this.m_freeSpace = this.m_totalSpace;
            }
            if (this.hasDebug()) {
                Debug.println("JDBCQuotaManager: Release=" + alloc + ", free=" + MemorySize.asScaledString(this.m_freeSpace));
            }
        }
    }

    @Override
    public void startManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        DBDeviceContext dbCtx = (DBDeviceContext)ctx;
        if (disk instanceof DiskSizeInterface) {
            DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
            this.m_diskInfo = new SrvDiskInfo();
            try {
                sizeInterface.getDiskInformation(ctx, this.m_diskInfo);
            }
            catch (IOException ex) {
                this.m_diskInfo = null;
            }
        } else if (dbCtx.hasDiskInformation()) {
            this.m_diskInfo = dbCtx.getDiskInformation();
        }
        if (this.m_diskInfo == null) {
            throw new QuotaManagerException("Disk size information not available");
        }
        this.m_totalSpace = this.m_diskInfo.getDiskSizeKb() * 1024L;
        if (this.m_totalSpace == 0L) {
            throw new QuotaManagerException("Disk size not set");
        }
        long usedSpace = dbCtx.getDBInterface().getUsedFileSpace();
        if (usedSpace == -1L) {
            throw new QuotaManagerException("Failed to calculate used space");
        }
        this.m_freeSpace = this.m_totalSpace - usedSpace;
        if (this.hasDebug()) {
            Debug.println("JDBCQuotaManager: Startup totalSpace=" + MemorySize.asScaledString(this.m_totalSpace) + ", freeSpace=" + MemorySize.asScaledString(this.m_freeSpace));
        }
    }

    @Override
    public void stopManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
    }

    @Override
    public synchronized long getAvailableFreeSpace() {
        return this.m_freeSpace;
    }

    @Override
    public long getUserFreeSpace(SrvSession sess, TreeConnection tree) {
        return this.m_freeSpace;
    }

    @Override
    public long getUserTotalSpace(SrvSession sess, TreeConnection tree) {
        return this.m_totalSpace;
    }

    public boolean hasDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }
}

