/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileStateProxy;
import org.filesys.server.filesys.db.CachedNetworkFile;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.InMemoryLoader;
import org.filesys.server.filesys.loader.MemoryBuffer;
import org.filesys.server.filesys.loader.MemoryLoadableFile;
import org.filesys.server.filesys.loader.MemorySegmentInfo;
import org.filesys.server.filesys.loader.MemoryStorableFile;
import org.filesys.server.filesys.loader.SegmentInfo;

public abstract class MemCachedNetworkFile
extends CachedNetworkFile {
    public static final long WriteBufferWaitTime = 20000L;
    protected MemorySegmentInfo m_memFile;
    protected boolean m_outOfSeqRead = false;
    protected int m_shortReadMaxSize = 0;

    public MemCachedNetworkFile(String name, int fid, int stid, int did, FileStateProxy state, MemorySegmentInfo segment, FileLoader loader) {
        super(name, fid, stid, did, state, loader);
        this.m_memFile = segment;
        if (this.m_memFile != null) {
            this.m_memFile.setShortReadSize(this.getShortReadSize());
        }
    }

    public final MemorySegmentInfo getMemorySegment() {
        return this.m_memFile;
    }

    public final void setMemorySegment(MemorySegmentInfo memInfo) {
        this.m_memFile = memInfo;
    }

    public abstract long getInMemoryMaximumSize();

    public final boolean hasOutOfSequenceReads() {
        return this.m_outOfSeqRead;
    }

    protected final void setOutOfSequenceRead(boolean ooSeq) {
        this.m_outOfSeqRead = ooSeq;
    }

    public final int getShortReadSize() {
        return this.m_shortReadMaxSize;
    }

    protected final void setShortReadSize(int rxSiz) {
        this.m_shortReadMaxSize = rxSiz;
        if (this.m_memFile != null) {
            this.m_memFile.setShortReadSize(this.getShortReadSize());
        }
    }

    @Override
    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        MemoryBuffer memBuf;
        if (this.hasDebug()) {
            Debug.println("MemCachedNetworkFile.readFile() file=" + this.getName() + ", offset=" + fileOff + ", len=" + len);
        }
        if (this.m_memFile.hasLoadError()) {
            throw new FileOfflineException("Error loading from store");
        }
        this.m_lastReadPos = fileOff;
        this.m_lastReadLen = len;
        MemoryLoadableFile.LoadableStatus loadSts = this.m_memFile.hasDataFor(fileOff, len);
        int rdlen = 0;
        if (this.m_memFile.isAllFileData() && loadSts == MemoryLoadableFile.LoadableStatus.NotAvailable && this.m_memFile.hasStatus() == SegmentInfo.State.Available) {
            loadSts = MemoryLoadableFile.LoadableStatus.Loadable;
            if (this.hasDebug()) {
                Debug.println("MemCacheNetworkFile.readFile() force reload, stale data cached");
            }
        }
        if (this.hasDebug()) {
            Debug.println("MemCachedNetworkFile: hasDataFor() fileOff=" + fileOff + ", len=" + len + " sts=" + loadSts.name());
        }
        boolean outOfSeq = false;
        if (!this.hasOutOfSequenceReads() && loadSts == MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq) {
            loadSts = this.m_memFile.isQueued() ? MemoryLoadableFile.LoadableStatus.Loading : MemoryLoadableFile.LoadableStatus.Loadable;
            outOfSeq = true;
        }
        if (loadSts == MemoryLoadableFile.LoadableStatus.Available) {
            if (!this.hasDebug()) return this.m_memFile.readBytes(buf, len, pos, fileOff);
            Debug.println("MemCachedNetworkFile Data Available Read");
            return this.m_memFile.readBytes(buf, len, pos, fileOff);
        }
        if (loadSts == MemoryLoadableFile.LoadableStatus.Loadable || loadSts == MemoryLoadableFile.LoadableStatus.Loading) {
            long waitTime = 0L;
            boolean readDone = false;
            boolean dataAvailable = false;
            while (!readDone && waitTime < 20000L) {
                if (loadSts == MemoryLoadableFile.LoadableStatus.Loadable) {
                    MemorySegmentInfo memorySegmentInfo = this.m_memFile;
                    synchronized (memorySegmentInfo) {
                        if (!this.m_memFile.isQueued()) {
                            if (this.hasDebug()) {
                                Debug.println("MemCachedNetworkFile: loadsts=" + loadSts.name() + ", flags=" + this.m_memFile.getFlags());
                            }
                            this.m_memFile.setStatus(SegmentInfo.State.Loading);
                            this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Load, fileOff, len, outOfSeq));
                        }
                    }
                }
                try {
                    this.setIOPending(true);
                    long startTime = System.currentTimeMillis();
                    this.m_memFile.waitForData(250L, fileOff, len);
                    long endTime = System.currentTimeMillis();
                    waitTime += endTime - startTime;
                    this.setIOPending(false);
                    if (this.hasDebug()) {
                        Debug.println("MemCachedNetworkFile waited " + (endTime - startTime) + "ms for data, available=" + this.m_memFile.getReadableLength());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_memFile.hasLoadError()) {
                    if (!this.hasDebug()) throw new FileOfflineException("Load error for " + this.getFullName());
                    Debug.println("MemCachedNetworkFile: File offline error for " + this.getFullName() + ", offset=" + fileOff + ", len=" + len);
                    Debug.println("MemCachedNetworkFile: state=" + this.getFileState() + ", memFile=" + this.m_memFile);
                    throw new FileOfflineException("Load error for " + this.getFullName());
                }
                loadSts = this.m_memFile.hasDataFor(fileOff, len);
                if (loadSts != MemoryLoadableFile.LoadableStatus.Available) continue;
                rdlen = this.m_memFile.readBytes(buf, len, pos, fileOff);
                readDone = true;
                if (!this.hasDebug()) continue;
                Debug.println("MemCachedNetworkFile waited " + waitTime + "ms for data, rdlen=" + rdlen + ", len=" + len);
            }
            if (readDone) return rdlen;
            if (this.hasDebug()) {
                Debug.println("MemCachedNetworkFile: File offline error for " + this.getFullName() + ", offset=" + fileOff + ", len=" + len);
                Debug.println("MemCachedNetworkFile: state=" + this.getFileState() + ", memFile=" + this.m_memFile);
            }
            this.m_memFile.setLoadError(true);
            throw new FileOfflineException("Failed to load file data in 20000ms for " + this.getFullName());
        }
        if (loadSts == MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq) {
            memBuf = this.loadOutOfSequence(fileOff, len);
            if (memBuf == null) {
                if (this.hasDebug()) {
                    Debug.println("MemCachedNetworkFile: Out of sequence read failed, path=" + this.getFullName() + ", fileOff=" + fileOff + ", len=" + len);
                }
                this.m_memFile.setLoadError(true);
                throw new FileOfflineException("Failed to load out of sequence file data  for " + this.getFullName());
            }
        } else {
            if (this.hasDebug()) {
                Debug.println("MemCachedNetworkFile: File offline error for " + this.getFullName() + ", offset=" + fileOff + ", len=" + len);
                Debug.println("MemCachedNetworkFile: state=" + this.getFileState() + ", memFile=" + this.m_memFile);
            }
            this.m_memFile.setLoadError(true);
            throw new FileOfflineException("Data not available for read, offset=" + fileOff + ", len=" + len);
        }
        this.m_memFile.addFileData(memBuf);
        rdlen = this.m_memFile.readBytes(buf, len, pos, fileOff);
        if (!this.hasDebug()) return rdlen;
        Debug.println("MemCachedNetworkFile: Out of sequence read, fileOff=" + fileOff + ", len=" + len + ", rdlen=" + rdlen);
        return rdlen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        if (this.m_memFile.hasSaveError()) {
            throw new IOException("Write error saving to store");
        }
        MemoryStorableFile.SaveableStatus writeSts = this.m_memFile.writeBytes(buf, len, pos, offset);
        if (writeSts == MemoryStorableFile.SaveableStatus.Saveable) {
            MemorySegmentInfo memorySegmentInfo = this.m_memFile;
            synchronized (memorySegmentInfo) {
                if (!this.m_memFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, offset, len, false));
                }
            }
        } else if (writeSts != MemoryStorableFile.SaveableStatus.MaxBuffers) {
            if (writeSts == MemoryStorableFile.SaveableStatus.BufferOverflow && this.m_memFile.isAllFileData()) {
                long fileLen = offset + (long)len;
                if (!(this.getLoader() instanceof InMemoryLoader)) {
                    this.m_memFile.setSaveError(true);
                    throw new DiskFullException("Cannot convert in-memory file to streamed, " + this.getFullName() + ", size=" + fileLen);
                }
                InMemoryLoader inMemLoader = (InMemoryLoader)((Object)this.getLoader());
                if (!inMemLoader.convertInMemoryToStreamedFile(this)) {
                    this.m_memFile.setSaveError(true);
                    throw new IOException("Failed to convert to streamed file, " + this.getFullName() + ", size=" + fileLen);
                }
                if (this.hasDebug()) {
                    Debug.println("MemCachedNetworkFile: Converted to streamed file, path=" + this.getFullName() + ", size=" + fileLen);
                }
                this.writeFile(buf, len, pos, offset);
            }
        } else {
            long waitTime = 0L;
            boolean writeDone = false;
            while (!writeDone && waitTime < 20000L) {
                try {
                    this.setIOPending(true);
                    if (!this.m_memFile.isQueued()) {
                        MemorySegmentInfo memorySegmentInfo = this.m_memFile;
                        synchronized (memorySegmentInfo) {
                            if (!this.m_memFile.isQueued()) {
                                this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, offset, len, false));
                            }
                        }
                    }
                    long startTime = System.currentTimeMillis();
                    this.m_memFile.waitForWriteBuffer(2000L);
                    long endTime = System.currentTimeMillis();
                    waitTime += endTime - startTime;
                    this.setIOPending(false);
                    if (this.hasDebug()) {
                        Debug.println("MemCachedNetworkFile waited " + (endTime - startTime) + "ms for writeable buffer");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                writeSts = this.m_memFile.writeBytes(buf, len, pos, offset);
                if (writeSts == MemoryStorableFile.SaveableStatus.Saveable) {
                    MemorySegmentInfo memorySegmentInfo = this.m_memFile;
                    synchronized (memorySegmentInfo) {
                        if (!this.m_memFile.isQueued()) {
                            this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, offset, len, false));
                        }
                    }
                    writeDone = true;
                } else if (writeSts == MemoryStorableFile.SaveableStatus.Buffering) {
                    writeDone = true;
                }
                if (!writeDone || !this.hasDebug()) continue;
                Debug.println("MemCachedNetworkFile waited " + waitTime + "ms for write buffer, writeSts=" + writeSts.name());
            }
        }
        this.incrementWriteCount();
        long fileLen = this.m_memFile.getFileLength();
        if (fileLen != -1L) {
            this.updateFileSize(fileLen, -1L);
        }
    }

    @Override
    public void flushFile() throws IOException {
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        return 0L;
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.getGrantedAccess() == NetworkFile.Access.READ_ONLY) {
            throw new AccessDeniedException("File is read-only");
        }
        this.m_memFile.truncate(siz);
        this.updateFileSize(siz, siz);
        this.incrementWriteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile() {
        MemoryBuffer updData;
        this.setClosed(true);
        if (this.getWriteCount() > 0 && (updData = this.m_memFile.dataToSave()) != null) {
            this.m_memFile.closeFile();
            MemorySegmentInfo memorySegmentInfo = this.m_memFile;
            synchronized (memorySegmentInfo) {
                if (!this.m_memFile.isQueued()) {
                    this.getLoader().queueFileRequest(this.createFileRequest(FileRequest.RequestType.Save, updData.getFileOffset(), updData.getUsedLength(), false));
                }
            }
        }
    }

    protected MemoryBuffer loadOutOfSequence(long fileOff, int len) {
        return null;
    }
}

