/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.db;

import java.util.Date;

public class RetentionDetails {
    private int m_fid;
    private long m_startRetain;
    private long m_endRetain;

    public RetentionDetails(int fid, long endTime) {
        this.m_fid = fid;
        this.m_startRetain = -1L;
        this.m_endRetain = endTime;
    }

    public RetentionDetails(int fid, long startTime, long endTime) {
        this.m_fid = fid;
        this.m_startRetain = startTime;
        this.m_endRetain = endTime;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final boolean hasStartTime() {
        return this.m_startRetain != -1L;
    }

    public final long getStartTime() {
        return this.m_startRetain;
    }

    public final long getEndTime() {
        return this.m_endRetain;
    }

    public final boolean isWithinRetentionPeriod(long timeNow) {
        return (!this.hasStartTime() || timeNow >= this.getStartTime()) && timeNow <= this.getEndTime();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[FID=");
        str.append(this.getFileId());
        str.append(",Start=");
        if (this.hasStartTime()) {
            str.append(new Date(this.getStartTime()));
        } else {
            str.append("NotSet");
        }
        str.append(",End=");
        str.append(new Date(this.getEndTime()));
        str.append("]");
        return str.toString();
    }
}

