/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.loader.FileSegmentInfo;
import org.filesys.server.filesys.loader.Segment;

public class FileSegment
extends Segment {
    private RandomAccessFile m_tempFile;

    public FileSegment(FileSegmentInfo info, boolean writeable) {
        super(info, writeable);
    }

    @Override
    public long getFileLength() throws IOException {
        if (this.isOpen()) {
            return this.m_tempFile.length();
        }
        return -1L;
    }

    public final FileSegmentInfo getFileInfo() {
        return (FileSegmentInfo)this.getInfo();
    }

    public final String getTemporaryFile() {
        return this.getFileInfo().getTemporaryFile();
    }

    @Override
    public final boolean isOpen() {
        return this.m_tempFile != null;
    }

    public final boolean fileExists() {
        if (this.m_tempFile != null) {
            return true;
        }
        File tempFile = new File(this.getTemporaryFile());
        return tempFile.exists();
    }

    public final void createTemporaryFile() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        tempFile.createNewFile();
    }

    public final void closeFile() throws IOException {
        if (this.m_tempFile != null) {
            this.m_tempFile.close();
            this.m_tempFile = null;
        }
    }

    public final void openFile() throws IOException {
        if (this.m_tempFile == null) {
            this.m_tempFile = new RandomAccessFile(this.getFileInfo().getTemporaryFile(), "rw");
        }
    }

    public final synchronized int readBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_tempFile == null) {
            this.openFile();
        } else {
            this.checkFileDescriptor();
        }
        this.m_tempFile.seek(fileOff);
        int totLen = 0;
        int rdLen = len;
        int bufPos = pos;
        try {
            while (totLen < len && rdLen > 0) {
                if ((rdLen = this.m_tempFile.read(buf, bufPos, rdLen)) <= 0) continue;
                totLen += rdLen;
                bufPos += rdLen;
                rdLen = len - totLen;
            }
        }
        catch (Exception ex) {
            Debug.println("***** FileSegment Read Error *****");
            Debug.println(ex);
        }
        return totLen;
    }

    public final synchronized void writeBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_tempFile == null) {
            this.openFile();
        } else {
            this.checkFileDescriptor();
        }
        long fileLen = this.m_tempFile.length();
        long endpos = fileOff + (long)len;
        if (fileOff > fileLen) {
            this.m_tempFile.setLength(endpos);
        }
        if (len == 0) {
            return;
        }
        this.m_tempFile.seek(fileOff);
        this.m_tempFile.write(buf, pos, len);
        if (!this.getInfo().isUpdated()) {
            this.getInfo().setUpdated(true);
        }
    }

    public final void flush() throws IOException {
        if (this.m_tempFile != null) {
            this.m_tempFile.getFD().sync();
        }
    }

    public final void truncate(long siz) throws IOException {
        if (this.m_tempFile == null) {
            this.openFile();
        }
        this.m_tempFile.setLength(siz);
    }

    public final synchronized void deleteTemporaryFile() throws IOException {
        if (this.m_tempFile != null) {
            throw new IOException("Attempt to delete file segment whilst open");
        }
        if (this.getFileInfo() != null) {
            this.getFileInfo().deleteTemporaryFile();
        }
    }

    public static final FileSegment createSegment(FileSegmentInfo info, String prefix, String fname, File tempDir, boolean writeable) throws IOException {
        File tempFile = File.createTempFile(prefix, fname, tempDir);
        info.setTemporaryFile(tempFile.getAbsolutePath());
        return new FileSegment(info, writeable);
    }

    public static final FileSegment createSegment(FileSegmentInfo info, String fname, File tempDir, boolean writeable) throws IOException {
        File tempFile = new File(tempDir, fname);
        info.setTemporaryFile(tempFile.getAbsolutePath());
        return new FileSegment(info, writeable);
    }

    protected void finalize() {
        if (this.m_tempFile != null) {
            try {
                this.m_tempFile.close();
                this.m_tempFile = null;
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        }
    }

    private final void checkFileDescriptor() throws IOException {
        if (this.m_tempFile != null && this.m_tempFile.getFD() != null && !this.m_tempFile.getFD().valid()) {
            try {
                this.closeFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openFile();
        }
    }
}

