/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.File;
import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.loader.SegmentInfo;

public class FileSegmentInfo
extends SegmentInfo {
    private String m_tempFile;

    public FileSegmentInfo() {
    }

    public FileSegmentInfo(String tempFile) {
        this.setTemporaryFile(tempFile);
    }

    public final String getTemporaryFile() {
        return this.m_tempFile;
    }

    public final void deleteTemporaryFile() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        if (tempFile.exists() && !tempFile.delete()) {
            Debug.println("** Failed to delete " + this.toString() + " **");
            throw new IOException("Failed to delete file " + this.getTemporaryFile());
        }
    }

    @Override
    public long getFileLength() throws IOException {
        File tempFile = new File(this.getTemporaryFile());
        return tempFile.length();
    }

    public final void setTemporaryFile(String tempFile) {
        this.m_tempFile = tempFile;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[File:");
        str.append(this.getTemporaryFile());
        str.append(":");
        str.append(this.hasStatus().name());
        str.append(",");
        if (this.isUpdated()) {
            str.append(",Updated");
        }
        if (this.isQueued()) {
            str.append(",Queued");
        }
        str.append("]");
        return str.toString();
    }
}

