/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.IOException;
import org.filesys.server.filesys.loader.MemoryBuffer;
import org.filesys.server.filesys.loader.MemoryLoadableFile;
import org.filesys.server.filesys.loader.MemorySegmentInfo;
import org.filesys.server.filesys.loader.MemoryStorableFile;
import org.filesys.server.filesys.loader.SegmentInfo;

public class InMemorySegmentInfo
extends MemorySegmentInfo {
    private volatile byte[] m_data;
    private volatile int m_usedLen;
    private boolean m_updated;

    public InMemorySegmentInfo() {
        this.setAllFileData(true);
    }

    public InMemorySegmentInfo(int bufSize) {
        this.m_data = new byte[bufSize];
        this.setAllFileData(true);
    }

    public InMemorySegmentInfo(byte[] dataByts) {
        this.m_data = dataByts;
        this.m_usedLen = this.m_data.length;
        this.setAllFileData(true);
    }

    public InMemorySegmentInfo(byte[] dataByts, boolean allData) {
        this.m_data = dataByts;
        this.m_usedLen = this.m_data.length;
        this.setAllFileData(allData);
    }

    @Override
    public long getFileLength() {
        return this.m_usedLen;
    }

    public long getBufferLength() throws IOException {
        if (this.m_data != null) {
            return this.m_data.length;
        }
        return 0L;
    }

    public final byte[] getFileData() {
        return this.m_data;
    }

    public final int getUsedLength() {
        return this.m_usedLen;
    }

    public final void setUsedLength(int usedLen) {
        this.m_usedLen = usedLen;
    }

    @Override
    public void addFileData(MemoryBuffer fileData) {
        this.m_data = fileData.getData();
        this.m_usedLen = fileData.getUsedLength();
        this.setStatus(SegmentInfo.State.Available);
    }

    @Override
    public MemoryLoadableFile.LoadableStatus hasDataFor(long fileOff, int len) {
        if (this.hasStatus() == SegmentInfo.State.Initial) {
            return MemoryLoadableFile.LoadableStatus.Loadable;
        }
        if (len > this.getUsedLength()) {
            return MemoryLoadableFile.LoadableStatus.NotAvailable;
        }
        long endOff = fileOff + (long)len;
        long dataEnd = this.getUsedLength();
        if (fileOff < dataEnd && endOff <= dataEnd) {
            return MemoryLoadableFile.LoadableStatus.Available;
        }
        return MemoryLoadableFile.LoadableStatus.NotAvailable;
    }

    @Override
    public boolean closeFile() {
        return this.m_updated;
    }

    @Override
    public final synchronized int readBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.hasDataFor(fileOff, len) != MemoryLoadableFile.LoadableStatus.Available) {
            throw new IOException("Read error, not within current buffer");
        }
        int endOff = (int)(fileOff + (long)len);
        if (endOff > this.getUsedLength()) {
            len = this.getUsedLength();
        }
        System.arraycopy(this.m_data, (int)fileOff, buf, pos, len);
        return len;
    }

    @Override
    public final synchronized MemoryStorableFile.SaveableStatus writeBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        int endPos = (int)(fileOff + (long)len);
        if (this.m_data == null) {
            this.m_data = new byte[endPos];
        } else if (endPos > this.m_data.length) {
            return MemoryStorableFile.SaveableStatus.BufferOverflow;
        }
        System.arraycopy(buf, pos, this.m_data, (int)fileOff, len);
        this.m_updated = true;
        if (endPos > this.m_usedLen) {
            this.setUsedLength(endPos);
            this.setReadableLength(endPos);
        }
        return MemoryStorableFile.SaveableStatus.Buffering;
    }

    @Override
    public final void truncate(long siz) throws IOException {
        if (siz == 0L) {
            this.setUsedLength(0);
        } else if (this.m_data != null && siz > (long)this.m_data.length) {
            byte[] newBuf = new byte[(int)siz];
            if (this.getUsedLength() > 0) {
                System.arraycopy(this.m_data, 0, newBuf, 0, this.getUsedLength());
            }
            this.m_data = newBuf;
        }
        this.m_updated = true;
    }

    @Override
    public MemoryBuffer dataToSave() {
        if (this.m_updated) {
            return new MemoryBuffer(this.m_data, 0L, this.m_usedLen);
        }
        return null;
    }

    @Override
    public void dataSaved(MemoryBuffer memBuf) {
        this.m_updated = false;
    }

    @Override
    public void waitForWriteBuffer(long tmo) {
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[InMemory:");
        str.append(this.m_data);
        str.append(",used=");
        str.append(this.getUsedLength());
        str.append(":");
        str.append(this.hasStatus().name());
        str.append(",");
        if (this.isUpdated()) {
            str.append(",Updated");
        }
        if (this.isQueued()) {
            str.append(",Queued");
        }
        str.append("]");
        return str.toString();
    }
}

