/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.util.ArrayList;
import java.util.List;
import org.filesys.server.filesys.loader.MemoryBuffer;

public class MemoryBufferList {
    private List<MemoryBuffer> m_buffers;
    private long m_nextSeqOffset;

    public MemoryBufferList() {
        this.m_buffers = new ArrayList<MemoryBuffer>();
    }

    public MemoryBufferList(int bufCnt) {
        this.m_buffers = new ArrayList<MemoryBuffer>(bufCnt);
    }

    public final synchronized void addSegment(MemoryBuffer seg) {
        this.m_buffers.add(seg);
        if (seg.getFileOffset() == this.m_nextSeqOffset) {
            this.m_nextSeqOffset += (long)seg.getUsedLength();
        }
    }

    public final synchronized MemoryBuffer getSegmentAt(int idx) {
        if (idx >= 0 && idx <= this.numberOfSegments()) {
            return this.m_buffers.get(idx);
        }
        return null;
    }

    public final synchronized int numberOfSegments() {
        return this.m_buffers.size();
    }

    public final synchronized void removeSegment(MemoryBuffer memBuf) {
        this.m_buffers.remove(memBuf);
    }

    public final synchronized MemoryBuffer removeSegmentAt(int idx) {
        return this.m_buffers.remove(idx);
    }

    public final synchronized int removeSegmentsBefore(long fileOff) {
        if (this.m_buffers == null || this.m_buffers.size() == 0) {
            return 0;
        }
        int segCnt = 0;
        for (int segIdx = this.numberOfSegments() - 1; segIdx >= 0; --segIdx) {
            MemoryBuffer seg = this.m_buffers.get(segIdx);
            if (seg.getFileOffset() + (long)seg.getUsedLength() >= fileOff || seg.hasWriteData()) continue;
            this.m_buffers.remove(segIdx);
            ++segCnt;
        }
        return segCnt;
    }

    public final synchronized int removeOutOfSequenceBuffers() {
        if (this.m_buffers == null || this.m_buffers.size() == 0) {
            return 0;
        }
        int segCnt = 0;
        for (int segIdx = this.numberOfSegments() - 1; segIdx >= 0; --segIdx) {
            MemoryBuffer seg = this.m_buffers.get(segIdx);
            if (!seg.isOutOfSequence()) continue;
            this.m_buffers.remove(segIdx);
            ++segCnt;
        }
        return segCnt;
    }

    public final synchronized void clearSegments() {
        this.m_buffers.clear();
    }

    public final synchronized MemoryBuffer findSegment(long fileOff, int len) {
        if (this.m_buffers == null || this.m_buffers.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.numberOfSegments(); ++i) {
            MemoryBuffer seg = this.m_buffers.get(i);
            if (seg.containsData(fileOff, len) == MemoryBuffer.Contains.None) continue;
            return seg;
        }
        return null;
    }

    public final synchronized MemoryBuffer findSegment(long fileOff) {
        if (this.m_buffers == null || this.m_buffers.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.numberOfSegments(); ++i) {
            MemoryBuffer seg = this.m_buffers.get(i);
            if (fileOff < seg.getFileOffset() || fileOff >= seg.getFileOffset() + (long)seg.getBufferSize()) continue;
            return seg;
        }
        return null;
    }

    public final synchronized boolean hasUpdatedBuffers() {
        if (this.m_buffers == null || this.m_buffers.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.numberOfSegments(); ++i) {
            MemoryBuffer seg = this.m_buffers.get(i);
            if (!seg.hasWriteData()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[MemList:cnt=");
        str.append(this.m_buffers.size());
        str.append("-");
        MemoryBufferList memoryBufferList = this;
        synchronized (memoryBufferList) {
            if (this.m_buffers != null && this.m_buffers.size() > 0) {
                for (MemoryBuffer buf : this.m_buffers) {
                    str.append(buf);
                    str.append(",");
                }
            }
        }
        str.append("]");
        return str.toString();
    }
}

