/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.IOException;
import org.filesys.server.filesys.loader.SegmentInfo;

public abstract class Segment {
    private SegmentInfo m_info;
    private boolean m_writeable;

    public Segment(SegmentInfo info, boolean writeable) {
        this.m_info = info;
        this.m_writeable = writeable;
    }

    public abstract long getFileLength() throws IOException;

    public final SegmentInfo getInfo() {
        return this.m_info;
    }

    public final long getReadableLength() {
        return this.m_info.getReadableLength();
    }

    public final boolean isDataLoading() {
        return this.m_info.hasStatus() != SegmentInfo.State.Initial || this.m_info.isQueued();
    }

    public final boolean isDataAvailable() {
        return this.m_info.hasStatus().ordinal() >= SegmentInfo.State.Available.ordinal() && this.m_info.hasStatus().ordinal() < SegmentInfo.State.Error.ordinal();
    }

    public final SegmentInfo.State hasStatus() {
        return this.m_info.hasStatus();
    }

    public final boolean hasLoadError() {
        return this.m_info.hasStatus() == SegmentInfo.State.Error;
    }

    public final void setReadableLength(long readable) {
        this.m_info.setReadableLength(readable);
    }

    public final void setStatus(SegmentInfo.State sts) {
        this.m_info.setStatus(sts);
    }

    public final synchronized void setStatus(SegmentInfo.State sts, boolean queued) {
        this.m_info.setStatus(sts);
        this.m_info.setQueued(queued);
    }

    public abstract boolean isOpen();

    public final boolean isUpdated() {
        return this.m_info.isUpdated();
    }

    public final boolean isQueued() {
        return this.m_info.isQueued();
    }

    public final synchronized boolean isSaveQueued() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == SegmentInfo.State.SaveWait;
    }

    public final synchronized boolean isSaving() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == SegmentInfo.State.Saving;
    }

    public final synchronized boolean isLoading() {
        return this.m_info.isQueued() && this.m_info.hasStatus() == SegmentInfo.State.Loading;
    }

    public final boolean isWriteable() {
        return this.m_writeable;
    }

    public final synchronized boolean getLoadLock() throws InterruptedException {
        boolean sts = false;
        if (this.isLoading()) {
            this.wait();
        } else {
            this.setStatus(SegmentInfo.State.Loading);
            sts = true;
        }
        return sts;
    }

    public final void waitForData(long tmo, long fileOff, int len) {
        this.m_info.waitForData(tmo, fileOff, len);
    }

    public final void signalDataAvailable() {
        this.m_info.signalDataAvailable();
    }

    public String toString() {
        return this.getInfo().toString();
    }
}

