/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.db.DBDeviceContext;
import org.filesys.server.filesys.db.DBInterface;
import org.filesys.server.filesys.db.LocalDataNetworkFile;
import org.filesys.server.filesys.loader.FileLoader;
import org.filesys.server.filesys.loader.FileLoaderException;
import org.filesys.server.filesys.loader.FileProcessor;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.NamedFileLoader;
import org.springframework.extensions.config.ConfigElement;

public class SimpleFileLoader
implements FileLoader,
NamedFileLoader {
    private String m_rootPath;
    private boolean m_debug;

    @Override
    public EnumSet<DBInterface.Feature> getRequiredDBFeatures() {
        return EnumSet.noneOf(DBInterface.Feature.class);
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public NetworkFile openFile(FileOpenParams params, int fid, int stid, int did, boolean create, boolean dir) throws IOException, FileNotFoundException {
        File file;
        String fullName = FileName.buildPath(this.getRootPath(), params.getPath(), null, File.separatorChar);
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.openFile() fname=" + params.getPath() + ", fid=" + fid + ", did=" + did + ", fullName=" + fullName);
        }
        if (!(file = new File(fullName)).exists()) {
            String mappedPath = FileName.mapPath(this.getRootPath(), params.getPath());
            if (mappedPath == null && !create) {
                throw new FileNotFoundException("File does not exist, " + params.getPath());
            }
            file = new File(mappedPath);
            if (!file.exists() && !create) {
                throw new FileNotFoundException("File does not exist, " + params.getPath());
            }
            fullName = mappedPath;
        }
        if (create) {
            FileWriter newFile = new FileWriter(file);
            newFile.close();
        }
        file = new File(fullName);
        LocalDataNetworkFile netFile = new LocalDataNetworkFile(params.getPath(), fid, did, file);
        netFile.setGrantedAccess(NetworkFile.Access.READ_WRITE);
        return netFile;
    }

    @Override
    public void closeFile(SrvSession sess, NetworkFile netFile) throws IOException {
        netFile.closeFile();
    }

    @Override
    public void deleteFile(String fname, int fid, int stid) throws IOException {
        String name;
        File delFile;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.deleteFile() fname=" + fname + ", fid=" + fid);
        }
        if ((delFile = new File(name = FileName.buildPath(this.getRootPath(), fname, null, File.separatorChar))).exists() && delFile.isFile()) {
            delFile.delete();
        }
    }

    @Override
    public void createDirectory(String dir, int fid, int parentId) throws IOException {
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.createDirectory() dir=" + dir + ", fid=" + fid);
        }
        String dirname = FileName.buildPath(this.getRootPath(), dir, null, File.separatorChar);
        File newDir = new File(dirname);
        newDir.mkdir();
    }

    @Override
    public void deleteDirectory(String dir, int fid) throws IOException {
        String mappedPath;
        String dirname;
        File delDir;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.deleteDirectory() dir=" + dir + ", fid=" + fid);
        }
        if ((delDir = new File(dirname = FileName.buildPath(this.getRootPath(), dir, null, File.separatorChar))).exists() && delDir.isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        } else if (!delDir.exists() && (mappedPath = FileName.mapPath(this.getRootPath(), dir)) != null && (delDir = new File(mappedPath)).isDirectory()) {
            String[] fileList = delDir.list();
            if (fileList != null && fileList.length > 0) {
                throw new AccessDeniedException("Directory not empty");
            }
            delDir.delete();
        }
    }

    @Override
    public void setFileInformation(String path, int fid, FileInfo finfo) throws IOException {
    }

    @Override
    public void renameFileDirectory(String curName, int fid, String newName, FileState fstate, boolean isdir) throws IOException {
        String newPath;
        File newFile;
        String curPath;
        File curFile;
        if (this.m_debug) {
            Debug.println("SimpleFileLoader.renameFileDirectory() curName=" + curName + ", fid=" + fid + ", newName=" + newName);
        }
        if (!(curFile = new File(curPath = FileName.buildPath(this.getRootPath(), curName, null, File.separatorChar))).renameTo(newFile = new File(newPath = FileName.buildPath(this.getRootPath(), newName, null, File.separatorChar)))) {
            throw new IOException("Rename " + curPath + " to " + newPath + " failed");
        }
    }

    protected final String getRootPath() {
        return this.m_rootPath;
    }

    @Override
    public void initializeLoader(ConfigElement params, DeviceContext ctx) throws FileLoaderException {
        ConfigElement nameVal;
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
        if ((nameVal = params.getChild("RootPath")) == null || nameVal.getValue() == null || nameVal.getValue().length() == 0) {
            throw new FileLoaderException("SimpleFileLoader RootPath parameter required");
        }
        this.m_rootPath = nameVal.getValue();
        File root = new File(this.m_rootPath);
        if (!root.exists() || root.isFile()) {
            throw new FileLoaderException("SimpleFileLoader RootPath does not exist or is not a directory, " + this.m_rootPath);
        }
    }

    @Override
    public final void queueFileRequest(FileRequest fileReq) {
    }

    @Override
    public void startLoader(DeviceContext ctx) {
    }

    @Override
    public void shutdownLoader(boolean immediate) {
    }

    @Override
    public boolean supportsStreams() {
        return false;
    }

    @Override
    public void addFileProcessor(FileProcessor fileProc) throws FileLoaderException {
        throw new FileLoaderException("File processors not supported");
    }

    @Override
    public final void setContext(DBDeviceContext dbCtx) {
    }
}

