/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import org.filesys.server.filesys.cache.FileState;
import org.filesys.server.filesys.loader.FileRequest;
import org.filesys.server.filesys.loader.FileSegmentInfo;
import org.filesys.server.filesys.loader.FileStateFileRequest;

public class SingleFileRequest
extends FileStateFileRequest {
    private int m_fid;
    private int m_stid;
    private int m_seqNo = -1;
    private String m_tempPath;
    private String m_virtPath;

    public SingleFileRequest(FileRequest.RequestType typ, int fid, int stid, String tempPath, String virtPath, FileState state) {
        super(typ, state);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = tempPath;
        this.m_virtPath = virtPath;
    }

    public SingleFileRequest(FileRequest.RequestType typ, int fid, int stid, FileSegmentInfo segInfo, String virtPath, FileState state) {
        super(typ, state);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = segInfo.getTemporaryFile();
        this.m_virtPath = virtPath;
        segInfo.setQueued(true);
    }

    public SingleFileRequest(FileRequest.RequestType typ, int fid, int stid, String tempPath, String virtPath, int seq, FileState state) {
        super(typ, state);
        this.m_fid = fid;
        this.m_stid = stid;
        this.m_tempPath = tempPath;
        this.m_virtPath = virtPath;
        this.m_seqNo = seq;
    }

    public final int getFileId() {
        return this.m_fid;
    }

    public final int getStreamId() {
        return this.m_stid;
    }

    public final int getSequenceNumber() {
        return this.m_seqNo;
    }

    public final String getVirtualPath() {
        return this.m_virtPath;
    }

    public final String getTemporaryFile() {
        return this.m_tempPath;
    }

    public final void setSequenceNumber(int id) {
        this.m_seqNo = id;
    }

    public final void setVirtualPath(String path) {
        this.m_virtPath = path;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[FID=");
        str.append(this.getFileId());
        str.append(",STID=");
        str.append(this.getStreamId());
        str.append(",Seq=");
        str.append(this.getSequenceNumber());
        if (this.isTransaction()) {
            str.append(",Tran=");
            str.append(this.getTransactionId());
            if (this.isLastTransactionFile()) {
                str.append("(Last)");
            }
        }
        str.append(",");
        str.append(this.isType().name());
        str.append(":");
        str.append(this.getTemporaryFile());
        str.append(",");
        str.append(this.getVirtualPath());
        str.append(",State=");
        str.append(this.getFileState());
        if (this.hasAttributes()) {
            str.append(",Attr=");
            str.append(this.getAttributes());
        }
        str.append("]");
        return str.toString();
    }
}

