/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.filesys.loader;

import java.io.IOException;
import java.util.EnumSet;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.loader.MemoryBuffer;
import org.filesys.server.filesys.loader.MemoryBufferList;
import org.filesys.server.filesys.loader.MemoryLoadableFile;
import org.filesys.server.filesys.loader.MemorySegmentInfo;
import org.filesys.server.filesys.loader.MemoryStorableFile;
import org.filesys.server.filesys.loader.SegmentInfo;

public class StreamSegmentInfo
extends MemorySegmentInfo {
    public static final int StreamBufferCount = 4;
    private static final boolean m_debug = false;
    private volatile MemoryBufferList m_rxBuffers = new MemoryBufferList(4);
    private volatile MemoryBufferList m_txBuffers = new MemoryBufferList(4);
    private volatile MemoryBufferList m_outOfSeqBuffers;
    private long m_fileLen;
    private volatile long m_lastReadOffset;
    private volatile long m_nextWriteOffset;
    private volatile long m_nextAllocOffset;
    private int m_bufferSize = 0x200000;
    private int m_maxBuffers = 4;

    public StreamSegmentInfo() {
        super(EnumSet.of(SegmentInfo.Flags.Streamed));
    }

    public StreamSegmentInfo(int bufSize) {
        super(EnumSet.of(SegmentInfo.Flags.Streamed));
        this.m_bufferSize = bufSize;
    }

    public final boolean hasDebug() {
        return false;
    }

    public final synchronized int getRxBufferCount() {
        return this.m_rxBuffers != null ? this.m_rxBuffers.numberOfSegments() : 0;
    }

    public final synchronized int getFreeRxBufferCount() {
        return this.m_rxBuffers != null ? this.m_maxBuffers - this.m_rxBuffers.numberOfSegments() : 0;
    }

    protected final synchronized long getRxBaseBufferOffset() {
        MemoryBuffer firstBuf;
        if (this.m_rxBuffers != null && this.m_rxBuffers.numberOfSegments() > 0 && (firstBuf = this.m_rxBuffers.getSegmentAt(0)) != null) {
            return firstBuf.getFileOffset();
        }
        return 0L;
    }

    public final synchronized int getTxBufferCount() {
        return this.m_txBuffers != null ? this.m_txBuffers.numberOfSegments() : 0;
    }

    public final synchronized int getFreeTxBufferCount() {
        return this.m_txBuffers != null ? this.m_maxBuffers - this.m_txBuffers.numberOfSegments() : 0;
    }

    public final MemoryBufferList getRxBufferList() {
        return this.m_rxBuffers;
    }

    public final MemoryBufferList getTxBufferList() {
        return this.m_txBuffers;
    }

    public final long getNextWriteOffset() {
        return this.m_nextWriteOffset;
    }

    public final synchronized boolean hasFreeRxBufferSlots() {
        if (this.m_rxBuffers == null) {
            return true;
        }
        return this.m_rxBuffers.numberOfSegments() < this.m_maxBuffers;
    }

    public final synchronized boolean hasFreeTxBufferSlots() {
        if (this.m_txBuffers == null) {
            return true;
        }
        return this.m_txBuffers.numberOfSegments() < this.m_maxBuffers;
    }

    @Override
    public long getFileLength() {
        return this.m_fileLen;
    }

    public final void setFileLength(long fileLen) {
        this.m_fileLen = fileLen;
    }

    public final int getBufferSize() {
        return this.m_bufferSize;
    }

    public final void setBufferSize(int bufSize) {
        this.m_bufferSize = bufSize;
    }

    protected final boolean hasOutOfSequenceData() {
        return this.m_outOfSeqBuffers != null && this.m_outOfSeqBuffers.numberOfSegments() > 0;
    }

    public final MemoryBuffer getFileData(long fileOffset, int len) {
        return this.m_rxBuffers.findSegment(fileOffset, len);
    }

    public final void removeFileData(MemoryBuffer memBuf) {
        this.m_rxBuffers.removeSegment(memBuf);
    }

    @Override
    public MemoryLoadableFile.LoadableStatus hasDataFor(long fileOff, int len) {
        long endOff;
        int idx;
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: hasDataFor fileOff=" + fileOff + ", len=" + len + " (lastRxOff=" + this.m_lastReadOffset + ", fileLen=" + this.m_fileLen + ")");
        }
        long seqReadEndOff = this.getRxBaseBufferOffset() + (long)(this.getBufferSize() * this.m_maxBuffers);
        if (this.m_rxBuffers.numberOfSegments() == 0 && this.m_fileLen > 0L) {
            if (fileOff == 0L) {
                return MemoryLoadableFile.LoadableStatus.Loadable;
            }
            if (len <= this.getShortReadSize() || fileOff > seqReadEndOff) {
                return MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq;
            }
            return MemoryLoadableFile.LoadableStatus.Loadable;
        }
        MemoryLoadableFile.LoadableStatus dataSts = MemoryLoadableFile.LoadableStatus.NotAvailable;
        if (fileOff < seqReadEndOff) {
            for (idx = 0; idx < this.m_rxBuffers.numberOfSegments() && dataSts != MemoryLoadableFile.LoadableStatus.Available; ++idx) {
                MemoryBuffer curBuf = this.m_rxBuffers.getSegmentAt(idx);
                MemoryBuffer.Contains contains = curBuf.containsData(fileOff, len);
                if (contains == MemoryBuffer.Contains.All) {
                    dataSts = MemoryLoadableFile.LoadableStatus.Available;
                    continue;
                }
                if (contains != MemoryBuffer.Contains.Partial) continue;
                long newOff = curBuf.getFileOffset() + (long)curBuf.getUsedLength();
                len -= (int)(newOff - fileOff);
                fileOff = newOff;
                dataSts = MemoryLoadableFile.LoadableStatus.Loadable;
            }
            if (dataSts == MemoryLoadableFile.LoadableStatus.NotAvailable) {
                dataSts = MemoryLoadableFile.LoadableStatus.Loadable;
            }
        }
        if (dataSts == MemoryLoadableFile.LoadableStatus.NotAvailable && fileOff < this.getFileLength() && (endOff = fileOff + (long)len) <= this.getFileLength()) {
            if (this.hasOutOfSequenceData()) {
                for (idx = 0; idx < this.m_outOfSeqBuffers.numberOfSegments() && dataSts != MemoryLoadableFile.LoadableStatus.Available; ++idx) {
                    MemoryBuffer curBuf = this.m_outOfSeqBuffers.getSegmentAt(idx);
                    MemoryBuffer.Contains contains = curBuf.containsData(fileOff, len);
                    if (contains != MemoryBuffer.Contains.All) continue;
                    dataSts = MemoryLoadableFile.LoadableStatus.Available;
                    if (!this.hasDebug()) continue;
                    Debug.println("StreamSegmentInfo: Cached out of seq data available for fileOff=" + fileOff + ", len=" + len);
                }
            }
            if (dataSts != MemoryLoadableFile.LoadableStatus.Available) {
                dataSts = MemoryLoadableFile.LoadableStatus.LoadableOutOfSeq;
            }
        }
        if (dataSts == MemoryLoadableFile.LoadableStatus.Loadable && this.isQueued()) {
            dataSts = MemoryLoadableFile.LoadableStatus.Loading;
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Loading seg=" + this);
            }
        }
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: hasDataFor sts=" + dataSts.name());
            if (this.hasDebug()) {
                Debug.println("  RxBuffers=" + this.m_rxBuffers);
                Debug.println("  OutOfSeq =" + this.m_outOfSeqBuffers);
            }
        }
        return dataSts;
    }

    @Override
    public void addFileData(MemoryBuffer fileData) {
        if (this.hasDataFor(fileData.getFileOffset(), fileData.getUsedLength()) == MemoryLoadableFile.LoadableStatus.Available) {
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Already loaded data for buf=" + fileData);
            }
            return;
        }
        if (!fileData.isOutOfSequence()) {
            this.m_rxBuffers.addSegment(fileData);
        } else {
            if (this.m_outOfSeqBuffers == null) {
                this.m_outOfSeqBuffers = new MemoryBufferList();
            }
            this.m_outOfSeqBuffers.addSegment(fileData);
        }
        long newLen = fileData.getFileOffset() + (long)fileData.getUsedLength();
        if (newLen > this.m_fileLen) {
            this.m_fileLen = newLen;
        }
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: addFileData fileData=" + fileData + ", fileLen=" + this.m_fileLen + ", buffers=" + this.m_rxBuffers.numberOfSegments());
        }
    }

    @Override
    public int readBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        MemoryBuffer readBuf;
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: readBytes fileOff=" + fileOff + ", len=" + len);
        }
        if ((readBuf = this.m_rxBuffers.findSegment(fileOff, len)) == null) {
            if (this.m_outOfSeqBuffers != null) {
                readBuf = this.m_outOfSeqBuffers.findSegment(fileOff, len);
            }
            if (readBuf == null) {
                return 0;
            }
        }
        int rdlen = len;
        if (readBuf.containsData(fileOff, len) == MemoryBuffer.Contains.All) {
            rdlen = readBuf.readBytes(buf, len, pos, fileOff);
        } else {
            rdlen = readBuf.readBytes(buf, len, pos, fileOff);
            pos += rdlen;
            readBuf = this.m_rxBuffers.findSegment(fileOff += (long)rdlen, len -= rdlen);
            if (readBuf != null) {
                rdlen += readBuf.readBytes(buf, len, pos, fileOff);
            }
        }
        int segCnt = 0;
        if (!readBuf.isOutOfSequence()) {
            this.m_lastReadOffset = fileOff;
            segCnt = this.m_rxBuffers.removeSegmentsBefore(this.m_lastReadOffset);
        } else if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: Read using out of sequence data - " + readBuf);
        }
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: readBytes len=" + len + ", rdlen=" + rdlen + ", removed=" + segCnt + ", buffers=" + this.m_rxBuffers.numberOfSegments());
        }
        if (this.m_lastReadOffset + (long)rdlen >= this.getFileLength()) {
            this.m_rxBuffers.clearSegments();
            this.m_lastReadOffset = 0L;
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Read to end of file, reset buffers/read offset");
            }
        }
        return rdlen;
    }

    @Override
    public boolean closeFile() {
        this.setFileClosed(true);
        this.m_rxBuffers.clearSegments();
        return this.m_txBuffers.hasUpdatedBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryStorableFile.SaveableStatus writeBytes(byte[] buf, int len, int pos, long fileOff) throws IOException {
        long fileLen;
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: writeBytes fileOff=" + fileOff + ", len=" + len);
        }
        if (fileOff < this.m_nextWriteOffset) {
            throw new IOException("Out of sequence write to streamed file");
        }
        MemoryStorableFile.SaveableStatus wrSts = MemoryStorableFile.SaveableStatus.Buffering;
        MemoryBuffer writeBuf = this.m_txBuffers.findSegment(fileOff);
        if (writeBuf == null) {
            StreamSegmentInfo streamSegmentInfo = this;
            synchronized (streamSegmentInfo) {
                if (this.m_txBuffers.numberOfSegments() >= this.m_maxBuffers) {
                    return MemoryStorableFile.SaveableStatus.MaxBuffers;
                }
                writeBuf = new MemoryBuffer(new byte[this.getBufferSize()], this.nextBufferOffset(), 0);
                this.m_txBuffers.addSegment(writeBuf);
            }
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Add new buffer for write, buf=" + writeBuf + ", buffers=" + this.m_txBuffers.numberOfSegments());
            }
        }
        if (writeBuf != null) {
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Write to buffer " + writeBuf);
            }
            if (this.m_txBuffers.numberOfSegments() == this.m_maxBuffers && writeBuf.canFitData(fileOff, len) != MemoryBuffer.Contains.All) {
                return MemoryStorableFile.SaveableStatus.MaxBuffers;
            }
            int wrlen = writeBuf.writeBytes(buf, len, pos, fileOff);
            if (wrlen < len) {
                len -= wrlen;
                pos += wrlen;
                wrSts = MemoryStorableFile.SaveableStatus.Saveable;
                writeBuf = this.m_txBuffers.findSegment(fileOff += (long)wrlen);
                if (writeBuf == null) {
                    byte[] byts = new byte[this.getBufferSize()];
                    writeBuf = new MemoryBuffer(byts, this.nextBufferOffset(), 0);
                    this.m_txBuffers.addSegment(writeBuf);
                    if (this.hasDebug()) {
                        Debug.println("StreamSegmentInfo: Add new buffer for second write, buf=" + writeBuf + ", buffers=" + this.m_txBuffers.numberOfSegments());
                    }
                }
                wrlen += writeBuf.writeBytes(buf, len, pos, fileOff);
            } else if (writeBuf.isFull()) {
                wrSts = MemoryStorableFile.SaveableStatus.Saveable;
            }
        } else if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: No buffer for write, fileOff=" + fileOff + ", len=" + len);
        }
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: writeBytes sts=" + wrSts.name());
        }
        if ((fileLen = fileOff + (long)len) > this.m_fileLen) {
            this.m_fileLen = fileLen;
        }
        return wrSts;
    }

    @Override
    public void truncate(long siz) throws IOException {
        if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: truncate siz=" + siz);
        }
        if (siz == 0L) {
            this.m_rxBuffers.clearSegments();
            this.m_txBuffers.clearSegments();
            this.m_fileLen = 0L;
        } else if (siz < this.m_fileLen) {
            this.m_fileLen = siz;
            for (int idx = this.m_txBuffers.numberOfSegments() - 1; idx >= 0; --idx) {
                MemoryBuffer curBuf = this.m_txBuffers.getSegmentAt(idx);
                if (curBuf.getFileOffset() >= this.m_fileLen) {
                    this.m_txBuffers.removeSegment(curBuf);
                    continue;
                }
                if (curBuf.containsData(this.m_fileLen, 0) != MemoryBuffer.Contains.All) continue;
                curBuf.setUsedLength((int)(this.m_fileLen - curBuf.getFileOffset()));
            }
        }
    }

    @Override
    public MemoryBuffer dataToSave() {
        if (this.m_txBuffers.numberOfSegments() == 0) {
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: dataToSave(), no buffers");
            }
            return null;
        }
        MemoryBuffer firstBuf = this.m_txBuffers.getSegmentAt(0);
        if (firstBuf != null && (firstBuf.isFull() || this.isClosed()) && firstBuf.getFileOffset() == this.m_nextWriteOffset) {
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: Data to save buf=" + firstBuf + ", isClosed=" + this.isClosed());
            }
            return firstBuf;
        }
        if (this.m_txBuffers.numberOfSegments() > 0 && this.hasDebug()) {
            Debug.println("StreamSegmentInfo: dataToSave(), no data, nextWrite=" + this.getNextWriteOffset() + ", firstBuf=" + firstBuf);
            Debug.println("StreamSegmentInfo: buffers=" + this.m_txBuffers);
        }
        return null;
    }

    @Override
    public void dataSaved(MemoryBuffer memBuf) {
        MemoryBuffer remBuf = this.m_txBuffers.removeSegmentAt(0);
        if (remBuf != null && remBuf.getFileOffset() == memBuf.getFileOffset()) {
            this.m_nextWriteOffset += (long)memBuf.getUsedLength();
            this.signalWriteBufferAvailable();
            if (this.hasDebug()) {
                Debug.println("StreamSegmentInfo: dataSaved nextOffset=" + this.m_nextWriteOffset);
            }
        } else if (this.hasDebug()) {
            Debug.println("StreamSegmentInfo: ** Removed wrong segment from the list head");
            Debug.println("  buffers=" + this.m_txBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForWriteBuffer(long tmo) {
        if (this.m_txBuffers.numberOfSegments() >= this.m_maxBuffers) {
            StreamSegmentInfo streamSegmentInfo = this;
            synchronized (streamSegmentInfo) {
                try {
                    this.wait(tmo);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final synchronized void signalWriteBufferAvailable() {
        this.notifyAll();
    }

    protected final synchronized long nextBufferOffset() {
        long nextOff = this.m_nextAllocOffset;
        this.m_nextAllocOffset += (long)this.getBufferSize();
        return nextOff;
    }

    @Override
    public boolean isDataAvailable(long fileOff, int len) {
        return this.hasDataFor(fileOff, len) == MemoryLoadableFile.LoadableStatus.Available;
    }

    public final void resetTxState() {
        this.m_txBuffers.clearSegments();
        this.m_nextWriteOffset = 0L;
        this.m_nextAllocOffset = 0L;
        this.setFlag(SegmentInfo.Flags.DeleteOnSave, false);
        this.setFlag(SegmentInfo.Flags.WriteError, false);
        this.setFlag(SegmentInfo.Flags.Updated, false);
        this.setFlag(SegmentInfo.Flags.FileClosed, false);
    }

    public final void resetRxState(boolean clearOutOfSeq) {
        this.m_rxBuffers.clearSegments();
        if (clearOutOfSeq) {
            this.m_outOfSeqBuffers.clearSegments();
        }
        this.m_lastReadOffset = 0L;
        this.setFlag(SegmentInfo.Flags.ReadError, false);
        this.setFlag(SegmentInfo.Flags.FileClosed, false);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Stream:rxbufs=");
        str.append(this.m_rxBuffers);
        if (this.m_outOfSeqBuffers != null) {
            str.append(",outOfSeq=");
            str.append(this.m_outOfSeqBuffers);
        }
        str.append(",txbufs=");
        str.append(this.m_txBuffers);
        str.append(",len=");
        str.append(this.getFileLength());
        str.append(":");
        str.append(this.hasStatus().name());
        str.append(",");
        if (this.isUpdated()) {
            str.append(",Updated");
        }
        if (this.isQueued()) {
            str.append(",Queued");
        }
        if (this.m_nextAllocOffset != 0L) {
            str.append(",nextAlloc=");
            str.append(this.m_nextAllocOffset);
        }
        if (this.m_nextWriteOffset != 0L) {
            str.append(",nextWrite=");
            str.append(this.m_nextWriteOffset);
        }
        str.append("]");
        return str.toString();
    }
}

