/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.server.memory;

import java.util.ArrayList;
import java.util.List;

public class ByteBufferList {
    private int m_bufSize;
    private int m_initAlloc;
    private int m_maxAlloc;
    private List<byte[]> m_bufList;
    private int m_allocCount;
    private long m_statAllocs;
    private long m_statWaits;
    private long m_statWaitExpired;

    public ByteBufferList(int bufSize, int initAlloc, int maxAlloc) {
        this.m_bufSize = bufSize;
        this.m_initAlloc = initAlloc;
        this.m_maxAlloc = maxAlloc;
        if (this.m_bufSize <= 0 || this.m_initAlloc < 0 || this.m_maxAlloc <= 0 || this.m_initAlloc > this.m_maxAlloc) {
            throw new RuntimeException("Invalid ByteBufferList parameters, size=" + this.m_bufSize + ", alloc=" + this.m_initAlloc + "/" + this.m_maxAlloc);
        }
        this.allocateInitialBuffers();
    }

    public final int getBufferSize() {
        return this.m_bufSize;
    }

    public final int getInitialAllocation() {
        return this.m_initAlloc;
    }

    public final int getMaximumAllocation() {
        return this.m_maxAlloc;
    }

    public final int getAvailableCount() {
        return this.m_bufList.size();
    }

    public final int getAllocatedCount() {
        return this.m_allocCount;
    }

    public final long getStatAllocationCounter() {
        return this.m_statAllocs;
    }

    public final long getStatAllocationWaits() {
        return this.m_statWaits;
    }

    public final long getStatAllocationWaitsExpired() {
        return this.m_statWaitExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] allocateBuffer(long waitTime) {
        byte[] buf = null;
        List<byte[]> list = this.m_bufList;
        synchronized (list) {
            if (this.m_bufList.size() > 0) {
                buf = this.m_bufList.remove(0);
                ++this.m_allocCount;
                ++this.m_statAllocs;
            } else if (this.m_allocCount < this.m_maxAlloc) {
                buf = new byte[this.m_bufSize];
                ++this.m_allocCount;
                ++this.m_statAllocs;
            } else if (waitTime > 0L) {
                try {
                    ++this.m_statWaits;
                    this.m_bufList.wait(waitTime);
                    if (this.m_bufList.size() > 0) {
                        buf = this.m_bufList.remove(0);
                        ++this.m_allocCount;
                    } else {
                        ++this.m_statWaitExpired;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseBuffer(byte[] buf) {
        if (buf == null || buf.length != this.m_bufSize) {
            return;
        }
        List<byte[]> list = this.m_bufList;
        synchronized (list) {
            if (this.m_bufList.size() == 0) {
                this.m_bufList.notify();
            }
            this.m_bufList.add(buf);
            --this.m_allocCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int shrinkList() {
        int removedCnt = 0;
        if (this.m_bufList.size() > this.m_initAlloc) {
            List<byte[]> list = this.m_bufList;
            synchronized (list) {
                while (this.m_bufList.size() > this.m_initAlloc) {
                    this.m_bufList.remove(0);
                    ++removedCnt;
                }
            }
        }
        return removedCnt;
    }

    private final void allocateInitialBuffers() {
        this.m_bufList = this.getInitialAllocation() > 0 ? new ArrayList<byte[]>(this.getInitialAllocation()) : new ArrayList<byte[]>();
        if (this.getInitialAllocation() > 0) {
            for (int i = 0; i < this.getInitialAllocation(); ++i) {
                this.m_bufList.add(new byte[this.getBufferSize()]);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Bufsize=");
        str.append(this.getBufferSize());
        str.append(",Init=");
        str.append(this.getInitialAllocation());
        str.append(",Max=");
        str.append(this.getMaximumAllocation());
        str.append(",Avail=");
        str.append(this.getAvailableCount());
        str.append(",Alloc=");
        str.append(this.getAllocatedCount());
        str.append(",Stats=");
        str.append(this.getStatAllocationCounter());
        str.append("/");
        str.append(this.getStatAllocationWaits());
        str.append("/");
        str.append(this.getStatAllocationWaitsExpired());
        str.append("]");
        return str.toString();
    }
}

