/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb;

import java.util.BitSet;
import org.filesys.smb.Dialect;

public class DialectSelector {
    private BitSet m_dialects;

    public DialectSelector() {
        this.m_dialects = new BitSet(13);
    }

    public DialectSelector(DialectSelector diaSel) {
        this.copyFrom(diaSel);
    }

    public void AddDialect(int idx) throws ArrayIndexOutOfBoundsException {
        this.m_dialects.set(idx);
    }

    public void ClearAll() {
        this.m_dialects.clear();
    }

    public void enableAll() {
        this.m_dialects.set(0, 13);
    }

    public void enableUpTo(int maxDialect) {
        if (maxDialect < 0 || maxDialect > 14) {
            maxDialect = 8;
        }
        this.m_dialects.set(0, maxDialect);
    }

    public void copyFrom(DialectSelector dsel) {
        this.m_dialects = (BitSet)dsel.getBitSet().clone();
    }

    public boolean hasDialect(int idx) throws ArrayIndexOutOfBoundsException {
        return this.m_dialects.get(idx);
    }

    public boolean hasCore() {
        return this.hasDialect(0) || this.hasDialect(1);
    }

    public boolean hasLanMan() {
        return this.hasDialect(2) || this.hasDialect(4) || this.hasDialect(3) || this.hasDialect(5) || this.hasDialect(6);
    }

    public boolean hasNT() {
        return this.hasDialect(7);
    }

    public boolean hasSMB2() {
        return this.hasDialect(10) || this.hasDialect(8);
    }

    public boolean hasSMB3() {
        return this.hasDialect(11) || this.hasDialect(12) || this.hasDialect(13);
    }

    public void RemoveDialect(int idx) throws ArrayIndexOutOfBoundsException {
        this.m_dialects.clear(idx);
    }

    public final int findHighestDialect(DialectSelector reqSelector) {
        for (int idx = 13; idx >= 0; --idx) {
            if (!this.hasDialect(idx) || !reqSelector.hasDialect(idx)) continue;
            return idx;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.m_dialects.isEmpty();
    }

    protected BitSet getBitSet() {
        return this.m_dialects;
    }

    public final void maskWith(DialectSelector maskSet) {
        this.m_dialects.and(maskSet.getBitSet());
    }

    public final void enableGroup(DialectGroup diaGroup) {
        switch (diaGroup) {
            case SMBv1: {
                this.m_dialects.set(0, 8);
                break;
            }
            case SMBv2: {
                this.m_dialects.set(8, 11);
                break;
            }
            case SMBv3: {
                this.m_dialects.set(11, 14);
            }
        }
    }

    public final void disableGroup(DialectGroup diaGroup) {
        switch (diaGroup) {
            case SMBv1: {
                this.m_dialects.set(0, 8, false);
                break;
            }
            case SMBv2: {
                this.m_dialects.set(8, 11, false);
                break;
            }
            case SMBv3: {
                this.m_dialects.set(11, 14, false);
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        for (int i = 0; i < this.m_dialects.size(); ++i) {
            if (!this.hasDialect(i)) continue;
            str.append(Dialect.DialectTypeString(i));
            str.append(",");
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        str.append("]");
        return str.toString();
    }

    public static enum DialectGroup {
        SMBv1,
        SMBv2,
        SMBv3;

    }
}

