/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc;

import java.util.ArrayList;
import java.util.List;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEReadable;
import org.filesys.smb.dcerpc.DCEWriteable;

public abstract class DCEList {
    private int m_infoLevel;
    private List<Object> m_dceObjects;

    protected DCEList() {
        this.m_dceObjects = new ArrayList<Object>();
    }

    protected DCEList(int infoLevel) {
        this.m_dceObjects = new ArrayList<Object>();
        this.m_infoLevel = infoLevel;
    }

    protected DCEList(DCEBuffer buf) throws DCEBufferException {
        this.m_infoLevel = buf.getInt();
        buf.skipBytes(4);
        this.m_dceObjects = buf.getPointer() != 0 ? new ArrayList<Object>() : null;
    }

    public final int getInformationLevel() {
        return this.m_infoLevel;
    }

    public final int numberOfEntries() {
        return this.m_dceObjects != null ? this.m_dceObjects.size() : 0;
    }

    public final List<Object> getList() {
        return this.m_dceObjects;
    }

    public final Object getElement(int idx) {
        if (this.m_dceObjects == null || idx < 0 || idx >= this.m_dceObjects.size()) {
            return null;
        }
        return this.m_dceObjects.get(idx);
    }

    protected final boolean containerIsValid() {
        return this.m_dceObjects != null;
    }

    protected final void addObject(Object obj) {
        this.m_dceObjects.add(obj);
    }

    protected final void setInformationLevel(int infoLevel) {
        this.m_infoLevel = infoLevel;
    }

    protected final void setList(List<Object> list) {
        this.m_dceObjects = list;
    }

    protected abstract DCEReadable getNewObject();

    public void readList(DCEBuffer buf) throws DCEBufferException {
        int elemCnt;
        if (!this.containerIsValid()) {
            return;
        }
        int numEntries = buf.getInt();
        if (buf.getPointer() != 0 && (elemCnt = buf.getInt()) > 0) {
            while (elemCnt-- > 0) {
                DCEReadable element = this.getNewObject();
                this.addObject(element);
                element.readObject(buf);
            }
            for (int i = 0; i < this.numberOfEntries(); ++i) {
                DCEReadable element = (DCEReadable)this.getList().get(i);
                element.readStrings(buf);
            }
        }
    }

    public final void writeList(DCEBuffer buf) throws DCEBufferException {
        buf.putInt(this.getInformationLevel());
        buf.putInt(this.getInformationLevel());
        if (this.m_dceObjects != null) {
            buf.putPointer(true);
            buf.putInt(this.m_dceObjects.size());
            buf.putPointer(true);
            buf.putInt(this.m_dceObjects.size());
            DCEBuffer strBuf = new DCEBuffer();
            for (int i = 0; i < this.m_dceObjects.size(); ++i) {
                DCEWriteable object = (DCEWriteable)this.m_dceObjects.get(i);
                object.writeObject(buf, strBuf);
            }
            buf.putBuffer(strBuf);
            buf.putInt(this.m_dceObjects.size());
            buf.putInt(0);
        } else {
            buf.putZeroInts(4);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Level=");
        str.append(this.getInformationLevel());
        str.append(",Entries=");
        str.append(this.numberOfEntries());
        str.append(",Class=");
        str.append(this.getNewObject().getClass().getName());
        str.append("]");
        return str.toString();
    }
}

